/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.event;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.functions.FloatSupplier;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.IBlastingItem;
import mekanism.common.content.gear.mekasuit.ModuleHydraulicPropulsionUnit;
import mekanism.common.content.gear.mekasuit.ModuleLocomotiveBoostingUnit;
import mekanism.common.item.gear.ItemFreeRunners;
import mekanism.common.registries.MekanismModules;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.StorageUtils;
import moffy.ticex.TicEXConfig;
import moffy.ticex.client.modules.mekanism.MekaPlateModelCache;
import moffy.ticex.item.modifiable.ModifiableMekaSuitArmor;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidType;

public class TicEXMekanismEvent {
    @SubscribeEvent
    public void onEntityAttack(LivingAttackEvent event) {
        Player player;
        FallEnergyInfo info;
        LivingEntity entity = event.getEntity();
        if (event.getAmount() <= 0.0f || !entity.m_6084_()) {
            return;
        }
        if (event.getSource().m_269533_(MekanismTags.DamageTypes.IS_PREVENTABLE_MAGIC)) {
            ItemStack itemStack = entity.m_6844_(EquipmentSlot.HEAD);
        }
        if (event.getSource().m_269533_(DamageTypeTags.f_268549_) && (info = this.getFallAbsorptionEnergyInfo(entity)) != null && this.tryAbsorbAll(event, info.container, info.damageRatio, info.energyCost)) {
            return;
        }
        if (entity instanceof Player && ModifiableMekaSuitArmor.tryAbsorbAll(player = (Player)entity, event.getSource(), event.getAmount())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        if (((Boolean)TicEXConfig.MEKAPLATE_USE_POWER_SHIELD.get()).booleanValue()) {
            Player player;
            float ratioAbsorbed;
            FallEnergyInfo info;
            LivingEntity entity = event.getEntity();
            if (event.getAmount() <= 0.0f || !entity.m_6084_()) {
                return;
            }
            if (event.getSource().m_269533_(DamageTypeTags.f_268549_) && (info = this.getFallAbsorptionEnergyInfo(entity)) != null && this.handleDamage(event, info.container, info.damageRatio, info.energyCost)) {
                return;
            }
            if (entity instanceof Player && (ratioAbsorbed = ModifiableMekaSuitArmor.getDamageAbsorbed(player = (Player)entity, event.getSource(), event.getAmount())) > 0.0f) {
                float damageRemaining = event.getAmount() * Math.max(0.0f, 1.0f - ratioAbsorbed);
                if (damageRemaining <= 0.0f) {
                    event.setCanceled(true);
                } else {
                    event.setAmount(damageRemaining);
                }
            }
        }
    }

    private boolean tryAbsorbAll(LivingAttackEvent event, @Nullable IEnergyContainer energyContainer, FloatSupplier absorptionRatio, FloatingLongSupplier energyCost) {
        if (energyContainer != null && absorptionRatio.getAsFloat() == 1.0f) {
            FloatingLong energyRequirement = energyCost.get().multiply((double)event.getAmount());
            if (energyRequirement.isZero()) {
                event.setCanceled(true);
                return true;
            }
            FloatingLong simulatedExtract = energyContainer.extract(energyRequirement, Action.SIMULATE, AutomationType.MANUAL);
            if (simulatedExtract.equals(energyRequirement)) {
                energyContainer.extract(energyRequirement, Action.EXECUTE, AutomationType.MANUAL);
                event.setCanceled(true);
                return true;
            }
        }
        return false;
    }

    private boolean handleDamage(LivingHurtEvent event, @Nullable IEnergyContainer energyContainer, FloatSupplier absorptionRatio, FloatingLongSupplier energyCost) {
        if (energyContainer != null) {
            float absorption = absorptionRatio.getAsFloat();
            float amount = event.getAmount() * absorption;
            FloatingLong energyRequirement = energyCost.get().multiply((double)amount);
            float ratioAbsorbed = energyRequirement.isZero() ? absorption : absorption * energyContainer.extract(energyRequirement, Action.EXECUTE, AutomationType.MANUAL).divide((double)amount).floatValue();
            if (ratioAbsorbed > 0.0f) {
                float damageRemaining = event.getAmount() * Math.max(0.0f, 1.0f - ratioAbsorbed);
                if (damageRemaining <= 0.0f) {
                    event.setCanceled(true);
                    return true;
                }
                event.setAmount(damageRemaining);
            }
        }
        return false;
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        Player player;
        IModule module;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (module = IModuleHelper.INSTANCE.load((player = (Player)livingEntity).m_6844_(EquipmentSlot.FEET), (IModuleDataProvider)MekanismModules.HYDRAULIC_PROPULSION_UNIT)) != null && module.isEnabled() && Mekanism.keyMap.has(player.m_20148_(), 1)) {
            float boost = ((ModuleHydraulicPropulsionUnit)module.getCustomInstance()).getBoost();
            FloatingLong usage = ((FloatingLong)MekanismConfig.gear.mekaSuitBaseJumpEnergyUsage.get()).multiply((double)(boost / 0.1f));
            IEnergyContainer energyContainer = module.getEnergyContainer();
            if (module.canUseEnergy((LivingEntity)player, energyContainer, usage, false)) {
                IModule boostModule = IModuleHelper.INSTANCE.load(player.m_6844_(EquipmentSlot.LEGS), (IModuleDataProvider)MekanismModules.LOCOMOTIVE_BOOSTING_UNIT);
                if (boostModule != null && boostModule.isEnabled() && ((ModuleLocomotiveBoostingUnit)boostModule.getCustomInstance()).canFunction(boostModule, player)) {
                    boost = (float)Math.sqrt(boost);
                }
                player.m_20256_(player.m_20184_().m_82520_(0.0, (double)boost, 0.0));
                module.useEnergy((LivingEntity)player, energyContainer, usage, true);
            }
        }
    }

    @Nullable
    private FallEnergyInfo getFallAbsorptionEnergyInfo(LivingEntity base) {
        ItemStack feetStack = base.m_6844_(EquipmentSlot.FEET);
        if (!feetStack.m_41619_()) {
            Item item = feetStack.m_41720_();
            if (item instanceof ItemFreeRunners) {
                ItemFreeRunners boots = (ItemFreeRunners)item;
                if (boots.getMode(feetStack).preventsFallDamage()) {
                    return new FallEnergyInfo(StorageUtils.getEnergyContainer((ItemStack)feetStack, (int)0), (FloatSupplier)MekanismConfig.gear.freeRunnerFallDamageRatio, (FloatingLongSupplier)MekanismConfig.gear.freeRunnerFallEnergyCost);
                }
            } else if (feetStack.m_41720_() instanceof ModifiableMekaSuitArmor) {
                return new FallEnergyInfo(StorageUtils.getEnergyContainer((ItemStack)feetStack, (int)0), (FloatSupplier)MekanismConfig.gear.mekaSuitFallDamageRatio, (FloatingLongSupplier)MekanismConfig.gear.mekaSuitEnergyUsageFall);
            }
        }
        return null;
    }

    @SubscribeEvent
    public void getBreakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack legs;
        Player player = event.getEntity();
        float speed = event.getNewSpeed();
        Optional position = event.getPosition();
        if (position.isPresent()) {
            IBlastingItem tool;
            Map blocks;
            Item item;
            BlockPos pos = (BlockPos)position.get();
            ItemStack mainHand = player.m_21205_();
            if (!mainHand.m_41619_() && (item = mainHand.m_41720_()) instanceof IBlastingItem && !(blocks = (tool = (IBlastingItem)item).getBlastedBlocks(player.m_9236_(), player, mainHand, pos, event.getState())).isEmpty()) {
                float targetHardness = event.getState().m_60800_((BlockGetter)player.m_9236_(), pos);
                float maxHardness = blocks.entrySet().stream().map(entry -> Float.valueOf(((BlockState)entry.getValue()).m_60800_((BlockGetter)player.m_9236_(), (BlockPos)entry.getKey()))).reduce(Float.valueOf(targetHardness), Float::max).floatValue();
                speed *= targetHardness / maxHardness;
            }
        }
        if (!(legs = player.m_6844_(EquipmentSlot.LEGS)).m_41619_() && IModuleHelper.INSTANCE.isEnabled(legs, (IModuleDataProvider)MekanismModules.GYROSCOPIC_STABILIZATION_UNIT)) {
            if (player.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !EnchantmentHelper.m_44934_((LivingEntity)player)) {
                speed *= 5.0f;
            }
            if (!player.m_20096_()) {
                speed *= 5.0f;
            }
        }
        event.setNewSpeed(speed);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onLoadAdditionalModel(ModelEvent.RegisterAdditional event) {
        MekaPlateModelCache.INSTANCE.setup(event);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onModelBake(ModelEvent.BakingCompleted event) {
        MekaPlateModelCache.INSTANCE.onBake(event);
    }

    private record FallEnergyInfo(@Nullable IEnergyContainer container, FloatSupplier damageRatio, FloatingLongSupplier energyCost) {
    }
}

