/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.event;

import moffy.ticex.modifier.ModifierGravitiy;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class TicEXPEEvent {
    public static void onJump(LivingEvent.LivingJumpEvent evt) {
        LivingEntity livingEntity = evt.getEntity();
        if (livingEntity instanceof Player) {
            ItemStack leggingsStack;
            Player player = (Player)livingEntity;
            if (player.m_9236_().f_46443_ && (leggingsStack = player.m_6844_(EquipmentSlot.LEGS)).m_41720_() instanceof IModifiable) {
                ToolStack leggings = ToolStack.from((ItemStack)leggingsStack);
                for (ModifierEntry entry : leggings.getModifierList()) {
                    Modifier modifier = entry.getLazyModifier().get();
                    if (!(modifier instanceof ModifierGravitiy)) continue;
                    ModifierGravitiy gravitiyModifier = (ModifierGravitiy)modifier;
                    gravitiyModifier.getLastJumpTracker().put(player.m_19879_(), player.m_9236_().m_46467_());
                    break;
                }
            }
        }
    }

    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        boolean waterWalkOnType = TicEXPEEvent.canWalkOnWater(player);
        boolean lavaWalkOnType = TicEXPEEvent.canWalkOnLava(player);
        if (waterWalkOnType || lavaWalkOnType) {
            boolean lava;
            int x = (int)Math.floor(player.m_20185_());
            int y = (int)(player.m_20186_() - player.m_6049_());
            int z = (int)Math.floor(player.m_20189_());
            BlockPos pos = new BlockPos(x, y, z);
            FluidState below = player.m_9236_().m_6425_(pos.m_7495_());
            boolean water = waterWalkOnType && below.m_205070_(FluidTags.f_13131_);
            boolean bl = lava = lavaWalkOnType && below.m_205070_(FluidTags.f_13132_);
            if ((water || lava) && player.m_9236_().m_46859_(pos)) {
                if (!player.m_6144_()) {
                    player.m_20256_(player.m_20184_().m_82542_(1.0, 0.0, 1.0));
                    player.f_19789_ = 0.0f;
                    player.m_6853_(true);
                }
            } else if (!player.m_9236_().f_46443_ && waterWalkOnType && player.m_20069_()) {
                player.m_20301_(player.m_6062_());
            }
        }
    }

    private static boolean canWalkOnWater(Player player) {
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        if (!helmet.m_41619_() && helmet.m_41720_() instanceof IModifiable) {
            ToolStack tool = ToolStack.from((ItemStack)helmet);
            return tool.getModifierLevel(TicEXRegistry.ABYSSAL_MODIFIER.get()) > 0;
        }
        return false;
    }

    private static boolean canWalkOnLava(Player player) {
        ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
        if (!chestplate.m_41619_() && chestplate.m_41720_() instanceof IModifiable) {
            ToolStack tool = ToolStack.from((ItemStack)chestplate);
            return tool.getModifierLevel(TicEXRegistry.INFERNAL_MODIFIER.get()) > 0;
        }
        return false;
    }
}

