/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.event;

import moffy.ticex.lib.utils.TicEXPsiUtils;
import moffy.ticex.modifier.ModifierPsionizingRadiation;
import moffy.ticex.modifier.ModifierSensor;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.ToolDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import vazkii.psi.api.exosuit.PsiArmorEvent;

public class TicEXPsiEvent {
    public static void onPsiArmorEvent(PsiArmorEvent event) {
        Player player = event.getEntity();
        player.m_6168_().forEach(armorStack -> {
            if (armorStack.m_41720_() instanceof IModifiable) {
                ToolStack armor = ToolStack.from((ItemStack)armorStack);
                String eventType = TicEXPsiEvent.getEvent(armorStack);
                int timesCast = armor.getPersistentData().getInt(ModifierPsionizingRadiation.TIMES_CAST_LOC);
                if (event.type.equals(eventType)) {
                    TicEXPsiUtils.CastSpell(player, armorStack, context -> {
                        context.loopcastIndex = timesCast;
                    });
                    armor.getPersistentData().putInt(ModifierPsionizingRadiation.TIMES_CAST_LOC, timesCast + 1);
                }
            }
        });
    }

    public static String getEvent(ItemStack armorStack) {
        Item item;
        if (armorStack.m_41720_() instanceof IModifiable && (item = armorStack.m_41720_()) instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            ToolStack armor = ToolStack.from((ItemStack)armorStack);
            if (armor.getModifierLevel(TicEXRegistry.PSIONIZING_RADIATION_MODIFIER.get()) > 0) {
                switch (armorItem.m_266204_()) {
                    case HELMET: {
                        ToolDataNBT persistentData = armor.getPersistentData();
                        if (persistentData.contains(ModifierSensor.EVENT_TYPE_LOC, 8)) {
                            return persistentData.getString(ModifierSensor.EVENT_TYPE_LOC);
                        }
                        return null;
                    }
                    case CHESTPLATE: {
                        return "psi.event.damage";
                    }
                    case LEGGINGS: {
                        return "psi.event.tick";
                    }
                    case BOOTS: {
                        return "psi.event.jump";
                    }
                }
            }
        }
        return null;
    }
}

