/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.item.modifiable;

import com.google.common.collect.Sets;
import com.tacz.guns.item.ModernKineticGunItem;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.hook.behavior.EnchantmentModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DurabilityDisplayModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.SlotStackModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.build.RarityModule;
import slimeknights.tconstruct.library.tools.IndestructibleItemEntity;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.definition.module.mining.MiningSpeedToolHook;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.Util;

public class ModifiableGunItem
extends ModernKineticGunItem
implements IModifiableDisplay {
    private final ToolDefinition toolDefinition;
    private final int maxStackSize;
    protected ItemStack toolForRendering;

    public ModifiableGunItem(ToolDefinition toolDefinition, int maxStackSize) {
        this.toolDefinition = toolDefinition;
        this.maxStackSize = maxStackSize;
    }

    public ToolDefinition getToolDefinition() {
        return this.toolDefinition;
    }

    public int getMaxStackSize(ItemStack stack) {
        return stack.m_41768_() ? 1 : this.maxStackSize;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.m_6589_() && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        return EnchantmentModifierHook.getEnchantmentLevel((ItemStack)stack, (Enchantment)enchantment);
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        return EnchantmentModifierHook.getAllEnchantments((ItemStack)stack);
    }

    public ItemStack getRenderTool() {
        if (this.toolForRendering == null) {
            this.toolForRendering = ToolBuildHandler.buildToolForRendering((Item)this, (ToolDefinition)this.getToolDefinition());
        }
        return this.toolForRendering;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ToolCapabilityProvider(stack);
    }

    public void m_142312_(CompoundTag nbt) {
        ToolStack.verifyTag((Item)this, (CompoundTag)nbt, (ToolDefinition)this.getToolDefinition());
    }

    public void m_7836_(ItemStack stack, Level worldIn, Player playerIn) {
        ToolStack.ensureInitialized((ItemStack)stack, (ToolDefinition)this.getToolDefinition());
    }

    public Rarity m_41460_(ItemStack stack) {
        int rarity = ModifierUtil.getVolatileInt((ItemStack)stack, (ResourceLocation)RarityModule.RARITY);
        return Rarity.values()[Mth.m_14045_((int)rarity, (int)0, (int)3)];
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return IndestructibleItemEntity.hasCustomEntity((ItemStack)stack);
    }

    public Entity createEntity(Level world, Entity original, ItemStack stack) {
        return IndestructibleItemEntity.createFrom((Level)world, (Entity)original, (ItemStack)stack);
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean m_6832_(ItemStack pToRepair, ItemStack pRepair) {
        return false;
    }

    public boolean m_41465_() {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return ToolDamageUtil.getFakeMaxDamage((ItemStack)stack);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T damager, Consumer<T> onBroken) {
        ToolDamageUtil.handleDamageItem((ItemStack)stack, (int)amount, damager, onBroken);
        return 0;
    }

    public int m_142159_(ItemStack pStack) {
        return DurabilityDisplayModifierHook.getDurabilityRGB((ItemStack)pStack);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        return ToolHarvestLogic.mineBlock((ItemStack)stack, (Level)worldIn, (BlockState)state, (BlockPos)pos, (LivingEntity)entityLiving);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return stack.m_41613_() == 1 ? MiningSpeedToolHook.getDestroySpeed((ItemStack)stack, (BlockState)state) : 0.0f;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        return stack.m_41613_() > 1 || ToolHarvestLogic.handleBlockBreak((ItemStack)stack, (BlockPos)pos, (Player)player);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        InventoryTickModifierHook.heldInventoryTick((ItemStack)stack, (Level)worldIn, (Entity)entityIn, (int)itemSlot, (boolean)isSelected);
    }

    public boolean m_142207_(ItemStack held, Slot slot, ClickAction action, Player player) {
        return SlotStackModifierHook.overrideStackedOnOther((ItemStack)held, (Slot)slot, (ClickAction)action, (Player)player);
    }

    public boolean m_142305_(ItemStack slotStack, ItemStack held, Slot slot, ClickAction action, Player player, SlotAccess access) {
        return SlotStackModifierHook.overrideOtherStackedOnMe((ItemStack)slotStack, (ItemStack)held, (Slot)slot, (ClickAction)action, (Player)player, (SlotAccess)access);
    }

    @Nullable
    private static Component nameFor(String itemKey, Component itemName, MaterialVariantId variantId) {
        String materialKey = MaterialTooltipCache.getKey((MaterialVariantId)variantId);
        String key = itemKey + "." + materialKey;
        if (Util.canTranslate((String)key)) {
            return Component.m_237115_((String)key);
        }
        String formatKey = materialKey + ".format";
        if (Util.canTranslate((String)formatKey)) {
            return Component.m_237110_((String)formatKey, (Object[])new Object[]{itemName});
        }
        return Util.canTranslate((String)materialKey) ? Component.m_237110_((String)TooltipUtil.KEY_FORMAT, (Object[])new Object[]{Component.m_237115_((String)materialKey), itemName}) : null;
    }

    public Component m_7626_(ItemStack stack) {
        MaterialNBT materials;
        ToolStack tool = ToolStack.from((ItemStack)stack);
        String name = TooltipUtil.getDisplayName((ItemStack)stack);
        if (!name.isEmpty()) {
            return Component.m_237113_((String)name);
        }
        List components = ToolMaterialHook.stats((ToolDefinition)this.toolDefinition);
        Component baseName = super.m_7626_(stack);
        if (components.isEmpty()) {
            return baseName;
        }
        if (tool == null) {
            tool = ToolStack.from((ItemStack)stack);
        }
        if ((materials = tool.getMaterials()).size() != components.size()) {
            return baseName;
        }
        LinkedHashSet nameMaterials = Sets.newLinkedHashSet();
        MaterialVariantId firstMaterial = null;
        IMaterialRegistry registry = MaterialRegistry.getInstance();
        for (int i = 0; i < components.size(); ++i) {
            MaterialVariantId material;
            if (i >= materials.size() || !registry.canRepair((MaterialStatsId)components.get(i)) || IMaterial.UNKNOWN_ID.equals((Object)(material = materials.get(i).getVariant()))) continue;
            if (firstMaterial == null) {
                firstMaterial = material;
            }
            nameMaterials.add(MaterialTooltipCache.getDisplayName((MaterialVariantId)material));
        }
        return ModifiableGunItem.getMaterialItemName(stack, baseName, firstMaterial);
    }

    private static Component getMaterialItemName(ItemStack stack, Component itemName, MaterialVariantId material) {
        Component component;
        String itemKey = stack.m_41778_();
        if (material.hasVariant() && (component = ModifiableGunItem.nameFor(itemKey, itemName, material)) != null) {
            return component;
        }
        component = ModifiableGunItem.nameFor(itemKey, itemName, (MaterialVariantId)material.getId());
        return component != null ? component : itemName;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        TooltipUtil.addInformation((IModifiableDisplay)this, (ItemStack)stack, (Level)level, tooltip, (TooltipKey)SafeClientAccess.getTooltipKey(), (TooltipFlag)flag);
    }

    public int getDefaultTooltipHideFlags(ItemStack stack) {
        return TooltipUtil.getModifierHideFlags((ToolDefinition)this.getToolDefinition());
    }
}

