/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.item.modifiable;

import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.item.SpellBook;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.EnchantmentModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.SlotStackModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.build.RarityModule;
import slimeknights.tconstruct.library.tools.IndestructibleItemEntity;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ModifiableIronsSpellbookItem
extends SpellBook
implements IModifiableDisplay {
    private final ToolDefinition toolDefinition;
    private final int maxStackSize;
    protected ItemStack toolForRendering;

    public ModifiableIronsSpellbookItem(ToolDefinition toolDefinition, int maxStackSize) {
        super(12, SpellRarity.LEGENDARY, new Item.Properties().m_41487_(maxStackSize));
        this.toolDefinition = toolDefinition;
        this.maxStackSize = maxStackSize;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return this.getAttributeModifiers((IToolStackView)ToolStack.from((ItemStack)stack), slot);
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(IToolStackView tool, EquipmentSlot slot) {
        return AttributesModifierHook.getHeldAttributeModifiers((IToolStackView)tool, (EquipmentSlot)slot);
    }

    public ToolDefinition getToolDefinition() {
        return this.toolDefinition;
    }

    public int getMaxStackSize(ItemStack stack) {
        return stack.m_41768_() ? 1 : this.maxStackSize;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.m_6589_() && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        return EnchantmentModifierHook.getEnchantmentLevel((ItemStack)stack, (Enchantment)enchantment);
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        return EnchantmentModifierHook.getAllEnchantments((ItemStack)stack);
    }

    public ItemStack getRenderTool() {
        if (this.toolForRendering == null) {
            this.toolForRendering = ToolBuildHandler.buildToolForRendering((Item)this, (ToolDefinition)this.getToolDefinition());
        }
        return this.toolForRendering;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ToolCapabilityProvider(stack);
    }

    public void m_142312_(CompoundTag nbt) {
        ToolStack.verifyTag((Item)this, (CompoundTag)nbt, (ToolDefinition)this.getToolDefinition());
    }

    public void m_7836_(ItemStack stack, Level worldIn, Player playerIn) {
        ToolStack.ensureInitialized((ItemStack)stack, (ToolDefinition)this.getToolDefinition());
    }

    public Rarity m_41460_(ItemStack stack) {
        int rarity = ModifierUtil.getVolatileInt((ItemStack)stack, (ResourceLocation)RarityModule.RARITY);
        return Rarity.values()[Mth.m_14045_((int)rarity, (int)0, (int)3)];
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return IndestructibleItemEntity.hasCustomEntity((ItemStack)stack);
    }

    public Entity createEntity(Level world, Entity original, ItemStack stack) {
        return IndestructibleItemEntity.createFrom((Level)world, (Entity)original, (ItemStack)stack);
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean m_6832_(ItemStack pToRepair, ItemStack pRepair) {
        return false;
    }

    public boolean m_41465_() {
        return false;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        InventoryTickModifierHook.heldInventoryTick((ItemStack)stack, (Level)worldIn, (Entity)entityIn, (int)itemSlot, (boolean)isSelected);
    }

    public boolean m_142207_(ItemStack held, Slot slot, ClickAction action, Player player) {
        return SlotStackModifierHook.overrideStackedOnOther((ItemStack)held, (Slot)slot, (ClickAction)action, (Player)player);
    }

    public boolean m_142305_(ItemStack slotStack, ItemStack held, Slot slot, ClickAction action, Player player, SlotAccess access) {
        return SlotStackModifierHook.overrideOtherStackedOnMe((ItemStack)slotStack, (ItemStack)held, (Slot)slot, (ClickAction)action, (Player)player, (SlotAccess)access);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        TooltipUtil.addInformation((IModifiableDisplay)this, (ItemStack)stack, (Level)level, tooltip, (TooltipKey)SafeClientAccess.getTooltipKey(), (TooltipFlag)flag);
    }

    public int getDefaultTooltipHideFlags(ItemStack stack) {
        return TooltipUtil.getModifierHideFlags((ToolDefinition)this.getToolDefinition());
    }

    public Component m_7626_(ItemStack stack) {
        return TooltipUtil.getDisplayName((ItemStack)stack, (ToolDefinition)this.toolDefinition);
    }
}

