/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.item.modifiable;

import com.google.common.collect.ImmutableMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.ModuleData;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.providers.IGasProvider;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.api.text.EnumColor;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.chemical.item.ChemicalTankSpec;
import mekanism.common.capabilities.chemical.item.RateLimitMultiTankGasHandler;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.item.RateLimitEnergyHandler;
import mekanism.common.capabilities.fluid.item.RateLimitMultiTankFluidHandler;
import mekanism.common.capabilities.laser.item.LaserDissipationHandler;
import mekanism.common.capabilities.radiation.item.RadiationShieldingHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.mekasuit.ModuleJetpackUnit;
import mekanism.common.content.gear.shared.ModuleEnergyUnit;
import mekanism.common.integration.gender.GenderCapabilityHelper;
import mekanism.common.item.gear.ItemHazmatSuitArmor;
import mekanism.common.item.interfaces.IJetpackItem;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.lib.attribute.IAttributeRefresher;
import mekanism.common.registries.MekanismFluids;
import mekanism.common.registries.MekanismGases;
import mekanism.common.registries.MekanismModules;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import moffy.ticex.client.modules.mekanism.MekaPlateDispatcher;
import moffy.ticex.item.modifiable.IModifiableMekItem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.item.armor.MultilayerArmorItem;

public class ModifiableMekaSuitArmor
extends MultilayerArmorItem
implements IModifiableMekItem,
IModuleContainerItem,
IModeItem,
IJetpackItem,
IAttributeRefresher {
    private final List<ChemicalTankSpec<Gas>> gasTankSpecs = new ArrayList<ChemicalTankSpec<Gas>>();
    private final List<ChemicalTankSpec<Gas>> gasTankSpecsView = Collections.unmodifiableList(this.gasTankSpecs);
    private final List<RateLimitMultiTankFluidHandler.FluidTankSpec> fluidTankSpecs = new ArrayList<RateLimitMultiTankFluidHandler.FluidTankSpec>();
    private final List<RateLimitMultiTankFluidHandler.FluidTankSpec> fluidTankSpecsView = Collections.unmodifiableList(this.fluidTankSpecs);
    private final float absorption;
    private final double laserDissipation;
    private final double laserRefraction;
    private final ResourceLocation name;

    public ModifiableMekaSuitArmor(ModifiableArmorMaterial material, ArmorItem.Type slot, Item.Properties properties) {
        super(material, slot, properties);
        switch (slot) {
            case HELMET: {
                this.fluidTankSpecs.add(RateLimitMultiTankFluidHandler.FluidTankSpec.createFillOnly((IntSupplier)MekanismConfig.gear.mekaSuitNutritionalTransferRate, (IntSupplier)MekanismConfig.gear.mekaSuitNutritionalMaxStorage, fluid -> fluid.getFluid() == MekanismFluids.NUTRITIONAL_PASTE.getFluid(), stack -> this.hasModule((ItemStack)stack, (IModuleDataProvider)MekanismModules.NUTRITIONAL_INJECTION_UNIT)));
                this.absorption = 0.15f;
                this.laserDissipation = 0.15;
                this.laserRefraction = 0.2;
                break;
            }
            case CHESTPLATE: {
                this.gasTankSpecs.add((ChemicalTankSpec<Gas>)ChemicalTankSpec.createFillOnly((LongSupplier)MekanismConfig.gear.mekaSuitJetpackTransferRate, (LongSupplier)MekanismConfig.gear.mekaSuitJetpackMaxStorage, gas -> gas == MekanismGases.HYDROGEN.get(), stack -> this.hasModule((ItemStack)stack, (IModuleDataProvider)MekanismModules.JETPACK_UNIT)));
                this.absorption = 0.4f;
                this.laserDissipation = 0.3;
                this.laserRefraction = 0.4;
                break;
            }
            case LEGGINGS: {
                this.absorption = 0.3f;
                this.laserDissipation = 0.1875;
                this.laserRefraction = 0.25;
                break;
            }
            case BOOTS: {
                this.absorption = 0.15f;
                this.laserDissipation = 0.1125;
                this.laserRefraction = 0.15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Equipment Slot Type");
            }
        }
        this.name = material.getId();
    }

    private static float getDamageAbsorbed(Player player, DamageSource source, float amount, @Nullable List<Runnable> energyUseCallbacks) {
        if (amount <= 0.0f) {
            return 0.0f;
        }
        float ratioAbsorbed = 0.0f;
        ArrayList<FoundArmorDetails> armorDetails = new ArrayList<FoundArmorDetails>();
        for (Object stack : player.m_6168_()) {
            float absorption;
            ICustomModule.ModuleDamageAbsorbInfo damageAbsorbInfo;
            Module module;
            Item item;
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ModifiableMekaSuitArmor)) continue;
            ModifiableMekaSuitArmor armor = (ModifiableMekaSuitArmor)item;
            IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0);
            if (energyContainer == null) continue;
            FoundArmorDetails details = new FoundArmorDetails(energyContainer, armor);
            armorDetails.add(details);
            Iterator iterator = details.armor.getModules((ItemStack)stack).iterator();
            while (!(!iterator.hasNext() || (module = (Module)iterator.next()).isEnabled() && (damageAbsorbInfo = ModifiableMekaSuitArmor.getModuleDamageAbsorbInfo(module, source)) != null && (ratioAbsorbed += ModifiableMekaSuitArmor.absorbDamage(details.usageInfo, amount, absorption = damageAbsorbInfo.absorptionRatio().getAsFloat(), ratioAbsorbed, damageAbsorbInfo.energyCost())) >= 1.0f)) {
            }
            if (!(ratioAbsorbed >= 1.0f)) continue;
            break;
        }
        if (ratioAbsorbed < 1.0f) {
            Float absorbRatio = null;
            for (FoundArmorDetails details : armorDetails) {
                float absorption;
                if (absorbRatio == null) {
                    if (!source.m_269533_(MekanismTags.DamageTypes.MEKASUIT_ALWAYS_SUPPORTED) && source.m_269533_(DamageTypeTags.f_268490_)) break;
                    ResourceLocation damageTypeName = source.m_269150_().m_203543_().map(ResourceKey::m_135782_).orElseGet(() -> player.m_9236_().m_9598_().m_6632_(Registries.f_268580_).map(registry -> registry.m_7981_((Object)source.m_269415_())).orElse(null));
                    if (damageTypeName != null) {
                        absorbRatio = (Float)((Map)MekanismConfig.gear.mekaSuitDamageRatios.get()).get(damageTypeName);
                    }
                    if (absorbRatio == null) {
                        absorbRatio = Float.valueOf(MekanismConfig.gear.mekaSuitUnspecifiedDamageRatio.getAsFloat());
                    }
                    if (absorbRatio.floatValue() == 0.0f) break;
                }
                if (!((ratioAbsorbed += ModifiableMekaSuitArmor.absorbDamage(details.usageInfo, amount, absorption = details.armor.absorption * absorbRatio.floatValue(), ratioAbsorbed, (FloatingLongSupplier)MekanismConfig.gear.mekaSuitEnergyUsageDamage)) >= 1.0f)) continue;
                break;
            }
        }
        for (FoundArmorDetails details : armorDetails) {
            if (details.usageInfo.energyUsed.isZero()) continue;
            if (energyUseCallbacks == null) {
                details.energyContainer.extract(details.usageInfo.energyUsed, Action.EXECUTE, AutomationType.MANUAL);
                continue;
            }
            energyUseCallbacks.add(() -> details.energyContainer.extract(details.usageInfo.energyUsed, Action.EXECUTE, AutomationType.MANUAL));
        }
        return Math.min(ratioAbsorbed, 1.0f);
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)new MekaPlateDispatcher(){

            @Override
            @NotNull
            protected ResourceLocation getName() {
                return ModifiableMekaSuitArmor.this.name;
            }
        });
    }

    public <T extends LivingEntity> int damageItem(@NotNull ItemStack stack, int amount, @NotNull T entity, @NotNull Consumer<T> onBroken) {
        return 0;
    }

    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        if (MekKeyHandler.isKeyPressed((KeyMapping)MekanismKeyHandler.detailsKey)) {
            this.addModuleDetails(stack, tooltip);
        } else {
            StorageUtils.addStoredEnergy((ItemStack)stack, tooltip, (boolean)true);
            if (!this.gasTankSpecs.isEmpty()) {
                StorageUtils.addStoredGas((ItemStack)stack, tooltip, (boolean)true, (boolean)false);
            }
            if (!this.fluidTankSpecs.isEmpty()) {
                StorageUtils.addStoredFluid((ItemStack)stack, tooltip, (boolean)true);
            }
            tooltip.add((Component)MekanismLang.HOLD_FOR_MODULES.translateColored(EnumColor.GRAY, new Object[]{EnumColor.INDIGO, MekanismKeyHandler.detailsKey.m_90863_()}));
        }
    }

    public boolean makesPiglinsNeutral(@NotNull ItemStack stack, @NotNull LivingEntity wearer) {
        return true;
    }

    public boolean isEnderMask(@NotNull ItemStack stack, @NotNull Player player, @NotNull EnderMan enderman) {
        return this.f_265916_ == ArmorItem.Type.HELMET;
    }

    public boolean canWalkOnPowderedSnow(@NotNull ItemStack stack, @NotNull LivingEntity wearer) {
        return this.f_265916_ == ArmorItem.Type.BOOTS;
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return true;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return StorageUtils.getEnergyBarWidth((ItemStack)stack);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return MekanismConfig.client.energyColor.get();
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        return MutableComponent.m_237204_((ComponentContents)super.m_7626_(stack).m_214077_()).m_130940_(ChatFormatting.LIGHT_PURPLE);
    }

    public boolean isNotReplaceableByPickAction(@NotNull ItemStack stack, @NotNull Player player, int inventorySlot) {
        return super.isNotReplaceableByPickAction(stack, player, inventorySlot) || ItemDataUtils.hasData((ItemStack)stack, (String)"modules", (int)10);
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return false;
    }

    public int getEnchantmentLevel(ItemStack stack, @NotNull Enchantment enchantment) {
        if (stack.m_41619_()) {
            return 0;
        }
        ListTag enchantments = ItemDataUtils.getList((ItemStack)stack, (String)"Enchantments");
        return Math.max(MekanismUtils.getEnchantmentLevel((ListTag)enchantments, (Enchantment)enchantment), super.getEnchantmentLevel(stack, enchantment));
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        super.onArmorTick(stack, world, player);
        for (Module module : this.getModules(stack)) {
            module.tick(player);
        }
    }

    @Override
    public boolean areCapabilityConfigsLoaded() {
        return MekanismConfig.gear.isLoaded();
    }

    @Override
    public void gatherCapabilities(List<ItemCapabilityWrapper.ItemCapability> capabilities, ItemStack stack) {
        GenderCapabilityHelper.addGenderCapability((ArmorItem)this, capabilities::add);
        capabilities.add((ItemCapabilityWrapper.ItemCapability)RateLimitEnergyHandler.create(() -> this.getChargeRate(stack), () -> this.getMaxEnergy(stack), (Predicate)BasicEnergyContainer.manualOnly, (Predicate)BasicEnergyContainer.alwaysTrue));
        capabilities.add((ItemCapabilityWrapper.ItemCapability)RadiationShieldingHandler.create(item -> this.isModuleEnabled((ItemStack)item, (IModuleDataProvider)MekanismModules.RADIATION_SHIELDING_UNIT) ? ItemHazmatSuitArmor.getShieldingByArmor((ArmorItem.Type)this.m_266204_()) : 0.0));
        capabilities.add((ItemCapabilityWrapper.ItemCapability)LaserDissipationHandler.create(item -> this.isModuleEnabled((ItemStack)item, (IModuleDataProvider)MekanismModules.LASER_DISSIPATION_UNIT) ? this.laserDissipation : 0.0, item -> this.isModuleEnabled((ItemStack)item, (IModuleDataProvider)MekanismModules.LASER_DISSIPATION_UNIT) ? this.laserRefraction : 0.0));
        if (!this.gasTankSpecs.isEmpty()) {
            capabilities.add((ItemCapabilityWrapper.ItemCapability)RateLimitMultiTankGasHandler.create(this.gasTankSpecs));
        }
        if (!this.fluidTankSpecs.isEmpty()) {
            capabilities.add((ItemCapabilityWrapper.ItemCapability)RateLimitMultiTankFluidHandler.create(this.fluidTankSpecs));
        }
    }

    public List<ChemicalTankSpec<Gas>> getGasTankSpecs() {
        return this.gasTankSpecsView;
    }

    public List<RateLimitMultiTankFluidHandler.FluidTankSpec> getFluidTankSpecs() {
        return this.fluidTankSpecsView;
    }

    @NotNull
    public GasStack useGas(ItemStack stack, Gas type, long amount) {
        Optional capability = stack.getCapability(Capabilities.GAS_HANDLER).resolve();
        if (capability.isPresent()) {
            IGasHandler gasHandlerItem = (IGasHandler)capability.get();
            return (GasStack)gasHandlerItem.extractChemical((ChemicalStack)new GasStack((IGasProvider)type, amount), Action.EXECUTE);
        }
        return GasStack.EMPTY;
    }

    public GasStack getContainedGas(ItemStack stack, Gas type) {
        Optional capability = stack.getCapability(Capabilities.GAS_HANDLER).resolve();
        if (capability.isPresent()) {
            IGasHandler gasHandlerItem = (IGasHandler)capability.get();
            for (int i = 0; i < gasHandlerItem.getTanks(); ++i) {
                GasStack gasInTank = (GasStack)gasHandlerItem.getChemicalInTank(i);
                if (gasInTank.getType() != type) continue;
                return gasInTank;
            }
        }
        return GasStack.EMPTY;
    }

    public FluidStack getContainedFluid(ItemStack stack, FluidStack type) {
        Optional capability = FluidUtil.getFluidHandler((ItemStack)stack).resolve();
        if (capability.isPresent()) {
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)capability.get();
            for (int i = 0; i < fluidHandlerItem.getTanks(); ++i) {
                FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(i);
                if (!fluidInTank.isFluidEqual(type)) continue;
                return fluidInTank;
            }
        }
        return FluidStack.EMPTY;
    }

    public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, IModeItem.DisplayChange displayChange) {
        for (Module module : this.getModules(stack)) {
            if (!module.handlesModeChange()) continue;
            module.changeMode(player, stack, shift, displayChange);
            return;
        }
    }

    public boolean supportsSlotType(ItemStack stack, @NotNull EquipmentSlot slotType) {
        return slotType == this.m_40402_() && this.getModules(stack).stream().anyMatch(Module::handlesModeChange);
    }

    @NotNull
    public Map<Enchantment, Integer> getAllEnchantments(@NotNull ItemStack stack) {
        Map enchantments = EnchantmentHelper.m_44882_((ListTag)ItemDataUtils.getList((ItemStack)stack, (String)"Enchantments"));
        super.getAllEnchantments(stack).forEach((enchantment, level) -> enchantments.merge(enchantment, level, Math::max));
        return enchantments;
    }

    public boolean canElytraFly(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        IModule module;
        if (this.m_266204_() == ArmorItem.Type.CHESTPLATE && !entity.m_6144_() && (module = this.getModule(stack, (IModuleDataProvider)MekanismModules.ELYTRA_UNIT)) != null && module.isEnabled() && module.canUseEnergy(entity, (FloatingLong)MekanismConfig.gear.mekaSuitElytraEnergyUsage.get())) {
            IModule jetpack = this.getModule(stack, (IModuleDataProvider)MekanismModules.JETPACK_UNIT);
            return jetpack == null || !jetpack.isEnabled() || ((ModuleJetpackUnit)jetpack.getCustomInstance()).getMode() != IJetpackItem.JetpackMode.HOVER || this.getContainedGas(stack, (Gas)MekanismGases.HYDROGEN.get()).isEmpty();
        }
        return false;
    }

    public boolean canUseJetpack(ItemStack stack) {
        return this.f_265916_ == ArmorItem.Type.CHESTPLATE && (this.isModuleEnabled(stack, (IModuleDataProvider)MekanismModules.JETPACK_UNIT) ? ChemicalUtil.hasChemical((ItemStack)stack, (Chemical)((Gas)MekanismGases.HYDROGEN.get())) : this.getModules(stack).stream().anyMatch(module -> module.isEnabled() && module.getData().isExclusive(ModuleData.ExclusiveFlag.OVERRIDE_JUMP.getMask())));
    }

    public IJetpackItem.JetpackMode getJetpackMode(ItemStack stack) {
        IModule module = this.getModule(stack, (IModuleDataProvider)MekanismModules.JETPACK_UNIT);
        if (module != null && module.isEnabled()) {
            return ((ModuleJetpackUnit)module.getCustomInstance()).getMode();
        }
        return IJetpackItem.JetpackMode.DISABLED;
    }

    public void useJetpackFuel(ItemStack stack) {
        this.useGas(stack, (Gas)MekanismGases.HYDROGEN.get(), 1L);
    }

    private FloatingLong getMaxEnergy(ItemStack stack) {
        IModule module = this.getModule(stack, (IModuleDataProvider)MekanismModules.ENERGY_UNIT);
        return module == null ? (FloatingLong)MekanismConfig.gear.mekaSuitBaseEnergyCapacity.get() : ((ModuleEnergyUnit)module.getCustomInstance()).getEnergyCapacity(module);
    }

    private FloatingLong getChargeRate(ItemStack stack) {
        IModule module = this.getModule(stack, (IModuleDataProvider)MekanismModules.ENERGY_UNIT);
        return module == null ? (FloatingLong)MekanismConfig.gear.mekaSuitBaseChargeRate.get() : ((ModuleEnergyUnit)module.getCustomInstance()).getChargeRate(module);
    }

    public int m_40404_() {
        return this.m_40401_().m_7366_(this.m_266204_());
    }

    public float m_40405_() {
        return this.m_40401_().m_6651_();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.m_41720_() != newStack.m_41720_();
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public void addToBuilder(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder) {
    }

    public static float getDamageAbsorbed(Player player, DamageSource source, float amount) {
        return ModifiableMekaSuitArmor.getDamageAbsorbed(player, source, amount, null);
    }

    public static boolean tryAbsorbAll(Player player, DamageSource source, float amount) {
        ArrayList<Runnable> energyUsageCallbacks = new ArrayList<Runnable>(4);
        if (ModifiableMekaSuitArmor.getDamageAbsorbed(player, source, amount, energyUsageCallbacks) >= 1.0f) {
            for (Runnable energyUsageCallback : energyUsageCallbacks) {
                energyUsageCallback.run();
            }
            return true;
        }
        return false;
    }

    public boolean elytraFlightTick(@NotNull ItemStack stack, LivingEntity entity, int flightTicks) {
        int nextFlightTicks;
        if (!entity.m_9236_().f_46443_ && (nextFlightTicks = flightTicks + 1) % 10 == 0) {
            IModule module;
            if (nextFlightTicks % 20 == 0 && (module = this.getModule(stack, (IModuleDataProvider)MekanismModules.ELYTRA_UNIT)) != null && module.isEnabled()) {
                module.useEnergy(entity, (FloatingLong)MekanismConfig.gear.mekaSuitElytraEnergyUsage.get());
            }
            entity.m_146850_(GameEvent.f_223705_);
        }
        return true;
    }

    @Nullable
    private static <MODULE extends ICustomModule<MODULE>> ICustomModule.ModuleDamageAbsorbInfo getModuleDamageAbsorbInfo(IModule<MODULE> module, DamageSource damageSource) {
        return module.getCustomInstance().getDamageAbsorbInfo(module, damageSource);
    }

    private static float absorbDamage(EnergyUsageInfo usageInfo, float amount, float absorption, float currentAbsorbed, FloatingLongSupplier energyCost) {
        float toAbsorb = amount * (absorption = Math.min(1.0f - currentAbsorbed, absorption));
        if (toAbsorb > 0.0f) {
            FloatingLong usage = energyCost.get().multiply((double)toAbsorb);
            if (usage.isZero()) {
                return absorption;
            }
            if (usageInfo.energyAvailable.greaterOrEqual(usage)) {
                usageInfo.energyUsed = usageInfo.energyUsed.plusEqual(usage);
                usageInfo.energyAvailable = usageInfo.energyAvailable.minusEqual(usage);
                return absorption;
            }
            if (!usageInfo.energyAvailable.isZero()) {
                float absorbedPercent = usageInfo.energyAvailable.divide(usage).floatValue();
                usageInfo.energyUsed = usageInfo.energyUsed.plusEqual(usageInfo.energyAvailable);
                usageInfo.energyAvailable = FloatingLong.ZERO;
                return absorption * absorbedPercent;
            }
        }
        return 0.0f;
    }

    private static class FoundArmorDetails {
        private final IEnergyContainer energyContainer;
        private final EnergyUsageInfo usageInfo;
        private final ModifiableMekaSuitArmor armor;

        public FoundArmorDetails(IEnergyContainer energyContainer, ModifiableMekaSuitArmor armor) {
            this.energyContainer = energyContainer;
            this.usageInfo = new EnergyUsageInfo(energyContainer.getEnergy());
            this.armor = armor;
        }
    }

    private static class EnergyUsageInfo {
        private FloatingLong energyAvailable;
        private FloatingLong energyUsed = FloatingLong.ZERO;

        public EnergyUsageInfo(FloatingLong energyAvailable) {
            this.energyAvailable = energyAvailable.copy();
        }
    }
}

