/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.item.modifiable;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.event.MekanismTeleportEvent;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.api.radial.RadialData;
import mekanism.api.radial.mode.IRadialMode;
import mekanism.api.radial.mode.NestedRadialMode;
import mekanism.api.text.EnumColor;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.item.RateLimitEnergyHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.value.CachedFloatingLongValue;
import mekanism.common.config.value.CachedValue;
import mekanism.common.content.gear.IBlastingItem;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.mekatool.ModuleAttackAmplificationUnit;
import mekanism.common.content.gear.mekatool.ModuleBlastingUnit;
import mekanism.common.content.gear.mekatool.ModuleExcavationEscalationUnit;
import mekanism.common.content.gear.mekatool.ModuleTeleportationUnit;
import mekanism.common.content.gear.mekatool.ModuleVeinMiningUnit;
import mekanism.common.content.gear.shared.ModuleEnergyUnit;
import mekanism.common.item.gear.ItemAtomicDisassembler;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.lib.attribute.AttributeCache;
import mekanism.common.lib.radial.IGenericRadialModeItem;
import mekanism.common.lib.radial.data.NestingRadialData;
import mekanism.common.network.to_client.PacketPortalFX;
import mekanism.common.registration.impl.CreativeTabDeferredRegister;
import mekanism.common.registries.MekanismModules;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import moffy.ticex.item.modifiable.IModifiableMekItem;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.mining.MiningSpeedToolHook;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class ModifiableMekaTool
extends ModifiableItem
implements CreativeTabDeferredRegister.ICustomCreativeTabContents,
IModuleContainerItem,
IBlastingItem,
IGenericRadialModeItem,
IModifiableMekItem {
    private static final FloatingLongSupplier chargeRateSupplier = MekanismConfig.gear.mekaToolBaseChargeRate;
    private static final FloatingLongSupplier maxEnergySupplier = MekanismConfig.gear.mekaToolBaseEnergyCapacity;
    private static final ResourceLocation RADIAL_ID = Mekanism.rl((String)"meka_tool");
    private final Int2ObjectMap<AttributeCache> attributeCaches = new Int2ObjectArrayMap(ModuleAttackAmplificationUnit.AttackDamage.values().length);

    public ModifiableMekaTool(Item.Properties properties) {
        super(properties, TicEXRegistry.MEKA_TOOL_DEFINITION);
    }

    @Override
    public boolean areCapabilityConfigsLoaded() {
        return MekanismConfig.gear.isLoaded();
    }

    @Override
    public void gatherCapabilities(List<ItemCapabilityWrapper.ItemCapability> capabilities, ItemStack stack) {
        capabilities.add((ItemCapabilityWrapper.ItemCapability)RateLimitEnergyHandler.create(() -> this.getChargeRate(stack), () -> this.getMaxEnergy(stack), (Predicate)BasicEnergyContainer.manualOnly, (Predicate)BasicEnergyContainer.alwaysTrue));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ToolCapabilityProvider(stack);
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return true;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return StorageUtils.getEnergyBarWidth((ItemStack)stack);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return MekanismConfig.client.energyColor.get();
    }

    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        TooltipUtil.addInformation((IModifiableDisplay)this, (ItemStack)stack, (Level)world, tooltip, (TooltipKey)SafeClientAccess.getTooltipKey(), (TooltipFlag)flag);
        if (MekKeyHandler.isKeyPressed((KeyMapping)MekanismKeyHandler.detailsKey)) {
            this.addModuleDetails(stack, tooltip);
        } else {
            StorageUtils.addStoredEnergy((ItemStack)stack, tooltip, (boolean)true);
            tooltip.add((Component)MekanismLang.HOLD_FOR_MODULES.translateColored(EnumColor.GRAY, new Object[]{EnumColor.INDIGO, MekanismKeyHandler.detailsKey.m_90863_()}));
        }
    }

    public void addItems(CreativeModeTab.Output tabOutput) {
        FloatingLongSupplier floatingLongSupplier = chargeRateSupplier;
        if (floatingLongSupplier instanceof CachedFloatingLongValue) {
            CachedFloatingLongValue configValue = (CachedFloatingLongValue)floatingLongSupplier;
            tabOutput.m_246342_(StorageUtils.getFilledEnergyVariant((ItemStack)new ItemStack((ItemLike)this), (CachedFloatingLongValue)configValue));
        } else {
            tabOutput.m_246342_(StorageUtils.getFilledEnergyVariant((ItemStack)new ItemStack((ItemLike)this), (FloatingLong)maxEnergySupplier.get()));
        }
    }

    protected FloatingLong getChargeRate(ItemStack stack) {
        IModule module = this.getModule(stack, (IModuleDataProvider)MekanismModules.ENERGY_UNIT);
        return module == null ? chargeRateSupplier.get() : ((ModuleEnergyUnit)module.getCustomInstance()).getChargeRate(module);
    }

    protected FloatingLong getMaxEnergy(ItemStack stack) {
        IModule module = this.getModule(stack, (IModuleDataProvider)MekanismModules.ENERGY_UNIT);
        return module == null ? maxEnergySupplier.get() : ((ModuleEnergyUnit)module.getCustomInstance()).getEnergyCapacity(module);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.m_41720_() != newStack.m_41720_();
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public boolean m_8096_(@NotNull BlockState state) {
        return true;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return true;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction action) {
        return super.canPerformAction(stack, action) || ItemAtomicDisassembler.ALWAYS_SUPPORTED_ACTIONS.contains(action) ? this.hasEnergyForDigAction(stack) : this.getModules(stack).stream().anyMatch(module -> module.isEnabled() && this.canPerformAction((IModule)module, action));
    }

    private <MODULE extends ICustomModule<MODULE>> boolean canPerformAction(IModule<MODULE> module, ToolAction action) {
        return module.getCustomInstance().canPerformAction(module, action);
    }

    public boolean hasEnergyForDigAction(ItemStack stack) {
        FloatingLong energyAvailable;
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0);
        if (energyContainer == null) {
            return false;
        }
        FloatingLong energyRequired = this.getDestroyEnergy(stack, 0.0f, this.isModuleEnabled(stack, (IModuleDataProvider)MekanismModules.SILK_TOUCH_UNIT));
        return energyRequired.smallerOrEqual(energyAvailable = energyContainer.getEnergy()) || !energyAvailable.divide(energyRequired).isZero();
    }

    public boolean isNotReplaceableByPickAction(ItemStack stack, Player player, int inventorySlot) {
        return super.isNotReplaceableByPickAction(stack, player, inventorySlot) || ItemDataUtils.hasData((ItemStack)stack, (String)"modules", (int)10);
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        if (stack.m_41619_()) {
            return 0;
        }
        ListTag enchantments = ItemDataUtils.getList((ItemStack)stack, (String)"Enchantments");
        return Math.max(MekanismUtils.getEnchantmentLevel((ListTag)enchantments, (Enchantment)enchantment), super.getEnchantmentLevel(stack, enchantment));
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        Map enchantments = EnchantmentHelper.m_44882_((ListTag)ItemDataUtils.getList((ItemStack)stack, (String)"Enchantments"));
        super.getAllEnchantments(stack).forEach((enchantment, level) -> enchantments.merge(enchantment, level, Math::max));
        return enchantments;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        for (Module module : this.getModules(context.m_43722_())) {
            InteractionResult result;
            if (!module.isEnabled() || (result = this.onModuleUse((IModule)module, context)) == InteractionResult.PASS) continue;
            return result;
        }
        return super.m_6225_(context);
    }

    private <MODULE extends ICustomModule<MODULE>> InteractionResult onModuleUse(IModule<MODULE> module, UseOnContext context) {
        return module.getCustomInstance().onItemUse(module, context);
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        for (Module module : this.getModules(stack)) {
            InteractionResult result;
            if (!module.isEnabled() || (result = this.onModuleInteract((IModule)module, player, entity, hand)) == InteractionResult.PASS) continue;
            return result;
        }
        return super.m_6880_(stack, player, entity, hand);
    }

    private <MODULE extends ICustomModule<MODULE>> InteractionResult onModuleInteract(IModule<MODULE> module, @NotNull Player player, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        return module.getCustomInstance().onInteract(module, player, entity, hand);
    }

    public float getMekDestroySpeed(@NotNull ItemStack stack, @NotNull BlockState state) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0);
        if (energyContainer == null) {
            return 0.0f;
        }
        FloatingLong energyRequired = this.getDestroyEnergy(stack, state.m_60800_(null, null), this.isModuleEnabled(stack, (IModuleDataProvider)MekanismModules.SILK_TOUCH_UNIT));
        FloatingLong energyAvailable = energyContainer.extract(energyRequired, Action.SIMULATE, AutomationType.MANUAL);
        if (energyAvailable.smallerThan(energyRequired)) {
            return MekanismConfig.gear.mekaToolBaseEfficiency.get() * energyAvailable.divide(energyRequired).floatValue();
        }
        IModule module = this.getModule(stack, (IModuleDataProvider)MekanismModules.EXCAVATION_ESCALATION_UNIT);
        return module != null && module.isEnabled() ? ((ModuleExcavationEscalationUnit)module.getCustomInstance()).getEfficiency() : MekanismConfig.gear.mekaToolBaseEfficiency.get();
    }

    public float getTiCDestroySpeed(@NotNull ItemStack stack, @NotNull BlockState state) {
        if (!stack.m_41782_()) {
            return 1.0f;
        }
        ToolStack tool = ToolStack.from((ItemStack)stack);
        if (tool.isBroken()) {
            return 0.3f;
        }
        return Math.max(1.0f, ((MiningSpeedToolHook)tool.getHook(ToolHooks.MINING_SPEED)).modifyDestroySpeed((IToolStackView)tool, state, ((Float)tool.getStats().get((IToolStat)ToolStats.MINING_SPEED)).floatValue()));
    }

    public float m_8102_(@NotNull ItemStack stack, @NotNull BlockState state) {
        return this.getTiCDestroySpeed(stack, state) + this.getMekDestroySpeed(stack, state);
    }

    public boolean m_6813_(@NotNull ItemStack stack, @NotNull Level world, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity entityliving) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0);
        if (energyContainer != null) {
            FloatingLong energyRequired = this.getDestroyEnergy(stack, state.m_60800_((BlockGetter)world, pos), this.isModuleEnabled(stack, (IModuleDataProvider)MekanismModules.SILK_TOUCH_UNIT));
            energyContainer.extract(energyRequired, Action.EXECUTE, AutomationType.MANUAL);
        }
        return true;
    }

    public boolean m_7579_(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        IEnergyContainer energyContainer;
        int unitDamage;
        IModule attackAmplificationUnit = this.getModule(stack, (IModuleDataProvider)MekanismModules.ATTACK_AMPLIFICATION_UNIT);
        if (attackAmplificationUnit != null && attackAmplificationUnit.isEnabled() && (unitDamage = ((ModuleAttackAmplificationUnit)attackAmplificationUnit.getCustomInstance()).getDamage()) > 0 && (energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0)) != null && !energyContainer.isEmpty()) {
            energyContainer.extract(((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageWeapon.get()).multiply((double)unitDamage / 4.0), Action.EXECUTE, AutomationType.MANUAL);
        }
        return true;
    }

    public Map<BlockPos, BlockState> getBlastedBlocks(Level world, Player player, ItemStack stack, BlockPos pos, BlockState state) {
        int radius;
        IModule blastingUnit;
        if (!player.m_6144_() && (blastingUnit = this.getModule(stack, (IModuleDataProvider)MekanismModules.BLASTING_UNIT)) != null && blastingUnit.isEnabled() && (radius = ((ModuleBlastingUnit)blastingUnit.getCustomInstance()).getBlastRadius()) > 0 && IBlastingItem.canBlastBlock((Level)world, (BlockPos)pos, (BlockState)state)) {
            return IBlastingItem.findPositions((Level)world, (BlockPos)pos, (Player)player, (int)radius);
        }
        return Collections.emptyMap();
    }

    private Object2IntMap<BlockPos> getVeinedBlocks(Level world, ItemStack stack, Map<BlockPos, BlockState> blocks, Reference2BooleanMap<Block> oreTracker) {
        IModule veinMiningUnit = this.getModule(stack, (IModuleDataProvider)MekanismModules.VEIN_MINING_UNIT);
        if (veinMiningUnit != null && veinMiningUnit.isEnabled()) {
            ModuleVeinMiningUnit customInstance = (ModuleVeinMiningUnit)veinMiningUnit.getCustomInstance();
            return ModuleVeinMiningUnit.findPositions((Level)world, blocks, (int)(customInstance.isExtended() ? customInstance.getExcavationRange() : 0), oreTracker);
        }
        return (Object2IntMap)blocks.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, be -> 0, (l, r) -> l, Object2IntArrayMap::new));
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        if (!player.m_9236_().f_46443_ && !player.m_7500_()) {
            IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0);
            if (energyContainer != null) {
                Reference2BooleanMap oreTracker;
                Map<BlockPos, BlockState> blocks;
                Object2IntMap<BlockPos> veinedBlocks;
                Level world = player.m_9236_();
                BlockState state = world.m_8055_(pos);
                boolean silk = this.isModuleEnabled(stack, (IModuleDataProvider)MekanismModules.SILK_TOUCH_UNIT);
                FloatingLong modDestroyEnergy = this.getDestroyEnergy(stack, silk);
                FloatingLong energyRequired = this.getDestroyEnergy(modDestroyEnergy, state.m_60800_((BlockGetter)world, pos));
                if (energyContainer.extract(energyRequired, Action.SIMULATE, AutomationType.MANUAL).greaterOrEqual(energyRequired) && !(veinedBlocks = this.getVeinedBlocks(world, stack, blocks = (blocks = this.getBlastedBlocks(world, player, stack, pos, state)).isEmpty() && ModuleVeinMiningUnit.canVeinBlock((BlockState)state) ? Map.of(pos, state) : blocks, (Reference2BooleanMap<Block>)(oreTracker = (Reference2BooleanMap)blocks.values().stream().collect(Collectors.toMap(BlockBehaviour.BlockStateBase::m_60734_, bs -> bs.m_204336_(MekanismTags.Blocks.ATOMIC_DISASSEMBLER_ORE), (l, r) -> l, Reference2BooleanArrayMap::new))))).isEmpty()) {
                    FloatingLong baseDestroyEnergy = this.getDestroyEnergy(silk);
                    MekanismUtils.veinMineArea((IEnergyContainer)energyContainer, (FloatingLong)energyRequired, (Level)world, (BlockPos)pos, (ServerPlayer)((ServerPlayer)player), (ItemStack)stack, (Item)this, veinedBlocks, hardness -> this.getDestroyEnergy(modDestroyEnergy, hardness), (hardness, distance, bs) -> this.getDestroyEnergy(baseDestroyEnergy, hardness).multiply(0.5 * Math.pow(distance, oreTracker.getBoolean((Object)bs.m_60734_()) ? 1.5 : 2.0)));
                }
            }
            return super.onBlockStartBreak(stack, pos, player);
        }
        return super.onBlockStartBreak(stack, pos, player);
    }

    private FloatingLong getDestroyEnergy(boolean silk) {
        return silk ? (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageSilk.get() : (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsage.get();
    }

    public FloatingLong getDestroyEnergy(ItemStack itemStack, float hardness, boolean silk) {
        return this.getDestroyEnergy(this.getDestroyEnergy(itemStack, silk), hardness);
    }

    private FloatingLong getDestroyEnergy(FloatingLong baseDestroyEnergy, float hardness) {
        return hardness == 0.0f ? baseDestroyEnergy.divide(2L) : baseDestroyEnergy;
    }

    private FloatingLong getDestroyEnergy(ItemStack itemStack, boolean silk) {
        FloatingLong destroyEnergy = this.getDestroyEnergy(silk);
        IModule module = this.getModule(itemStack, (IModuleDataProvider)MekanismModules.EXCAVATION_ESCALATION_UNIT);
        float efficiency = module != null && module.isEnabled() ? ((ModuleExcavationEscalationUnit)module.getCustomInstance()).getEfficiency() : MekanismConfig.gear.mekaToolBaseEfficiency.get();
        return destroyEnergy.multiply((double)efficiency);
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getMekanismAttributeModifiers(@NotNull EquipmentSlot slot, @NotNull ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            int unitDamage = 0;
            IModule attackAmplificationUnit = this.getModule(stack, (IModuleDataProvider)MekanismModules.ATTACK_AMPLIFICATION_UNIT);
            if (attackAmplificationUnit != null && attackAmplificationUnit.isEnabled() && (unitDamage = ((ModuleAttackAmplificationUnit)attackAmplificationUnit.getCustomInstance()).getDamage()) > 0) {
                FloatingLong energy;
                FloatingLong energyCost = ((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageWeapon.get()).multiply((double)unitDamage / 4.0);
                IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0);
                FloatingLong floatingLong = energy = energyContainer == null ? FloatingLong.ZERO : energyContainer.getEnergy();
                if (energy.smallerThan(energyCost)) {
                    double bonusDamage = (double)unitDamage * energy.divideToLevel(energyCost);
                    if (bonusDamage > 0.0) {
                        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
                        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)MekanismConfig.gear.mekaToolBaseDamage.get() + bonusDamage, AttributeModifier.Operation.ADDITION));
                        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", MekanismConfig.gear.mekaToolAttackSpeed.get(), AttributeModifier.Operation.ADDITION));
                        return builder.build();
                    }
                    unitDamage = 0;
                }
            }
            return (Multimap)((AttributeCache)this.attributeCaches.computeIfAbsent(unitDamage, damage -> new AttributeCache(builder -> {
                builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(MekanismConfig.gear.mekaToolBaseDamage.get() + damage), AttributeModifier.Operation.ADDITION));
                builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", MekanismConfig.gear.mekaToolAttackSpeed.get(), AttributeModifier.Operation.ADDITION));
            }, new CachedValue[]{MekanismConfig.gear.mekaToolBaseDamage, MekanismConfig.gear.mekaToolAttackSpeed}))).get();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        double maxSpeed;
        Multimap<Attribute, AttributeModifier> mekanismMap = this.getMekanismAttributeModifiers(slot, stack);
        Multimap tconMap = super.getAttributeModifiers(slot, stack);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        double totalAttackDamage = 0.0;
        for (AttributeModifier mod : mekanismMap.get((Object)Attributes.f_22281_)) {
            if (mod.m_22217_() != AttributeModifier.Operation.ADDITION || !mod.m_22209_().equals(f_41374_)) continue;
            totalAttackDamage += mod.m_22218_();
        }
        for (AttributeModifier mod : tconMap.get((Object)Attributes.f_22281_)) {
            if (mod.m_22217_() != AttributeModifier.Operation.ADDITION || !mod.m_22209_().equals(f_41374_)) continue;
            totalAttackDamage += mod.m_22218_();
        }
        if (totalAttackDamage != 0.0) {
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Merged attack damage", totalAttackDamage, AttributeModifier.Operation.ADDITION));
        }
        double tconSpeed = 0.0;
        double mekSpeed = 0.0;
        for (AttributeModifier mod : tconMap.get((Object)Attributes.f_22283_)) {
            if (mod.m_22217_() != AttributeModifier.Operation.ADDITION || !mod.m_22209_().equals(f_41375_)) continue;
            tconSpeed = mod.m_22218_();
            break;
        }
        for (AttributeModifier mod : mekanismMap.get((Object)Attributes.f_22283_)) {
            if (mod.m_22217_() != AttributeModifier.Operation.ADDITION || !mod.m_22209_().equals(f_41375_)) continue;
            mekSpeed = mod.m_22218_();
            break;
        }
        if ((maxSpeed = Math.max(tconSpeed, mekSpeed)) != 0.0) {
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Merged attack speed", maxSpeed, AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @NotNull InteractionHand hand) {
        IModule module;
        ItemStack stack = player.m_21120_(hand);
        if (!world.m_5776_() && (module = this.getModule(stack, (IModuleDataProvider)MekanismModules.TELEPORTATION_UNIT)) != null && module.isEnabled()) {
            BlockPos pos;
            BlockHitResult result = MekanismUtils.rayTrace((Player)player, (double)MekanismConfig.gear.mekaToolMaxTeleportReach.get());
            if ((!((ModuleTeleportationUnit)module.getCustomInstance()).requiresBlockTarget() || result.m_6662_() != HitResult.Type.MISS) && this.isValidDestinationBlock(world, (pos = result.m_82425_()).m_7494_()) && this.isValidDestinationBlock(world, pos.m_6630_(2))) {
                double distance = player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                if (distance < 5.0) {
                    return InteractionResultHolder.m_19098_((Object)stack);
                }
                IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0);
                FloatingLong energyNeeded = ((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageTeleport.get()).multiply(distance / 10.0);
                if (energyContainer != null && !energyContainer.getEnergy().smallerThan(energyNeeded)) {
                    double targetZ;
                    double targetY;
                    double targetX = (double)pos.m_123341_() + 0.5;
                    MekanismTeleportEvent.MekaTool event = new MekanismTeleportEvent.MekaTool(player, targetX, targetY = (double)pos.m_123342_() + 1.5, targetZ = (double)pos.m_123343_() + 0.5, stack, result);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                        return InteractionResultHolder.m_19100_((Object)stack);
                    }
                    energyContainer.extract(energyNeeded, Action.EXECUTE, AutomationType.MANUAL);
                    if (player.m_20159_()) {
                        player.m_142098_(targetX, targetY, targetZ);
                    } else {
                        player.m_6021_(targetX, targetY, targetZ);
                    }
                    player.m_183634_();
                    Mekanism.packetHandler().sendToAllTracking((Object)new PacketPortalFX(pos.m_7494_()), world, pos);
                    world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private boolean isValidDestinationBlock(Level world, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        return blockState.m_60795_() || MekanismUtils.isLiquidBlock((Block)blockState.m_60734_());
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean supportsSlotType(ItemStack stack, @NotNull EquipmentSlot slotType) {
        return super.supportsSlotType(stack, slotType) && this.getModules(stack).stream().anyMatch(Module::handlesAnyModeChange);
    }

    @Nullable
    public Component getScrollTextComponent(@NotNull ItemStack stack) {
        return this.getModules(stack).stream().filter(Module::handlesModeChange).findFirst().map(module -> module.getModeScrollComponent(stack)).orElse(null);
    }

    public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, IModeItem.DisplayChange displayChange) {
        for (Module module : this.getModules(stack)) {
            if (!module.handlesModeChange()) continue;
            module.changeMode(player, stack, shift, displayChange);
            return;
        }
    }

    @Nullable
    public RadialData<?> getRadialData(ItemStack stack) {
        ArrayList nestedModes = new ArrayList();
        Objects.requireNonNull(nestedModes);
        Consumer<NestedRadialMode> adder = nestedModes::add;
        for (Module module : this.getModules(stack)) {
            if (!module.handlesRadialModeChange()) continue;
            module.addRadialModes(stack, adder);
        }
        if (nestedModes.isEmpty()) {
            return null;
        }
        if (nestedModes.size() == 1) {
            return ((NestedRadialMode)nestedModes.get(0)).nestedData();
        }
        return new NestingRadialData(RADIAL_ID, nestedModes);
    }

    @Nullable
    public <M extends IRadialMode> M getMode(ItemStack stack, RadialData<M> radialData) {
        for (Module module : this.getModules(stack)) {
            IRadialMode mode;
            if (!module.handlesRadialModeChange() || (mode = module.getMode(stack, radialData)) == null) continue;
            return (M)mode;
        }
        return null;
    }

    public <M extends IRadialMode> void setMode(ItemStack stack, Player player, RadialData<M> radialData, M mode) {
        for (Module module : this.getModules(stack)) {
            if (!module.handlesRadialModeChange() || !module.setMode(player, stack, radialData, mode)) continue;
            return;
        }
    }

    public Component m_7626_(ItemStack stack) {
        return MutableComponent.m_237204_((ComponentContents)super.m_7626_(stack).m_214077_()).m_130940_(ChatFormatting.LIGHT_PURPLE);
    }
}

