/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.item.modifiable;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.entity.BladeItemEntity;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.ReachModifier;
import mods.flammpfeil.slashblade.item.SwordType;
import moffy.ticex.client.modules.slashblade.SBToolISTER;
import moffy.ticex.entity.slashblade.SBToolItemEntity;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.EnchantmentModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DurabilityDisplayModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.BlockInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.EntityInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.SlotStackModifierHook;
import slimeknights.tconstruct.library.tools.IndestructibleItemEntity;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.capability.inventory.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.module.mining.IsEffectiveToolHook;
import slimeknights.tconstruct.library.tools.definition.module.mining.MiningSpeedToolHook;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerToolActions;

public class ModifiableSlashBladeItem
extends ItemSlashBlade
implements IModifiableDisplay {
    protected static final UUID ATTACK_DAMAGE_AMPLIFIER = UUID.fromString("2D988C13-595B-4E58-B254-39BB6FA077FD");
    protected static final UUID PLAYER_REACH_AMPLIFIER = UUID.fromString("2D988C13-595B-4E58-B254-39BB6FA077FE");
    public static final ResourceLocation BLADE_STATE_LOCATION = new ResourceLocation("ticex", "bladestate");
    public static final ResourceLocation INPUT_STATE_LOCATION = new ResourceLocation("ticex", "inputstate");
    private final ToolDefinition toolDefinition;
    private ItemStack toolForRendering;

    public ModifiableSlashBladeItem(Item.Properties properties, ToolDefinition toolDefinition) {
        super((Tier)Tiers.NETHERITE, 1, 1.0f, properties);
        this.toolDefinition = toolDefinition;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ArrayListMultimap toolMultimap = ArrayListMultimap.create(this.getAttributeModifiers((IToolStackView)ToolStack.from((ItemStack)stack), slot));
        if (slot == EquipmentSlot.MAINHAND) {
            stack.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(arg_0 -> ModifiableSlashBladeItem.lambda$getAttributeModifiers$0(stack, (Multimap)toolMultimap, arg_0));
        }
        return ImmutableMultimap.copyOf((Multimap)toolMultimap);
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public CompoundTag getShareTag(ItemStack stack) {
        return stack.m_41784_();
    }

    public void readShareTag(ItemStack stack, CompoundTag nbt) {
        stack.m_41751_(nbt);
    }

    public boolean isNotReplaceableByPickAction(ItemStack stack, Player player, int inventorySlot) {
        return true;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.m_6589_() && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        return EnchantmentModifierHook.getEnchantmentLevel((ItemStack)stack, (Enchantment)enchantment);
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        return EnchantmentModifierHook.getAllEnchantments((ItemStack)stack);
    }

    public void m_142312_(CompoundTag nbt) {
        ToolStack.verifyTag((Item)this, (CompoundTag)nbt, (ToolDefinition)this.getToolDefinition());
    }

    public void m_7836_(ItemStack stack, Level worldIn, Player playerIn) {
        ToolStack.ensureInitialized((ItemStack)stack, (ToolDefinition)this.getToolDefinition());
    }

    public boolean m_5812_(ItemStack stack) {
        return ModifierUtil.checkVolatileFlag((ItemStack)stack, (ResourceLocation)SHINY);
    }

    @Nullable
    public Entity createEntity(Level world, Entity original, ItemStack stack) {
        return IndestructibleItemEntity.createFrom((Level)world, (Entity)original, (ItemStack)stack);
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean m_6832_(ItemStack pToRepair, ItemStack pRepair) {
        return false;
    }

    public boolean m_41465_() {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return ToolDamageUtil.getFakeMaxDamage((ItemStack)stack);
    }

    public int getDamage(ItemStack stack) {
        if (!this.m_41465_()) {
            return 0;
        }
        return ToolStack.from((ItemStack)stack).getDamage();
    }

    public void setDamage(ItemStack stack, int damage) {
        if (this.m_41465_()) {
            ToolStack.from((ItemStack)stack).setDamage(damage);
        }
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T damager, Consumer<T> onBroken) {
        ToolDamageUtil.handleDamageItem((ItemStack)stack, (int)amount, damager, onBroken);
        return 0;
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41613_() == 1 && DurabilityDisplayModifierHook.showDurabilityBar((ItemStack)stack);
    }

    public int m_142159_(ItemStack pStack) {
        return DurabilityDisplayModifierHook.getDurabilityRGB((ItemStack)pStack);
    }

    public int m_142158_(ItemStack pStack) {
        return DurabilityDisplayModifierHook.getDurabilityWidth((ItemStack)pStack);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity target) {
        return stack.m_41613_() > 1 || this.onEntityInteractLeftClick(stack, player, target) || super.onLeftClickEntity(stack, player, target);
    }

    private boolean onEntityInteractLeftClick(ItemStack stack, Player player, Entity target) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        if (stack.m_204117_(TinkerTags.Items.INTERACTABLE_LEFT) && !player.m_36335_().m_41519_(stack.m_41720_())) {
            List modifiers = tool.getModifierList();
            for (ModifierEntry entry : modifiers) {
                if (!((EntityInteractionModifierHook)entry.getHook(ModifierHooks.ENTITY_INTERACT)).beforeEntityUse((IToolStackView)tool, entry, player, target, InteractionHand.MAIN_HAND, InteractionSource.LEFT_CLICK).m_19077_()) continue;
                return true;
            }
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                for (ModifierEntry entry : modifiers) {
                    if (!((EntityInteractionModifierHook)entry.getHook(ModifierHooks.ENTITY_INTERACT)).afterEntityUse((IToolStackView)tool, entry, player, living, InteractionHand.MAIN_HAND, InteractionSource.LEFT_CLICK).m_19077_()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return this.canPerformAction(stack, TinkerToolActions.SHIELD_DISABLE) || super.canDisableShield(stack, shield, entity, attacker);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return IsEffectiveToolHook.isEffective((IToolStackView)ToolStack.from((ItemStack)stack), (BlockState)state);
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        return ToolHarvestLogic.mineBlock((ItemStack)stack, (Level)worldIn, (BlockState)state, (BlockPos)pos, (LivingEntity)entityLiving);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return stack.m_41613_() == 1 ? MiningSpeedToolHook.getDestroySpeed((ItemStack)stack, (BlockState)state) : 0.0f;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        return stack.m_41613_() > 1 || ToolHarvestLogic.handleBlockBreak((ItemStack)stack, (BlockPos)pos, (Player)player);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        InventoryTickModifierHook.heldInventoryTick((ItemStack)stack, (Level)worldIn, (Entity)entityIn, (int)itemSlot, (boolean)isSelected);
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean m_142207_(ItemStack held, Slot slot, ClickAction action, Player player) {
        return SlotStackModifierHook.overrideStackedOnOther((ItemStack)held, (Slot)slot, (ClickAction)action, (Player)player) || super.m_142207_(held, slot, action, player);
    }

    public boolean m_142305_(ItemStack slotStack, ItemStack held, Slot slot, ClickAction action, Player player, SlotAccess access) {
        return SlotStackModifierHook.overrideOtherStackedOnMe((ItemStack)slotStack, (ItemStack)held, (Slot)slot, (ClickAction)action, (Player)player, (SlotAccess)access) || super.m_142305_(slotStack, held, slot, action, player, access);
    }

    protected static boolean shouldInteract(@Nullable LivingEntity player, ToolStack toolStack, InteractionHand hand) {
        IModDataView volatileData = toolStack.getVolatileData();
        if (volatileData.getBoolean(NO_INTERACTION)) {
            return false;
        }
        if (hand == InteractionHand.OFF_HAND) {
            return true;
        }
        return player == null || !volatileData.getBoolean(DEFER_OFFHAND) || player.m_21206_().m_41619_();
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (stack.m_41613_() == 1) {
            ToolStack tool = ToolStack.from((ItemStack)stack);
            InteractionHand hand = context.m_43724_();
            if (ModifiableSlashBladeItem.shouldInteract((LivingEntity)context.m_43723_(), tool, hand)) {
                for (ModifierEntry entry : tool.getModifierList()) {
                    InteractionResult result = ((BlockInteractionModifierHook)entry.getHook(ModifierHooks.BLOCK_INTERACT)).beforeBlockUse((IToolStackView)tool, entry, context, InteractionSource.RIGHT_CLICK);
                    if (!result.m_19077_()) continue;
                    return result;
                }
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        if (stack.m_41613_() == 1) {
            ToolStack tool = ToolStack.from((ItemStack)stack);
            InteractionHand hand = context.m_43724_();
            if (ModifiableSlashBladeItem.shouldInteract((LivingEntity)context.m_43723_(), tool, hand)) {
                for (ModifierEntry entry : tool.getModifierList()) {
                    InteractionResult result = ((BlockInteractionModifierHook)entry.getHook(ModifierHooks.BLOCK_INTERACT)).afterBlockUse((IToolStackView)tool, entry, context, InteractionSource.RIGHT_CLICK);
                    if (!result.m_19077_()) continue;
                    return result;
                }
            }
        }
        return super.m_6225_(context);
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        if (ModifiableSlashBladeItem.shouldInteract((LivingEntity)playerIn, tool, hand)) {
            for (ModifierEntry entry : tool.getModifierList()) {
                InteractionResult result = ((EntityInteractionModifierHook)entry.getHook(ModifierHooks.ENTITY_INTERACT)).afterEntityUse((IToolStackView)tool, entry, playerIn, target, hand, InteractionSource.RIGHT_CLICK);
                if (!result.m_19077_()) continue;
                return result;
            }
        }
        return super.m_6880_(stack, playerIn, target, hand);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand hand) {
        InteractionResultHolder resultHolder;
        ItemStack stack = playerIn.m_21120_(hand);
        if (stack.m_41613_() > 1) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        ToolStack tool = ToolStack.from((ItemStack)stack);
        if (ModifiableSlashBladeItem.shouldInteract((LivingEntity)playerIn, tool, hand)) {
            for (ModifierEntry entry : tool.getModifierList()) {
                InteractionResult result = ((GeneralInteractionModifierHook)entry.getHook(ModifierHooks.GENERAL_INTERACT)).onToolUse((IToolStackView)tool, entry, playerIn, hand, InteractionSource.RIGHT_CLICK);
                if (!result.m_19077_()) continue;
                return new InteractionResultHolder(result, (Object)stack);
            }
        }
        if ((resultHolder = new InteractionResultHolder(ToolInventoryCapability.tryOpenContainer((ItemStack)stack, (IToolStackView)tool, (Player)playerIn, (EquipmentSlot)Util.getSlotType((InteractionHand)hand)), (Object)stack)).m_19089_() != InteractionResult.SUCCESS) {
            resultHolder = super.m_7203_(worldIn, playerIn, hand);
        }
        return resultHolder;
    }

    public void m_5929_(Level pLevel, LivingEntity entityLiving, ItemStack stack, int timeLeft) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        ModifierEntry activeModifier = GeneralInteractionModifierHook.getActiveModifier((IToolStackView)tool);
        if (activeModifier != ModifierEntry.EMPTY) {
            ((GeneralInteractionModifierHook)activeModifier.getHook(ModifierHooks.GENERAL_INTERACT)).onUsingTick((IToolStackView)tool, activeModifier, entityLiving, timeLeft);
        }
        super.m_5929_(pLevel, entityLiving, stack, timeLeft);
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        if (super.canContinueUsing(oldStack, newStack) && oldStack != newStack) {
            GeneralInteractionModifierHook.finishUsing((IToolStackView)ToolStack.from((ItemStack)oldStack));
        }
        return super.canContinueUsing(oldStack, newStack);
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        ModifierEntry activeModifier = GeneralInteractionModifierHook.getActiveModifier((IToolStackView)tool);
        if (activeModifier != ModifierEntry.EMPTY) {
            ((GeneralInteractionModifierHook)activeModifier.getHook(ModifierHooks.GENERAL_INTERACT)).onFinishUsing((IToolStackView)tool, activeModifier, entityLiving);
        }
        return super.m_5922_(stack, worldIn, entityLiving);
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        ModifierEntry activeModifier = GeneralInteractionModifierHook.getActiveModifier((IToolStackView)tool);
        if (activeModifier != ModifierEntry.EMPTY) {
            ((GeneralInteractionModifierHook)activeModifier.getHook(ModifierHooks.GENERAL_INTERACT)).onStoppedUsing((IToolStackView)tool, activeModifier, entityLiving, timeLeft);
        }
        super.m_5551_(stack, worldIn, entityLiving, timeLeft);
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int timeLeft) {
        GeneralInteractionModifierHook.finishUsing((IToolStackView)ToolStack.from((ItemStack)stack));
        super.onStopUsing(stack, entity, timeLeft);
    }

    public int m_8105_(ItemStack stack) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        ModifierEntry activeModifier = GeneralInteractionModifierHook.getActiveModifier((IToolStackView)tool);
        if (activeModifier != ModifierEntry.EMPTY) {
            return ((GeneralInteractionModifierHook)activeModifier.getHook(ModifierHooks.GENERAL_INTERACT)).getUseDuration((IToolStackView)tool, activeModifier);
        }
        return super.m_8105_(stack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        ModifierEntry activeModifier = GeneralInteractionModifierHook.getActiveModifier((IToolStackView)tool);
        if (activeModifier != ModifierEntry.EMPTY) {
            return ((GeneralInteractionModifierHook)activeModifier.getHook(ModifierHooks.GENERAL_INTERACT)).getUseAction((IToolStackView)tool, activeModifier);
        }
        return super.m_6164_(stack);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return stack.m_41613_() == 1 && ModifierUtil.canPerformAction((IToolStackView)ToolStack.from((ItemStack)stack), (ToolAction)toolAction) || super.canPerformAction(stack, toolAction);
    }

    public Component m_7626_(ItemStack stack) {
        return TooltipUtil.getDisplayName((ItemStack)stack, (ToolDefinition)this.getToolDefinition());
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        TooltipUtil.addInformation((IModifiableDisplay)this, (ItemStack)stack, (Level)level, tooltip, (TooltipKey)SafeClientAccess.getTooltipKey(), (TooltipFlag)flag);
    }

    public int getDefaultTooltipHideFlags(ItemStack stack) {
        return TooltipUtil.getModifierHideFlags((ToolDefinition)this.getToolDefinition());
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return this.shouldCauseReequipAnimation(oldStack, newStack, false);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return ModifiableItem.shouldCauseReequip((ItemStack)oldStack, (ItemStack)newStack, (boolean)slotChanged);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(IToolStackView tool, EquipmentSlot slot) {
        return AttributesModifierHook.getHeldAttributeModifiers((IToolStackView)tool, (EquipmentSlot)slot);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new ToolCapabilityProvider(stack);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!(entity instanceof SBToolItemEntity)) {
            Level world = entity.m_9236_();
            SBToolItemEntity e = new SBToolItemEntity((EntityType<? extends BladeItemEntity>)((EntityType)TicEXRegistry.SLASHBLADE_TOOL_ITEM_ENTITY.get()), world);
            e.m_20361_((Entity)entity);
            e.init();
            entity.m_146870_();
            world.m_7967_((Entity)e);
        }
        return false;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            final BlockEntityWithoutLevelRenderer renderer = new SBToolISTER(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public ToolDefinition getToolDefinition() {
        return this.toolDefinition;
    }

    public ItemStack getRenderTool() {
        if (this.toolForRendering == null) {
            this.toolForRendering = ToolBuildHandler.buildToolForRendering((Item)this, (ToolDefinition)this.getToolDefinition());
        }
        return this.toolForRendering;
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$0(ItemStack stack, Multimap toolMultimap, ISlashBladeState bladeState) {
        StatsNBT stats = ToolStack.from((ItemStack)stack).getStats();
        EnumSet swordType = SwordType.from((ItemStack)stack);
        float baseAttackModifier = ((Float)stats.get((IToolStat)ToolStats.ATTACK_DAMAGE)).floatValue();
        float attackAmplifier = bladeState.getAttackAmplifier();
        int refine = bladeState.getRefine();
        if (bladeState.isBroken()) {
            attackAmplifier = -0.5f - baseAttackModifier;
        } else {
            float refineFactor = swordType.contains(SwordType.FIERCEREDGE) ? 0.1f : 0.05f;
            attackAmplifier = (1.0f - 1.0f / (1.0f + refineFactor * (float)refine)) * baseAttackModifier;
        }
        AttributeModifier attack = new AttributeModifier(f_41374_, "Weapon modifier", (double)baseAttackModifier + (double)attackAmplifier - 1.0, AttributeModifier.Operation.ADDITION);
        toolMultimap.remove((Object)Attributes.f_22281_, (Object)attack);
        toolMultimap.put((Object)Attributes.f_22281_, (Object)attack);
        toolMultimap.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(PLAYER_REACH_AMPLIFIER, "Reach amplifer", bladeState.isBroken() ? ReachModifier.BrokendReach() : ReachModifier.BladeReach(), AttributeModifier.Operation.ADDITION));
    }
}

