/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.lib;

import java.util.ArrayList;
import moffy.ticex.TicEX;
import moffy.ticex.caps.curios.GauntletItemHandler;
import moffy.ticex.entity.curios.ResonanceToolProjectile;
import moffy.ticex.modules.general.TicEXRegistry;
import moffy.ticex.network.curios.TicEXSyncEntityMovements;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;

public class ResonanceTools {
    public static void shoot(Player player) {
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curioItemHandler -> curioItemHandler.findFirstCurio((Item)TicEXRegistry.RESONANCE_GAUNTLET.get()).ifPresent(slotResult -> ResonanceTools.shootGauntletStack(player, slotResult.stack())));
    }

    public static void shootGauntletStack(Player player, ItemStack gauntletStack) {
        ResonanceTools.shootGauntletStack(player, gauntletStack, true);
    }

    public static void shootGauntletStack(Player player, ItemStack gauntletStack, boolean useCooldown) {
        gauntletStack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
            if (!(itemHandler instanceof GauntletItemHandler)) {
                return;
            }
            GauntletItemHandler gauntletItemHandler = (GauntletItemHandler)((Object)itemHandler);
            ArrayList<Integer> availableSlots = new ArrayList<Integer>();
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                if (itemHandler.getStackInSlot(i).m_41619_() || gauntletItemHandler.getItemCooldown(i) != 0) continue;
                availableSlots.add(i);
            }
            if (availableSlots.isEmpty()) {
                return;
            }
            int shootSlot = (Integer)availableSlots.get(player.m_217043_().m_216332_(0, availableSlots.size() - 1));
            ItemStack toolStack = itemHandler.getStackInSlot(shootSlot);
            Vec3 center = player.m_20182_();
            float time = player.f_19797_;
            double baseAngle = Math.PI * 2 / (double)availableSlots.size() * (double)shootSlot - (double)time * 0.07 + Math.toRadians(player.m_146908_());
            double radius = 1.4f;
            Vec3 offset = new Vec3(Math.cos(baseAngle), 1.25, Math.sin(baseAngle)).m_82490_(radius);
            Vec3 originPos = center.m_82549_(offset);
            ResonanceTools.shootProjectile(player, toolStack, originPos);
            if (useCooldown) {
                gauntletItemHandler.setItemCooldown(shootSlot, 15);
            }
        });
    }

    public static void shootProjectile(Player player, ItemStack stack, Vec3 pos) {
        Level level = player.m_9236_();
        if (!level.f_46443_) {
            ResonanceToolProjectile arrow = new ResonanceToolProjectile((LivingEntity)player, level);
            arrow.m_146884_(pos);
            arrow.setItem(stack);
            Vec3 lookAngle = player.m_20154_();
            float velocity = 3.0f;
            float inaccuracy = 0.0f;
            arrow.m_6686_(lookAngle.f_82479_, lookAngle.f_82480_, lookAngle.f_82481_, velocity, inaccuracy);
            level.m_7967_((Entity)arrow);
            player.m_6330_(SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
            TicEXSyncEntityMovements packet = new TicEXSyncEntityMovements((Entity)arrow);
            TicEX.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> arrow), (Object)packet);
        }
    }
}

