/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.lib.hook;

import java.util.Collection;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;

public interface EmbossmentModifierHook {
    public boolean applyItem(EmbossmentContext var1, int var2, boolean var3);

    public static class EmbossmentContext {
        private ItemStack toolStack;
        private ITinkerStationContainer inv;
        private Component errorMsg;

        public EmbossmentContext(ItemStack toolStack, ITinkerStationContainer inv) {
            this.toolStack = toolStack;
            this.inv = inv;
            this.errorMsg = Component.m_237115_((String)"recipe.ticex.embossment_not_allowed");
        }

        public ItemStack getToolStack() {
            return this.toolStack;
        }

        public ITinkerStationContainer getInv() {
            return this.inv;
        }

        public ItemStack getInputStack(int index) {
            return this.inv.getInput(index);
        }

        public Component getErrorMsg() {
            return this.errorMsg;
        }

        public void setToolStack(ItemStack toolStack) {
            this.toolStack = toolStack;
        }

        public void setInv(ITinkerStationContainer inv) {
            this.inv = inv;
        }

        public void setErrorMsg(Component errorMsg) {
            this.errorMsg = errorMsg;
        }
    }

    public record AllMerger(Collection<EmbossmentModifierHook> modules) implements EmbossmentModifierHook
    {
        @Override
        public boolean applyItem(EmbossmentContext context, int inputIndex, boolean secondary) {
            for (EmbossmentModifierHook module : this.modules) {
                boolean result = module.applyItem(context, inputIndex, secondary);
                if (!result) continue;
                return true;
            }
            return false;
        }
    }

    public static class DefaultClass
    implements EmbossmentModifierHook {
        @Override
        public boolean applyItem(EmbossmentContext context, int inputIndex, boolean secondary) {
            return false;
        }
    }
}

