/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.lib.recipe;

import java.util.List;
import java.util.stream.IntStream;
import moffy.ticex.lib.utils.TicEXUtils;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.building.ToolBuildingRecipe;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolPartsHook;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public class EmbossmentBuildingRecipe
extends ToolBuildingRecipe {
    public static final RecordLoadable<EmbossmentBuildingRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, (RecordField)TinkerLoadables.MODIFIABLE_ITEM.requiredField("result", r -> r.output), (RecordField)IntLoadable.FROM_ONE.defaultField("result_count", (Object)1, true, r -> r.outputCount), (RecordField)Loadables.RESOURCE_LOCATION.nullableField("slot_layout", r -> r.layoutSlot), (RecordField)IngredientLoadable.DISALLOW_EMPTY.list(0).defaultField("extra_requirements", List.of(), r -> r.ingredients), EmbossmentBuildingRecipe::new);

    public EmbossmentBuildingRecipe(ResourceLocation id, String group, IModifiable output, int outputCount, ResourceLocation layoutSlot, List<Ingredient> ingredients) {
        super(id, group, output, outputCount, layoutSlot, ingredients);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TicEXRegistry.BUILDING_EMBOSSMENT_RECIPE_SERIALIZER.get();
    }

    public RecipeResult<LazyToolStack> getValidatedResult(ITinkerStationContainer inv, RegistryAccess access) {
        List<MaterialVariant> materials = IntStream.range(0, ToolPartsHook.parts((ToolDefinition)this.output.getToolDefinition()).size()).mapToObj(i -> MaterialVariant.of((MaterialVariantId)IMaterialItem.getMaterialFromStack((ItemStack)inv.getInput(i)))).toList();
        ItemStack resultStack = ToolStack.createTool((Item)this.output.m_5456_(), (ToolDefinition)this.output.getToolDefinition(), (MaterialNBT)new MaterialNBT(materials)).createStack(this.outputCount);
        IntStream.range(0, ToolPartsHook.parts((ToolDefinition)this.output.getToolDefinition()).size()).forEach(i -> {
            CompoundTag inputNBT;
            ItemStack inputStack = inv.getInput(i);
            if (inputStack.m_41782_() && (inputNBT = inputStack.m_41783_()).m_128441_("embossed")) {
                CompoundTag resultNBT = resultStack.m_41784_();
                CompoundTag embossedTag = inputNBT.m_128469_("embossed");
                for (String key : embossedTag.m_128431_()) {
                    resultNBT.m_128365_(key, embossedTag.m_128423_(key));
                }
            }
        });
        return LazyToolStack.success((ItemStack)TicEXUtils.applyCatalystEmbossment(resultStack, inv, true));
    }
}

