/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.lib.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import moffy.ticex.lib.hook.EmbossmentModifierHook;
import moffy.ticex.lib.utils.TicEXUtils;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class EmbossmentModifierRecipe
extends AbstractModifierRecipe {
    public static final RecordLoadable<EmbossmentModifierRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)SizedIngredient.LOADABLE.list(1).requiredField("inputs", r -> r.inputs), (RecordField)SizedIngredient.LOADABLE.list(1).requiredField("emboss_inputs", r -> r.embossItem), (RecordField)TOOLS_FIELD, (RecordField)MAX_TOOL_SIZE_FIELD, (RecordField)RESULT_FIELD, (RecordField)LEVEL_FIELD, (RecordField)SLOTS_FIELD, EmbossmentModifierRecipe::new);
    private final List<SizedIngredient> embossItem;
    private final List<SizedIngredient> inputs;
    private List<SizedIngredient> ingredientsCache;

    public EmbossmentModifierRecipe(ResourceLocation id, List<SizedIngredient> inputs, List<SizedIngredient> embossItem, Ingredient toolRequirement, int maxToolSize, ModifierId result, IntRange level, @Nullable SlotType.SlotCount slots) {
        super(id, toolRequirement, maxToolSize, result, level, slots, false, false);
        this.inputs = inputs;
        this.embossItem = embossItem;
    }

    public boolean matches(ITinkerStationContainer container, Level level) {
        if (!this.result.isBound() || !this.toolRequirement.test(container.getTinkerableStack())) {
            return false;
        }
        if (this.ingredientsCache == null) {
            this.ingredientsCache = new ArrayList<SizedIngredient>();
        } else {
            this.ingredientsCache.clear();
        }
        this.ingredientsCache.addAll(this.inputs);
        this.ingredientsCache.addAll(this.embossItem);
        return ModifierRecipe.checkMatch((ITinkerableContainer)container, this.ingredientsCache);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TicEXRegistry.MODIFIER_EMBOSSMENT_RECIPE_SERIALIZER.get();
    }

    public void updateInputs(LazyToolStack arg0, IMutableTinkerStationContainer arg1, boolean arg2) {
        ModifierRecipe.updateInputs((ITinkerableContainer.Mutable)arg1, this.inputs);
        ModifierRecipe.updateInputs((ITinkerableContainer.Mutable)arg1, this.embossItem);
    }

    public List<ItemStack> getDisplayItems(int slot) {
        if (slot >= 0 && slot < this.inputs.size() + this.embossItem.size()) {
            if (slot < this.inputs.size()) {
                return this.inputs.get(slot).getMatchingStacks();
            }
            return this.embossItem.get(slot - this.inputs.size()).getMatchingStacks();
        }
        return Collections.emptyList();
    }

    public int getInputCount() {
        return this.inputs.size() + this.embossItem.size();
    }

    public RecipeResult<LazyToolStack> getValidatedResult(ITinkerStationContainer inv, RegistryAccess access) {
        ToolStack tool = inv.getTinkerable();
        Component commonError = this.validatePrerequisites((IToolStackView)tool);
        if (commonError != null) {
            return RecipeResult.failure((Component)commonError);
        }
        ModifierId modifier = this.result.getId();
        if ((tool = tool.copy()).getModifierLevel(modifier) == 0) {
            SlotType.SlotCount slots = this.getSlots();
            if (slots != null) {
                tool.getPersistentData().addSlots(slots.type(), -slots.count());
            }
        } else {
            tool.removeModifier(modifier, 1);
        }
        tool.addModifier(modifier, 1);
        boolean result = false;
        ItemStack resultStack = tool.createStack();
        EmbossmentModifierHook.EmbossmentContext context = new EmbossmentModifierHook.EmbossmentContext(resultStack, inv);
        boolean secondary = false;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack input = inv.getInput(i);
            if (this.embossItem.get(0).test(input)) {
                result = ((EmbossmentModifierHook)tool.getModifier(modifier).getHook(TicEXRegistry.EMBOSSMENT_HOOK)).applyItem(context, i, secondary);
            }
            secondary = true;
        }
        if (result) {
            return LazyToolStack.success((ItemStack)TicEXUtils.applyCatalystEmbossment(context.getToolStack(), inv, false));
        }
        return RecipeResult.failure((Component)context.getErrorMsg());
    }
}

