/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.lib.recipe;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import moffy.ticex.lib.hook.EmbossmentModifierHook;
import moffy.ticex.lib.utils.TicEXUtils;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class SingleEmbossmentModifierRecipe
extends AbstractModifierRecipe {
    public static final RecordLoadable<SingleEmbossmentModifierRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)IngredientLoadable.DISALLOW_EMPTY.requiredField("emboss_input", r -> r.input), (RecordField)TOOLS_FIELD, (RecordField)MAX_TOOL_SIZE_FIELD, (RecordField)RESULT_FIELD, (RecordField)LEVEL_FIELD, (RecordField)SLOTS_FIELD, SingleEmbossmentModifierRecipe::new);
    private final Ingredient input;
    private List<List<ItemStack>> slotCache;

    public SingleEmbossmentModifierRecipe(ResourceLocation id, Ingredient input, Ingredient toolRequirement, int maxToolSize, ModifierId result, IntRange level, SlotType.SlotCount slots) {
        super(id, toolRequirement, maxToolSize, result, level, slots, false, false);
        this.input = input;
    }

    public boolean matches(ITinkerStationContainer inv, Level level) {
        if (!this.result.isBound() || !this.toolRequirement.test(inv.getTinkerableStack())) {
            return false;
        }
        return IncrementalModifierRecipe.containsOnlyIngredient((ITinkerableContainer)inv, (Ingredient)this.input);
    }

    public RecipeResult<LazyToolStack> getValidatedResult(ITinkerStationContainer inv, RegistryAccess access) {
        ModifierId modifier;
        ToolStack tool = inv.getTinkerable().copy();
        if (tool.getModifierLevel(modifier = this.result.getId()) == 0) {
            SlotType.SlotCount slots = this.getSlots();
            if (slots != null) {
                tool.getPersistentData().addSlots(slots.type(), -slots.count());
            }
        } else {
            tool.removeModifier(modifier, 1);
        }
        tool.addModifier(modifier, 1);
        boolean result = false;
        ItemStack resultStack = tool.createStack();
        EmbossmentModifierHook.EmbossmentContext context = new EmbossmentModifierHook.EmbossmentContext(resultStack, inv);
        boolean secondary = false;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack inputStack = inv.getInput(i);
            if (this.input.test(inputStack)) {
                result = ((EmbossmentModifierHook)tool.getModifier(modifier).getHook(TicEXRegistry.EMBOSSMENT_HOOK)).applyItem(context, i, secondary);
            }
            secondary = true;
        }
        if (result) {
            return LazyToolStack.success((ItemStack)TicEXUtils.applyCatalystEmbossment(context.getToolStack(), inv, false));
        }
        return RecipeResult.failure((Component)context.getErrorMsg());
    }

    public void updateInputs(LazyToolStack result, IMutableTinkerStationContainer inv, boolean isServer) {
        for (int index = 0; index < inv.getInputCount(); ++index) {
            inv.shrinkInput(index, inv.getInput(index).m_41613_());
        }
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TicEXRegistry.SINGLE_MODIFIER_EMBOSSMENT_RECIPE_SERIALIZER.get();
    }

    public List<ItemStack> getDisplayItems(int slot) {
        List<List<ItemStack>> inputs = this.getInputs();
        if (slot >= 0 && slot < inputs.size()) {
            return inputs.get(slot);
        }
        return Collections.emptyList();
    }

    public int getInputCount() {
        return this.getInputs().size();
    }

    private List<List<ItemStack>> getInputs() {
        if (this.slotCache == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            List<ItemStack> items = Arrays.asList(this.input.m_43908_());
            builder.add(items);
            this.slotCache = builder.build();
        }
        return this.slotCache;
    }
}

