/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.lib.recipe;

import com.google.common.collect.ImmutableList;
import com.google.common.math.IntMath;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ValidatableIncrementalModifierRecipe
extends AbstractModifierRecipe {
    public static final RecordLoadable<ValidatableIncrementalModifierRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)IngredientLoadable.DISALLOW_EMPTY.requiredField("input", r -> r.input), (RecordField)IntLoadable.FROM_ONE.defaultField("amount_per_item", (Object)1, true, r -> r.amountPerInput), (RecordField)IntLoadable.FROM_ONE.requiredField("needed_per_level", r -> r.neededPerLevel), (RecordField)TOOLS_FIELD, (RecordField)MAX_TOOL_SIZE_FIELD, (RecordField)RESULT_FIELD, (RecordField)LEVEL_FIELD, (RecordField)SLOTS_FIELD, (RecordField)ItemOutput.Loadable.OPTIONAL_STACK.emptyField("leftover", r -> r.leftover), (RecordField)ALLOW_CRYSTAL_FIELD, (RecordField)CHECK_TRAIT_LEVEL_FIELD, ValidatableIncrementalModifierRecipe::new);
    private final Ingredient input;
    private final int amountPerInput;
    private final int neededPerLevel;
    private final ItemOutput leftover;
    private List<List<ItemStack>> slotCache;

    public ValidatableIncrementalModifierRecipe(ResourceLocation id, Ingredient input, int amountPerInput, int neededPerLevel, Ingredient toolRequirement, int maxToolSize, ModifierId result, IntRange level, SlotType.SlotCount slots, ItemOutput leftover, boolean allowCrystal, boolean checkTraitLevel) {
        super(id, toolRequirement, maxToolSize, result, level, slots, allowCrystal, checkTraitLevel);
        this.input = input;
        this.amountPerInput = amountPerInput;
        this.neededPerLevel = neededPerLevel;
        this.leftover = leftover;
    }

    public boolean matches(ITinkerStationContainer inv, Level level) {
        if (!this.result.isBound() || !this.toolRequirement.test(inv.getTinkerableStack())) {
            return false;
        }
        return this.matchesCrystal(inv) || IncrementalModifierRecipe.containsOnlyIngredient((ITinkerableContainer)inv, (Ingredient)this.input);
    }

    public RecipeResult<LazyToolStack> getValidatedResult(ITinkerStationContainer inv, RegistryAccess access) {
        SlotType.SlotCount slots;
        Component commonError;
        ToolStack tool = inv.getTinkerable();
        ModifierId modifier = this.result.getId();
        boolean newLevel = tool.getUpgrades().getEntry(modifier).getAmount(0) <= 0;
        boolean crystal = this.matchesCrystal(inv);
        if ((crystal || newLevel) && (commonError = this.validatePrerequisites((IToolStackView)tool)) != null) {
            return RecipeResult.failure((Component)commonError);
        }
        tool = tool.copy();
        if ((crystal || newLevel) && (slots = this.getSlots()) != null) {
            tool.getPersistentData().addSlots(slots.type(), -slots.count());
        }
        if (crystal) {
            tool.addModifier(modifier, 1);
        } else {
            tool.addModifierAmount(modifier, IncrementalModifierRecipe.getAvailableAmount((ITinkerStationContainer)inv, (Ingredient)this.input, (int)this.amountPerInput), this.neededPerLevel);
        }
        Component error = tool.tryValidate();
        if (error != null) {
            return RecipeResult.failure((Component)error);
        }
        return this.success(tool, inv);
    }

    public void updateInputs(LazyToolStack result, IMutableTinkerStationContainer inv, boolean isServer) {
        if (this.matchesCrystal((ITinkerStationContainer)inv)) {
            super.updateInputs(result, inv, isServer);
            return;
        }
        ToolStack inputTool = inv.getTinkerable();
        ModifierId modifier = this.result.getId();
        ModifierEntry inputEntry = inputTool.getUpgrades().getEntry(modifier);
        ModifierEntry resultEntry = result.getTool().getUpgrades().getEntry(modifier);
        int inputNeed = inputEntry.getNeeded();
        if (inputNeed == 0 || inputNeed == this.neededPerLevel) {
            IncrementalModifierRecipe.updateInputs((IMutableTinkerStationContainer)inv, (Ingredient)this.input, (int)(resultEntry.getAmount(this.neededPerLevel) - inputEntry.getAmount(0)), (int)this.amountPerInput, (ItemStack)this.leftover.get());
        } else {
            int gcd = IntMath.gcd((int)inputNeed, (int)this.neededPerLevel);
            int recipeScale = inputNeed / gcd;
            int used = resultEntry.getAmount(this.neededPerLevel) * recipeScale - inputEntry.getAmount(0) * this.neededPerLevel / gcd;
            IncrementalModifierRecipe.updateInputs((IMutableTinkerStationContainer)inv, (Ingredient)this.input, (int)((used + recipeScale - 1) / recipeScale), (int)this.amountPerInput, (ItemStack)this.leftover.get());
        }
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TicEXRegistry.VALIDATABLE_INCREMENTAL_RECIPE_SERIALIZER.get();
    }

    public boolean isIncremental() {
        return true;
    }

    private List<List<ItemStack>> getInputs() {
        if (this.slotCache == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            List<ItemStack> items = Arrays.asList(this.input.m_43908_());
            int maxStackSize = items.stream().mapToInt(ItemStack::m_41741_).min().orElse(64);
            int needed = this.neededPerLevel / this.amountPerInput;
            if (this.neededPerLevel % this.amountPerInput > 0) {
                ++needed;
            }
            Lazy fullSize = Lazy.of(() -> items.stream().map(stack -> ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)maxStackSize)).collect(Collectors.toList()));
            while (needed > maxStackSize) {
                builder.add((Object)((List)fullSize.get()));
                needed -= maxStackSize;
            }
            if (needed > 0) {
                int remaining = needed;
                builder.add(items.stream().map(stack -> ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)remaining)).collect(Collectors.toList()));
            }
            this.slotCache = builder.build();
        }
        return this.slotCache;
    }

    public int getInputCount() {
        return this.getInputs().size();
    }

    public List<ItemStack> getDisplayItems(int slot) {
        List<List<ItemStack>> inputs = this.getInputs();
        if (slot >= 0 && slot < inputs.size()) {
            return inputs.get(slot);
        }
        return Collections.emptyList();
    }
}

