/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.lib.utils;

import com.google.common.collect.ImmutableMap;
import dan200.computercraft.api.lua.MethodResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moffy.ticex.lib.IEntityDataAccessor;
import moffy.ticex.lib.hook.ProvidePropertyModifierHook;
import moffy.ticex.lib.utils.TicEXCuriosUtils;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class TicEXCCUtils {
    public static Map<String, Object> createEntityMapWithProps(Player player) {
        Map<String, Object> entityMap = TicEXCCUtils.createEntityMap((Entity)player);
        entityMap.put("getProperties", args -> MethodResult.of(TicEXCCUtils.gatherProperties(player)));
        return entityMap;
    }

    public static Map<String, Object> createEntityMap(Entity entity) {
        HashMap<String, Object> entityMap = new HashMap<String, Object>();
        if (entity != null) {
            entityMap.put("name", entity.m_5446_().getString());
            entityMap.put("uuid", entity.m_20148_().toString());
            entityMap.put("pos", new Object[]{entity.m_20182_().f_82479_, entity.m_20182_().f_82480_, entity.m_20182_().f_82481_});
            if (entity instanceof IEntityDataAccessor) {
                IEntityDataAccessor accessor = (IEntityDataAccessor)entity;
                entityMap.put("getData", args -> MethodResult.of((Object)ImmutableMap.copyOf(accessor.getAllFields())));
            }
        }
        return entityMap;
    }

    public static Map<String, Object> gatherProperties(Player player) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            ItemStack stack = player.m_6844_(slot);
            if (stack.m_41720_() instanceof IModifiable) {
                for (ModifierEntry entry : ToolStack.from((ItemStack)stack).getModifierList()) {
                    properties.putAll(((ProvidePropertyModifierHook)entry.getHook(TicEXRegistry.PROPERTY_PROVIDER_HOOK)).getPropertyProvider().apply(player, stack));
                }
            }
            result.put(slot.m_20751_(), properties);
        }
        if (ModList.get().isLoaded("curios")) {
            List<ItemStack> curioStacks = TicEXCuriosUtils.getAllToolStackInCurios((LivingEntity)player, curioStack -> curioStack.m_41720_() instanceof IModifiable);
            curioStacks.stream().forEach(curioStack -> {
                HashMap<String, Object> properties = new HashMap<String, Object>();
                for (ModifierEntry entry : ToolStack.from((ItemStack)curioStack).getModifierList()) {
                    properties.putAll(((ProvidePropertyModifierHook)entry.getHook(TicEXRegistry.PROPERTY_PROVIDER_HOOK)).getPropertyProvider().apply(player, (ItemStack)curioStack));
                }
                result.put(TicEXCuriosUtils.getEquipmentSlotNameInCurios((LivingEntity)player, curioStack), properties);
            });
        }
        return result;
    }
}

