/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.lib.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.items.IItemHandlerModifiable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class TicEXCuriosUtils {
    public static List<ItemStack> getAllToolStackInCurios(LivingEntity entity, Predicate<ItemStack> predicate) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        LazyOptional handlerOptional = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (handlerOptional.isPresent()) {
            ICuriosItemHandler handler = (ICuriosItemHandler)handlerOptional.orElseThrow(IllegalStateException::new);
            IItemHandlerModifiable curiosInv = handler.getEquippedCurios();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack curio = curiosInv.getStackInSlot(i);
                if (!predicate.test(curio)) continue;
                result.add(curio);
            }
        }
        return result;
    }

    public static ItemStack getToolStackInCurios(LivingEntity entity, Predicate<ItemStack> predicate) {
        LazyOptional handlerOptional = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (handlerOptional.isPresent()) {
            ICuriosItemHandler handler = (ICuriosItemHandler)handlerOptional.orElseThrow(IllegalStateException::new);
            IItemHandlerModifiable curiosInv = handler.getEquippedCurios();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack curio = curiosInv.getStackInSlot(i);
                if (!predicate.test(curio)) continue;
                return curio;
            }
        }
        return null;
    }

    public static String getEquipmentSlotNameInCurios(LivingEntity entity, ItemStack stack) {
        ICuriosItemHandler handler;
        Optional slotResultOptional;
        LazyOptional handlerOptional = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (handlerOptional.isPresent() && (slotResultOptional = (handler = (ICuriosItemHandler)handlerOptional.orElseThrow(IllegalStateException::new)).findFirstCurio(curio -> ItemStack.m_41656_((ItemStack)stack, (ItemStack)curio))).isPresent()) {
            SlotResult slotResult = (SlotResult)slotResultOptional.orElseThrow(IllegalStateException::new);
            return slotResult.slotContext().identifier();
        }
        return null;
    }

    public static EquipmentSlot resolveSlot(SlotContext context) {
        String identifier = context.identifier();
        if (identifier.equals("incomparable_head")) {
            return EquipmentSlot.HEAD;
        }
        if (identifier.equals("incomparable_chest")) {
            return EquipmentSlot.CHEST;
        }
        if (identifier.equals("incomparable_legs")) {
            return EquipmentSlot.LEGS;
        }
        if (identifier.equals("incomparable_feet")) {
            return EquipmentSlot.FEET;
        }
        if (identifier.equals("incomparable_offhand")) {
            return EquipmentSlot.OFFHAND;
        }
        return EquipmentSlot.MAINHAND;
    }

    public static String resolveEquipmentSlot(EquipmentSlot slot) {
        switch (slot) {
            case CHEST: {
                return "incomparable_chest";
            }
            case FEET: {
                return "incomparable_feet";
            }
            case HEAD: {
                return "incomparable_head";
            }
            case LEGS: {
                return "incomparable_legs";
            }
            case MAINHAND: {
                return "incomparable_mainhand";
            }
            case OFFHAND: {
                return "incomparable_offhand";
            }
        }
        return null;
    }

    public static void addCurioAttribute(ItemStack toolItemStack, ItemStack embossedStack) {
        CuriosApi.getCurio((ItemStack)embossedStack).ifPresent(embossedCurio -> CuriosApi.getItemStackSlots((ItemStack)toolItemStack, (FMLLoader.getDist() == Dist.CLIENT ? 1 : 0) != 0).forEach((s, iSlotType) -> {
            Item patt4745$temp = embossedStack.m_41720_();
            if (patt4745$temp instanceof ICurioItem) {
                ICurioItem embossedCurioItem = (ICurioItem)patt4745$temp;
                SlotContext slotContext = new SlotContext(iSlotType.getIdentifier(), null, 0, false, false);
                embossedCurioItem.getAttributeModifiers(slotContext, UUID.randomUUID(), embossedStack).forEach((attribute, attributeModifier) -> CuriosApi.addModifier((ItemStack)toolItemStack, (Attribute)attribute, (String)attributeModifier.m_22214_(), (UUID)attributeModifier.m_22209_(), (double)attributeModifier.m_22218_(), (AttributeModifier.Operation)attributeModifier.m_22217_(), (String)iSlotType.getIdentifier()));
            } else {
                embossedCurio.getAttributeModifiers(s).forEach((attribute, attributeModifier) -> CuriosApi.addModifier((ItemStack)toolItemStack, (Attribute)attribute, (String)attributeModifier.m_22214_(), (UUID)attributeModifier.m_22209_(), (double)attributeModifier.m_22218_(), (AttributeModifier.Operation)attributeModifier.m_22217_(), (String)iSlotType.getIdentifier()));
            }
        }));
    }
}

