/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.lib.utils;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.Face;
import mods.flammpfeil.slashblade.client.renderer.model.obj.GroupObject;
import mods.flammpfeil.slashblade.client.renderer.model.obj.Vertex;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.init.DefaultResources;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.SwordType;
import moffy.ticex.TicEXConfig;
import moffy.ticex.client.modules.slashblade.SBToolBladeItemRenderer;
import moffy.ticex.client.modules.slashblade.SBToolRenderType;
import moffy.ticex.client.rendering.ItemRenderContext;
import moffy.ticex.client.rendering.shader.ShaderProvider;
import moffy.ticex.client.rendering.ticex.TicEXToolRenders;
import moffy.ticex.item.modifiable.ModifiableSlashBladeItem;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;

public class TicEXSBUtils {
    public static Set<Enchantment> disallowedEnchantments = new HashSet<Enchantment>();
    public static Supplier<Matrix4f> defaultTransform;
    private static final Map<ShaderProvider.Tool, RenderType> renderTypeCache;

    @OnlyIn(value=Dist.CLIENT)
    public static void tessellateWithShader(ItemStack stack, ItemRenderContext itemRenderContext, ShaderProvider.Tool shaderProvider, MaterialVariantId material, WavefrontObject wavefrontObject, VertexConsumer tessellator, MultiBufferSource bufferSource, SBToolRenderType.PartType partType, String ... groupNames) {
        boolean needShader = shaderProvider != null && (Boolean)TicEXConfig.USE_SHADER.get() != false;
        Material atlasMaterial = new Material(InventoryMenu.f_39692_, new ResourceLocation("ticex", "obj_tool/slashblade_tool/" + partType.getName()));
        TextureAtlasSprite sprite = atlasMaterial.m_119204_();
        VertexConsumer vertexConsumer = null;
        if (needShader) {
            shaderProvider.beginRender(stack, itemRenderContext);
            shaderProvider.beginRenderMaterial(stack, (MaterialVariantId)material.getId());
            shaderProvider.preRenderMaterial(stack, (MaterialVariantId)material.getId());
            shaderProvider.startRenderBatch(itemRenderContext, TicEXToolRenders.RenderPhase.OVERLAY_MATERIAL);
            vertexConsumer = bufferSource.m_6299_(TicEXSBUtils.getBladeRenderType(shaderProvider));
        }
        for (GroupObject groupObject : wavefrontObject.groupObjects) {
            for (String groupName : groupNames) {
                if (!groupName.equalsIgnoreCase(groupObject.name)) continue;
                if (needShader) {
                    TicEXSBUtils.renderWithShader(groupObject, vertexConsumer, sprite);
                    continue;
                }
                groupObject.render(tessellator);
            }
        }
        if (needShader) {
            shaderProvider.endRenderBatch(itemRenderContext, TicEXToolRenders.RenderPhase.OVERLAY_MATERIAL);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderWithShader(GroupObject groupObject, VertexConsumer tessellator, TextureAtlasSprite sprite) {
        if (groupObject.faces.isEmpty()) {
            return;
        }
        for (Face face : groupObject.faces) {
            TicEXSBUtils.addFaceForRender(face, tessellator, sprite);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addFaceForRender(Face face, VertexConsumer tessellator, TextureAtlasSprite sprite) {
        Matrix4f transform;
        float textureOffset = 5.0E-4f;
        if (face.faceNormal == null) {
            face.faceNormal = face.calculateFaceNormal();
        }
        float averageU = 0.0f;
        float averageV = 0.0f;
        if (face.textureCoordinates != null && face.textureCoordinates.length > 0) {
            for (int i = 0; i < face.textureCoordinates.length; ++i) {
                averageU += face.textureCoordinates[i].u * Face.uvOperator.x() + Face.uvOperator.z();
                averageV += face.textureCoordinates[i].v * Face.uvOperator.y() + Face.uvOperator.w();
            }
            averageU /= (float)face.textureCoordinates.length;
            averageV /= (float)face.textureCoordinates.length;
        }
        if (Face.matrix != null) {
            PoseStack.Pose me = Face.matrix.m_85850_();
            transform = me.m_252922_();
        } else {
            transform = defaultTransform.get();
        }
        for (int i = 0; i < face.vertices.length; ++i) {
            TicEXSBUtils.putVertex(face, tessellator, i, transform, 5.0E-4f, sprite, averageU, averageV);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void putVertex(Face face, VertexConsumer wr, int i, Matrix4f transform, float textureOffset, TextureAtlasSprite sprite, float averageU, float averageV) {
        Vector3f vector3f;
        wr.m_252986_(transform, face.vertices[i].x, face.vertices[i].y, face.vertices[i].z);
        wr.m_85950_(1.0f, 1.0f, 1.0f, (float)((Integer)Face.alphaOverride.apply(new Vector4f(face.vertices[i].x, face.vertices[i].y, face.vertices[i].z, 1.0f), Face.col.getAlpha())).intValue());
        if (face.textureCoordinates != null && face.textureCoordinates.length > 0) {
            float offsetU = textureOffset;
            float offsetV = textureOffset;
            float textureU = face.textureCoordinates[i].u * Face.uvOperator.x() + Face.uvOperator.z();
            float textureV = face.textureCoordinates[i].v * Face.uvOperator.y() + Face.uvOperator.w();
            if (textureU > averageU) {
                offsetU = -textureOffset;
            }
            if (textureV > averageV) {
                offsetV = -textureOffset;
            }
            wr.m_7421_(sprite.m_118409_() + (textureU + offsetU) * (sprite.m_118410_() - sprite.m_118409_()), sprite.m_118411_() + (textureV + offsetV) * (sprite.m_118412_() - sprite.m_118411_()));
        } else {
            wr.m_7421_(0.0f, 0.0f);
        }
        wr.m_86008_(OverlayTexture.f_118083_);
        wr.m_85969_(Face.lightmap);
        if (Face.isSmoothShade && face.vertexNormals != null) {
            Vertex normal = face.vertexNormals[i];
            Vec3 nol = new Vec3((double)normal.x, (double)normal.y, (double)normal.z);
            vector3f = new Vector3f((float)nol.f_82479_, (float)nol.f_82480_, (float)nol.f_82481_);
        } else {
            vector3f = new Vector3f(face.faceNormal.x, face.faceNormal.y, face.faceNormal.z);
        }
        vector3f.mul((Matrix3fc)new Matrix3f((Matrix4fc)transform));
        vector3f.normalize();
        wr.m_5601_(vector3f.x(), vector3f.y(), vector3f.z());
        wr.m_5752_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getBladeRenderType(ShaderProvider.Tool shaderProvider) {
        if (renderTypeCache.containsKey(shaderProvider)) {
            return renderTypeCache.get(shaderProvider);
        }
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(shaderProvider::getShaderInstance)).m_110675_(RenderStateShard.f_110129_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(InventoryMenu.f_39692_, false, true)).m_110685_(RenderStateShard.f_110134_).m_110671_(RenderType.f_110152_).m_110677_(RenderType.f_110154_).m_110687_(RenderStateShard.f_110114_).m_110691_(true);
        RenderType.CompositeRenderType renderType = RenderType.m_173215_((String)"slashblade_tool_shader_blend", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
        renderTypeCache.put(shaderProvider, (RenderType)renderType);
        return renderType;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean renderBladeTool(ItemStack stack, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        Item itemIn = stack.m_41720_();
        if (itemIn instanceof ModifiableSlashBladeItem) {
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-135.0f));
            try (MSAutoCloser msac = MSAutoCloser.pushMatrix((PoseStack)matrixStackIn);){
                boolean bl;
                block17: {
                    EnumSet types = SwordType.from((ItemStack)stack);
                    ResourceLocation modelLocation = stack.getCapability(ItemSlashBlade.BLADESTATE).map(state -> state.getModel().orElse(DefaultResources.resourceDefaultModel)).orElse(DefaultResources.resourceDefaultModel);
                    Optional textureLoc = stack.getCapability(ItemSlashBlade.BLADESTATE).map(state -> state.getTexture().orElse(DefaultResources.resourceDefaultTexture));
                    ResourceLocation textureLocation = textureLoc.orElse(DefaultResources.resourceDefaultTexture);
                    WavefrontObject model = BladeModelManager.getInstance().getModel(modelLocation);
                    float scale = 0.00625f;
                    MSAutoCloser msac2 = MSAutoCloser.pushMatrix((PoseStack)matrixStackIn);
                    try {
                        String renderTarget;
                        float xOffset = 0.0f;
                        if (types.contains(SwordType.EDGEFRAGMENT)) {
                            xOffset = 200.0f;
                            renderTarget = "blade_fragment";
                        } else if (types.contains(SwordType.BROKEN)) {
                            xOffset = 30.0f;
                            renderTarget = "blade_damaged";
                        } else {
                            xOffset = 120.0f;
                            renderTarget = "blade";
                        }
                        matrixStackIn.m_85841_(scale, scale, scale);
                        matrixStackIn.m_252880_(xOffset, -1.25f, 0.0f);
                        ItemRenderContext itemRenderContext = new ItemRenderContext(stack, ItemDisplayContext.GROUND, false, matrixStackIn, bufferIn, packedLightIn, OverlayTexture.f_118083_);
                        SBToolBladeItemRenderer.renderToolSlashBlade(stack, itemRenderContext, model, textureLocation, renderTarget, matrixStackIn, bufferIn, packedLightIn);
                        bl = true;
                        if (msac2 == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (msac2 != null) {
                            try {
                                msac2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    msac2.close();
                }
                return bl;
            }
        }
        return false;
    }

    public static boolean applyEnchantment(ItemStack toolStack, Enchantment enchantment, int level) {
        for (Enchantment disallowed : disallowedEnchantments) {
            if (enchantment.m_44704_().equals(disallowed.m_44704_())) continue;
            if (toolStack.getEnchantmentLevel(enchantment) > 0) {
                CompoundTag nbt = toolStack.m_41784_();
                if (!nbt.m_128425_("Enchantments", 9)) {
                    nbt.m_128365_("Enchantments", (Tag)new ListTag());
                }
                ListTag listTag = nbt.m_128437_("Enchantments", 10);
                ListTag newListTag = new ListTag();
                for (int i = 0; i < listTag.size(); ++i) {
                    CompoundTag enchantmentTag = listTag.m_128728_(i);
                    if (enchantmentTag.m_128461_("id").equals(Objects.requireNonNull(ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment)).toString())) {
                        newListTag.add((Object)EnchantmentHelper.m_182443_((ResourceLocation)ResourceLocation.m_135820_((String)enchantmentTag.m_128461_("id")), (int)TicEXSBUtils.calcEnchLevel(toolStack, enchantment, level)));
                        continue;
                    }
                    newListTag.add((Object)enchantmentTag);
                }
                nbt.m_128365_("Enchantments", (Tag)newListTag);
            } else {
                toolStack.m_41663_(enchantment, Math.min(enchantment.m_6586_(), level));
            }
            return true;
        }
        return false;
    }

    public static int calcEnchLevel(ItemStack stack, Enchantment key, int value) {
        int currentLv = stack.getEnchantmentLevel(key);
        int levelCap = key.m_6586_();
        if (value == currentLv) {
            return Math.min(value + 1, levelCap);
        }
        return Math.min(Math.max(value, currentLv), levelCap);
    }

    static {
        disallowedEnchantments.add(Enchantments.f_44986_);
        disallowedEnchantments.add(Enchantments.f_44962_);
        disallowedEnchantments.add(Enchantments.f_44977_);
        disallowedEnchantments.add(Enchantments.f_44979_);
        disallowedEnchantments.add(Enchantments.f_44978_);
        disallowedEnchantments.add(Enchantments.f_44981_);
        disallowedEnchantments.add(Enchantments.f_44980_);
        disallowedEnchantments.add(Enchantments.f_44982_);
        defaultTransform = Suppliers.memoize(() -> {
            Matrix4f m = new Matrix4f();
            m.identity();
            return m;
        });
        renderTypeCache = new HashMap<ShaderProvider.Tool, RenderType>();
    }
}

