/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.lib.utils;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import moffy.ticex.lib.utils.TicEXAvaritiaUtils;
import moffy.ticex.lib.utils.TicEXCuriosUtils;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class TicEXUtils {
    public static boolean isPureDamage(DamageSource source, float damage) {
        boolean isInfinityDamage = false;
        if (ModList.get().isLoaded("avaritia")) {
            isInfinityDamage = TicEXAvaritiaUtils.isInfinityDamage(source);
        }
        return source.m_276093_(DamageTypes.f_268724_) || isInfinityDamage || damage == Float.MAX_VALUE && source.m_269533_(DamageTypeTags.f_268490_) && source.m_269533_(DamageTypeTags.f_268738_);
    }

    public static boolean canPlayerFly(Player player) {
        boolean canFly = player.m_150110_().f_35936_;
        if (ModList.get().isLoaded("avaritia")) {
            canFly = canFly || TicEXAvaritiaUtils.hasCelestial(player);
        }
        return canFly;
    }

    public static ItemStack getToolStack(IToolStackView tool, LivingEntity entity, Modifier modifier) {
        return TicEXUtils.getToolStack(tool, entity, (ItemStack stack) -> ToolStack.from((ItemStack)stack).getModifierLevel(modifier) > 0);
    }

    public static ItemStack getToolStack(IToolStackView tool, LivingEntity entity, Predicate<ItemStack> predicate) {
        ItemStack curioStack;
        if (tool instanceof ToolStack) {
            return ((ToolStack)tool).createStack();
        }
        ItemStack mainHandStack = entity.m_21205_();
        if (mainHandStack.m_41720_() instanceof IModifiable && predicate.test(mainHandStack)) {
            return mainHandStack;
        }
        ItemStack offHandStack = entity.m_21206_();
        if (offHandStack.m_41720_() instanceof IModifiable && predicate.test(offHandStack)) {
            return offHandStack;
        }
        if (ModList.get().isLoaded("curios") && (curioStack = TicEXCuriosUtils.getToolStackInCurios(entity, predicate)) != null) {
            return curioStack;
        }
        return ItemStack.f_41583_;
    }

    public static String getEquipmentSlotName(LivingEntity entity, ItemStack stack) {
        String curioName;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (!ItemStack.m_41656_((ItemStack)entity.m_6844_(slot), (ItemStack)stack)) continue;
            return slot.m_20751_();
        }
        if (ModList.get().isLoaded("curios") && (curioName = TicEXCuriosUtils.getEquipmentSlotNameInCurios(entity, stack)) != null) {
            return curioName;
        }
        return null;
    }

    public static ItemStack applyCatalystEmbossment(ItemStack toolItemStack, ITinkerStationContainer inv, boolean copyAttribute) {
        boolean containsCatalyst = false;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack input = inv.getInput(i);
            if (!input.m_41784_().m_128441_("embossed")) continue;
            containsCatalyst = true;
            CompoundTag embossedTag = Objects.requireNonNull(input.m_41783_()).m_128469_("embossed");
            CompoundTag tagTmp = embossedTag.m_6426_();
            if (embossedTag.m_128441_("id")) {
                CompoundTag stackTag = embossedTag.m_6426_();
                stackTag.m_128365_("tag", (Tag)new CompoundTag());
                if (copyAttribute) {
                    ItemStack embossedStack = ItemStack.m_41712_((CompoundTag)stackTag);
                    for (EquipmentSlot slot : EquipmentSlot.values()) {
                        Multimap attributeModifierMultimap = toolItemStack.m_41638_(slot);
                        ArrayListMultimap tmp = ArrayListMultimap.create();
                        embossedStack.m_41638_(slot).asMap().forEach((arg_0, arg_1) -> TicEXUtils.lambda$applyCatalystEmbossment$1(attributeModifierMultimap, (Multimap)tmp, arg_0, arg_1));
                        tmp.forEach((attribute, attributeModifier) -> toolItemStack.m_41643_(attribute, attributeModifier, slot));
                    }
                    if (ModList.get().isLoaded("curios")) {
                        TicEXCuriosUtils.addCurioAttribute(toolItemStack, embossedStack);
                    }
                }
                tagTmp = embossedTag.m_128469_("tag").m_6426_();
            }
            CompoundTag compoundTag = toolItemStack.m_41784_();
            for (String key : tagTmp.m_128431_()) {
                Tag merged = compoundTag.m_128441_(key) ? compoundTag.m_128423_(key) : tagTmp.m_128423_(key).m_6426_();
                compoundTag.m_128365_(key, merged);
            }
        }
        ToolStack toolStack = ToolStack.from((ItemStack)toolItemStack);
        if (containsCatalyst && toolStack.getModifierLevel(TicEXRegistry.REBIRTH_MODIFIER.get()) < 1) {
            toolStack.addModifier(TicEXRegistry.REBIRTH_MODIFIER.getId(), 1);
        }
        return toolStack.createStack();
    }

    private static /* synthetic */ void lambda$applyCatalystEmbossment$1(Multimap attributeModifierMultimap, Multimap tmp, Attribute attribute, Collection attributeModifier) {
        if (!attributeModifierMultimap.containsKey((Object)attribute)) {
            tmp.putAll((Object)attribute, (Iterable)attributeModifier);
        }
    }
}

