/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.mixin;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import moffy.ticex.TicEX;
import moffy.ticex.lib.IEntityDataAccessor;
import moffy.ticex.mixin.DataItemAccessor;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements IEntityDataAccessor {
    @Shadow
    @Final
    protected SynchedEntityData f_19804_;
    @Unique
    private Map<String, Field> accessorMap;

    private void initializeAccessorMap(Entity entity) {
        this.accessorMap = new HashMap<String, Field>();
        if (entity instanceof LivingEntity) {
            for (Field field : LivingEntity.class.getDeclaredFields()) {
                field.setAccessible(true);
                this.accessorMap.put(field.getName(), field);
            }
        }
        for (Field field : entity.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            this.accessorMap.put(field.getName(), field);
        }
    }

    @Override
    public Map<String, Object> getAllFields() {
        if (this.accessorMap == null) {
            this.initializeAccessorMap((Entity)this);
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (Map.Entry<String, Field> entry : this.accessorMap.entrySet()) {
            Field key = entry.getValue();
            try {
                if (EntityDataAccessor.class.isAssignableFrom(key.getType())) {
                    this.f_19804_.m_135370_((EntityDataAccessor)key.get(this));
                    continue;
                }
                fields.put(entry.getKey(), key.get(this));
            }
            catch (Exception e) {
                TicEX.LOGGER.error("", (Throwable)e);
            }
        }
        return fields;
    }

    @Override
    public Field getField(String keyName) {
        if (this.accessorMap == null) {
            this.initializeAccessorMap((Entity)this);
        }
        return this.accessorMap.get(keyName);
    }

    @Override
    public <T> boolean setValue(Field field, Class<T> cls, Object value) {
        Optional<DataItemAccessor> accessorOptional = EntityMixin.toAccessor(this.f_19804_);
        if (accessorOptional.isPresent()) {
            DataItemAccessor accessor = accessorOptional.get();
            Int2ObjectMap<SynchedEntityData.DataItem<?>> items = accessor.getItems();
            try {
                if (EntityDataAccessor.class.isAssignableFrom(field.getType())) {
                    EntityDataAccessor dataAccessor = (EntityDataAccessor)field.get((Entity)this);
                    SynchedEntityData.DataItem dataitem = (SynchedEntityData.DataItem)items.get(dataAccessor.m_135015_());
                    dataitem.m_135397_(value);
                    ((Entity)this).m_7350_(dataAccessor);
                    dataitem.m_135401_(true);
                    accessor.setDirtyByTicEX(true);
                    return true;
                }
                if (value.getClass().isAssignableFrom(field.getType())) {
                    field.set((Entity)this, value);
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    @Unique
    private static Optional<DataItemAccessor> toAccessor(SynchedEntityData data) {
        if (data instanceof DataItemAccessor) {
            return Optional.of((DataItemAccessor)data);
        }
        return Optional.empty();
    }
}

