/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.mixin;

import java.util.Optional;
import java.util.function.Function;
import moffy.ticex.TicEXConfig;
import moffy.ticex.client.rendering.shader.ShaderProvider;
import moffy.ticex.client.rendering.shader.TintedShaderArmorTexture;
import moffy.ticex.client.rendering.ticex.TicEXRenders;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import slimeknights.tconstruct.library.client.armor.texture.ArmorTextureSupplier;
import slimeknights.tconstruct.library.client.armor.texture.MaterialArmorTextureSupplier;
import slimeknights.tconstruct.library.client.armor.texture.TintedArmorTexture;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;

@Debug(export=true)
@Mixin(value={MaterialArmorTextureSupplier.class}, remap=false)
public abstract class MaterialArmorTextureSupplierMixin {
    @Shadow
    private static ArmorTextureSupplier.ArmorTexture tryTexture(ResourceLocation name, int color, String material) {
        return null;
    }

    @Inject(method={"materialGetter"}, at={@At(value="HEAD")}, cancellable=true)
    private static void materialGetterExtension(ResourceLocation name, CallbackInfoReturnable<Function<String, ArmorTextureSupplier.ArmorTexture>> cir) {
        cir.setReturnValue((Object)Util.m_143827_(materialStr -> {
            if (!materialStr.isEmpty()) {
                MaterialVariantId material = MaterialVariantId.tryParse((String)materialStr);
                ShaderProvider.Armor shaderProvider = (ShaderProvider.Armor)TicEXRenders.ARMOR_SHADERS.getShaderProvider(material);
                int color = -1;
                if (material != null) {
                    Optional infoOptional = MaterialRenderInfoLoader.INSTANCE.getRenderInfo(material);
                    if (infoOptional.isPresent()) {
                        ArmorTextureSupplier.ArmorTexture texture;
                        MaterialRenderInfo info = (MaterialRenderInfo)infoOptional.get();
                        ResourceLocation untinted = info.texture();
                        if (untinted != null && (texture = MaterialArmorTextureSupplierMixin.tryTexture(name, -1, "_" + untinted.m_135827_() + "_" + untinted.m_135815_())) != ArmorTextureSupplier.ArmorTexture.EMPTY) {
                            return MaterialArmorTextureSupplierMixin.ticex$getArmorTexture(texture, MaterialArmorTextureSupplierMixin.ticex$getAtlasLocation(name), color, shaderProvider);
                        }
                        color = info.vertexColor();
                        for (String fallback : info.fallbacks()) {
                            ArmorTextureSupplier.ArmorTexture texture2 = MaterialArmorTextureSupplierMixin.tryTexture(name, color, "_" + fallback);
                            if (texture2 == ArmorTextureSupplier.ArmorTexture.EMPTY) continue;
                            return MaterialArmorTextureSupplierMixin.ticex$getArmorTexture(texture2, MaterialArmorTextureSupplierMixin.ticex$getAtlasLocation(name), color, shaderProvider);
                        }
                    }
                    return MaterialArmorTextureSupplierMixin.ticex$getArmorTexture((ArmorTextureSupplier.ArmorTexture)new TintedArmorTexture(ArmorTextureSupplier.getTexturePath((ResourceLocation)name), -1), MaterialArmorTextureSupplierMixin.ticex$getAtlasLocation(name), -1, shaderProvider);
                }
                return new TintedArmorTexture(ArmorTextureSupplier.getTexturePath((ResourceLocation)name), color);
            }
            return ArmorTextureSupplier.ArmorTexture.EMPTY;
        }));
    }

    @Unique
    private static ArmorTextureSupplier.ArmorTexture ticex$getArmorTexture(ArmorTextureSupplier.ArmorTexture texture, ResourceLocation path, int color, ShaderProvider.Armor shaderProvider) {
        if (shaderProvider != null && ((Boolean)TicEXConfig.USE_SHADER.get()).booleanValue()) {
            return new TintedShaderArmorTexture(path, color, shaderProvider);
        }
        return texture;
    }

    @Unique
    private static ResourceLocation ticex$getAtlasLocation(ResourceLocation name) {
        return new ResourceLocation(name.m_135827_(), "tinker_armor/" + name.m_135815_());
    }
}

