/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.mixin.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import moffy.ticex.TicEXConfig;
import moffy.ticex.lib.config.SlotValues;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionLoader;

@Mixin(value={ToolDefinitionLoader.class}, remap=false)
public class ToolDefinitionLoaderMixin {
    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="HEAD")})
    private void modify(@NotNull Map<ResourceLocation, JsonElement> splashList, ResourceManager resourceManagerIn, ProfilerFiller profilerIn, CallbackInfo ci) {
        try {
            if (((Boolean)TicEXConfig.USE_MORE_CONFIG.get()).booleanValue()) {
                splashList.forEach((resourceLocation, jsonElement) -> TicEXConfig.SLOTS_CONFIG.forEach((rl, spec) -> {
                    SlotValues slots;
                    if (rl.equals(resourceLocation) && (slots = SlotValues.fromSpec(spec)) != null) {
                        this.modifySlots((ResourceLocation)resourceLocation, (JsonElement)jsonElement, slots);
                    }
                }));
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Unique
    private void modifySlots(ResourceLocation rl, JsonElement json, SlotValues slots) {
        JsonArray modules = json.getAsJsonObject().getAsJsonArray("modules");
        if (modules != null) {
            modules.forEach(elem -> {
                JsonObject slotObj;
                JsonObject module = elem.getAsJsonObject();
                if (module.has("type") && "tconstruct:modifier_slots".equals(module.get("type").getAsString()) && (slotObj = module.getAsJsonObject("slots")) != null) {
                    if (slots.abilities != null) {
                        slotObj.addProperty("abilities", (Number)slots.abilities);
                    }
                    if (slots.defense != null) {
                        slotObj.addProperty("defense", (Number)slots.defense);
                    }
                    if (slots.upgrades != null) {
                        slotObj.addProperty("upgrades", (Number)slots.upgrades);
                    }
                }
            });
        }
    }
}

