/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.mixin.mekanism;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import mekanism.api.gear.ModuleData;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.common.Mekanism;
import mekanism.common.content.gear.ModuleHelper;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import slimeknights.tconstruct.library.tools.item.IModifiable;

@Mixin(value={ModuleHelper.class}, remap=false, priority=900)
public abstract class ModuleHelperMixin {
    @Shadow
    protected Map<Item, Set<ModuleData<?>>> supportedModules;

    @Shadow
    private void logDebugReceivedIMC(String imcMethod, String senderModId, IModuleDataProvider<?> moduleDataProvider) {
    }

    @Inject(method={"processIMC"}, at={@At(value="INVOKE", ordinal=4, shift=At.Shift.AFTER, target="Lmekanism/common/content/gear/ModuleHelper;mapSupportedModules(Lnet/minecraftforge/fml/event/lifecycle/InterModProcessEvent;Ljava/lang/String;Lmekanism/api/providers/IItemProvider;Ljava/util/Map;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    void processIMC(InterModProcessEvent event, CallbackInfo ci, Map<ModuleData<?>, ImmutableSet.Builder<Item>> supportedContainersBuilderMap) {
        this.mixinMapSupportedModules(event, "add_mekaplate_helmet_modules", (IModifiable)TicEXRegistry.MEKAPLATE_ARMOR.get((Enum)ArmorItem.Type.HELMET), supportedContainersBuilderMap);
        this.mixinMapSupportedModules(event, "add_mekaplate_chestplate_modules", (IModifiable)TicEXRegistry.MEKAPLATE_ARMOR.get((Enum)ArmorItem.Type.CHESTPLATE), supportedContainersBuilderMap);
        this.mixinMapSupportedModules(event, "add_mekaplate_leggings_modules", (IModifiable)TicEXRegistry.MEKAPLATE_ARMOR.get((Enum)ArmorItem.Type.LEGGINGS), supportedContainersBuilderMap);
        this.mixinMapSupportedModules(event, "add_mekaplate_boots_modules", (IModifiable)TicEXRegistry.MEKAPLATE_ARMOR.get((Enum)ArmorItem.Type.BOOTS), supportedContainersBuilderMap);
        this.mixinMapSupportedModules(event, "add_modifiable_meka_tool_modules", (IModifiable)TicEXRegistry.MEKA_EDGE.get(), supportedContainersBuilderMap);
    }

    private void mixinMapSupportedModules(InterModProcessEvent event, String imcMethod, IModifiable item, Map<ModuleData<?>, ImmutableSet.Builder<Item>> supportedContainersBuilderMap) {
        ImmutableSet.Builder supportedModulesBuilder = ImmutableSet.builder();
        event.getIMCStream(imcMethod::equals).forEach(message -> {
            Object body = message.messageSupplier().get();
            if (body instanceof IModuleDataProvider) {
                IModuleDataProvider moduleDataProvider = (IModuleDataProvider)body;
                supportedModulesBuilder.add((Object)moduleDataProvider.getModuleData());
                this.logDebugReceivedIMC(imcMethod, message.senderModId(), moduleDataProvider);
            } else if (body instanceof IModuleDataProvider[]) {
                IModuleDataProvider[] providers;
                for (IModuleDataProvider moduleDataProvider : providers = (IModuleDataProvider[])body) {
                    supportedModulesBuilder.add((Object)moduleDataProvider.getModuleData());
                    this.logDebugReceivedIMC(imcMethod, message.senderModId(), moduleDataProvider);
                }
            } else {
                Mekanism.logger.warn("Received IMC message for '{}' from mod '{}' with an invalid body.", (Object)imcMethod, (Object)message.senderModId());
            }
        });
        ImmutableSet supported = supportedModulesBuilder.build();
        if (!supported.isEmpty() && item instanceof Item) {
            this.supportedModules.put((Item)item, (Set<ModuleData<?>>)supported);
            for (ModuleData data : supported) {
                supportedContainersBuilderMap.computeIfAbsent(data, d -> ImmutableSet.builder()).add((Object)((Item)item));
            }
        }
    }
}

