/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.mixin.slashblade;

import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.util.AttackManager;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

@Mixin(value={AttackManager.class}, remap=false)
public class AttackManagerMixin {
    @Inject(at={@At(value="HEAD")}, method={"doAttackWith"}, cancellable=true)
    private static void doAttackWith(DamageSource src, float amount, Entity target, boolean forceHit, boolean resetHit, CallbackInfo cb) {
        LivingEntity livingAttacker;
        ItemStack mainHandStack;
        if (target instanceof EntityAbstractSummonedSword) {
            return;
        }
        Entity attacker = src.m_7639_();
        if (attacker instanceof LivingEntity && (mainHandStack = (livingAttacker = (LivingEntity)attacker).m_21205_()).m_41720_() instanceof IModifiable) {
            LivingEntity livingTarget;
            Player player;
            ToolStack tool = ToolStack.from((ItemStack)mainHandStack);
            ToolAttackContext context = new ToolAttackContext(livingAttacker, livingAttacker instanceof Player ? (player = (Player)livingAttacker) : null, InteractionHand.MAIN_HAND, target, target instanceof LivingEntity ? (livingTarget = (LivingEntity)target) : null, false, 0.0f, false);
            AttackManagerMixin.ticex_1_20_1$dealToolDamage((IToolStackView)tool, context, livingAttacker, src, amount, target, forceHit, resetHit);
            cb.cancel();
        }
    }

    @Unique
    private static void ticex_1_20_1$dealToolDamage(IToolStackView tool, ToolAttackContext context, LivingEntity livingAttacker, DamageSource src, float amount, Entity target, boolean forceHit, boolean resetHit) {
        float amplifier;
        float amplifierTmp = amplifier = ToolAttackUtil.getAttributeAttackDamage((IToolStackView)tool, (LivingEntity)livingAttacker, (EquipmentSlot)EquipmentSlot.MAINHAND);
        for (ModifierEntry modifier : tool.getModifierList()) {
            amplifier = ((MeleeDamageModifierHook)modifier.getHook(ModifierHooks.MELEE_DAMAGE)).getMeleeDamage(tool, modifier, context, amplifierTmp, amplifier);
        }
        if (amplifier <= 0.0f) {
            return;
        }
        amount = amount / (float)livingAttacker.m_21133_(Attributes.f_22281_) * amplifier;
        if (forceHit) {
            target.f_19802_ = 0;
        }
        for (ModifierEntry modifier : tool.getModifierList()) {
            ((MeleeHitModifierHook)modifier.getHook(ModifierHooks.MELEE_HIT)).beforeMeleeHit(tool, modifier, context, amount, 0.0f, 0.0f);
        }
        boolean succeed = target.m_6469_(src, amount);
        if (resetHit) {
            target.f_19802_ = 0;
        }
        if (succeed) {
            for (ModifierEntry modifier : tool.getModifierList()) {
                ((MeleeHitModifierHook)modifier.getHook(ModifierHooks.MELEE_HIT)).afterMeleeHit(tool, modifier, context, amplifierTmp);
            }
        } else {
            for (ModifierEntry modifier : tool.getModifierList()) {
                ((MeleeHitModifierHook)modifier.getHook(ModifierHooks.MELEE_HIT)).failedMeleeHit(tool, modifier, context, amplifierTmp);
            }
        }
    }
}

