/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.mixin.slashblade;

import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.util.AttackHelper;
import mods.flammpfeil.slashblade.util.AttackManager;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

@Mixin(value={AttackHelper.class}, remap=false)
public abstract class PlayerAttackHelperMixin {
    @Shadow
    public static float getSweepingBonus(LivingEntity attacker) {
        return 0.0f;
    }

    @Shadow
    public static float getRankBonus(LivingEntity attacker) {
        return 0.0f;
    }

    @Shadow
    public static float getEnchantmentBonus(LivingEntity attacker, Entity target) {
        return 0.0f;
    }

    @Shadow
    public static float calculateKnockback(LivingEntity attacker) {
        return 0.0f;
    }

    @Shadow
    public static boolean isCriticalHit(LivingEntity attacker, Entity target) {
        return false;
    }

    @Shadow
    public static AttackHelper.FireAspectResult handleFireAspect(LivingEntity attacker, Entity target) {
        return null;
    }

    @Shadow
    public static void applyKnockback(LivingEntity attacker, Entity target, float knockback) {
    }

    @Shadow
    public static void restoreTargetMotionIfNeeded(Entity target, Vec3 originalMotion) {
    }

    @Shadow
    public static void playAttackEffects(LivingEntity attacker, Entity target, boolean isCritical) {
    }

    @Shadow
    public static void handleEnchantmentsAndDurability(LivingEntity attacker, Entity target) {
    }

    @Shadow
    public static void handlePostAttackEffects(LivingEntity attacker, Entity target, AttackHelper.FireAspectResult fireAspectResult) {
    }

    @Shadow
    public static void handleFailedAttack(LivingEntity attacker, Entity target, AttackHelper.FireAspectResult fireAspectResult) {
    }

    @Inject(at={@At(value="HEAD")}, method={"attack"}, cancellable=true)
    private static void attackExtension(LivingEntity attacker, Entity target, float comboRatio, CallbackInfo ci) {
        ItemStack stack = attacker.m_21205_();
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (stack.m_41720_() instanceof IModifiable) {
                if (ForgeHooks.onPlayerAttackTarget((Player)player, (Entity)target)) {
                    float baseDamage = (float)attacker.m_21133_(Attributes.f_22281_);
                    baseDamage += PlayerAttackHelperMixin.getSweepingBonus((LivingEntity)player);
                    baseDamage += PlayerAttackHelperMixin.getRankBonus((LivingEntity)player);
                    baseDamage += PlayerAttackHelperMixin.getEnchantmentBonus((LivingEntity)player, target);
                    if (!((baseDamage = (float)((double)baseDamage * (double)(comboRatio * AttackManager.getSlashBladeDamageScale((LivingEntity)attacker)) * (Double)SlashBladeConfig.SLASHBLADE_DAMAGE_MULTIPLIER.get())) <= 0.0f)) {
                        boolean isCritical;
                        float knockback = PlayerAttackHelperMixin.calculateKnockback((LivingEntity)player);
                        CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((Player)player, (Entity)target, (boolean)isCritical, (float)((isCritical = PlayerAttackHelperMixin.isCriticalHit((LivingEntity)player, target)) ? 1.5f : 1.0f));
                        boolean bl = isCritical = hitResult != null;
                        if (isCritical) {
                            baseDamage *= hitResult.getDamageModifier();
                        }
                        AttackHelper.FireAspectResult fireAspectResult = PlayerAttackHelperMixin.handleFireAspect((LivingEntity)player, target);
                        Vec3 originalMotion = target.m_20184_();
                        ToolStack bladeTool = ToolStack.from((ItemStack)stack);
                        float baseDamageTmp = baseDamage;
                        ToolAttackContext context = new ToolAttackContext(attacker, player, InteractionHand.MAIN_HAND, target, target instanceof LivingEntity ? (LivingEntity)target : null, isCritical, 1.0f, false);
                        for (Object entry : bladeTool.getModifiers()) {
                            baseDamage = ((MeleeDamageModifierHook)entry.getHook(ModifierHooks.MELEE_DAMAGE)).getMeleeDamage((IToolStackView)bladeTool, (ModifierEntry)entry, context, baseDamageTmp, baseDamage);
                        }
                        if (baseDamage <= 0.0f) {
                            ci.cancel();
                        }
                        float knockbackTmp = knockback;
                        for (ModifierEntry entry : bladeTool.getModifiers()) {
                            knockback = ((MeleeHitModifierHook)entry.getHook(ModifierHooks.MELEE_HIT)).beforeMeleeHit((IToolStackView)bladeTool, entry, context, baseDamage, knockbackTmp, knockback);
                        }
                        boolean damageSuccess = target.m_6469_(attacker.m_269291_().m_269075_(player), baseDamage);
                        if (damageSuccess) {
                            PlayerAttackHelperMixin.applyKnockback(attacker, target, knockback);
                            PlayerAttackHelperMixin.restoreTargetMotionIfNeeded(target, originalMotion);
                            PlayerAttackHelperMixin.playAttackEffects(attacker, target, isCritical);
                            PlayerAttackHelperMixin.handleEnchantmentsAndDurability(attacker, target);
                            PlayerAttackHelperMixin.handlePostAttackEffects(attacker, target, fireAspectResult);
                            for (ModifierEntry entry : bladeTool.getModifiers()) {
                                ((MeleeHitModifierHook)entry.getHook(ModifierHooks.MELEE_HIT)).afterMeleeHit((IToolStackView)bladeTool, entry, context, baseDamage);
                            }
                        } else {
                            PlayerAttackHelperMixin.handleFailedAttack(attacker, target, fireAspectResult);
                            for (ModifierEntry entry : bladeTool.getModifiers()) {
                                ((MeleeHitModifierHook)entry.getHook(ModifierHooks.MELEE_HIT)).failedMeleeHit((IToolStackView)bladeTool, entry, context, baseDamage);
                            }
                        }
                    }
                }
                ci.cancel();
            }
        }
    }
}

