/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.modifier;

import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.handlers.InternalTimers;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class ModifierAbyssal
extends NoLevelsModifier
implements InventoryTickModifierHook {
    public static final ResourceLocation ABYSSAL_DATA = new ResourceLocation("ticex", "abyssal");

    public static void toggleNightVision(IToolStackView tool, Player player) {
        boolean value;
        ModDataNBT helmetTag = tool.getPersistentData();
        if (helmetTag.contains(ABYSSAL_DATA, 1)) {
            value = !helmetTag.getBoolean(ABYSSAL_DATA);
            helmetTag.putBoolean(ABYSSAL_DATA, value);
        } else {
            helmetTag.putBoolean(ABYSSAL_DATA, true);
            value = true;
        }
        if (value) {
            player.m_213846_((Component)PELang.NIGHT_VISION.translate(new Object[]{ChatFormatting.GREEN, PELang.GEM_ENABLED}));
        } else {
            player.m_213846_((Component)PELang.NIGHT_VISION.translate(new Object[]{ChatFormatting.RED, PELang.GEM_DISABLED}));
        }
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.INVENTORY_TICK);
    }

    public List<Component> getDescriptionList(IToolStackView tool, ModifierEntry entry) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        tooltips.add((Component)PELang.GEM_LORE_HELM.translate(new Object[0]));
        tooltips.add((Component)PELang.NIGHT_VISION_PROMPT.translate(new Object[]{ClientKeyHelper.getKeyName((PEKeybind)PEKeybind.HELMET_TOGGLE)}));
        if (tool.getPersistentData().getBoolean(ABYSSAL_DATA)) {
            tooltips.add((Component)PELang.NIGHT_VISION.translate(new Object[]{ChatFormatting.GREEN, PELang.GEM_ENABLED}));
        } else {
            tooltips.add((Component)PELang.NIGHT_VISION.translate(new Object[]{ChatFormatting.RED, PELang.GEM_DISABLED}));
        }
        return tooltips;
    }

    public void onInventoryTick(IToolStackView tool, ModifierEntry entry, Level level, LivingEntity entity, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        ArmorItem armorItem;
        Item item = tool.getItem();
        if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_266204_() == ArmorItem.Type.HELMET && entity instanceof Player && itemSlot == 3 && !level.f_46443_) {
            entity.getCapability(InternalTimers.CAPABILITY).ifPresent(handler -> {
                handler.activateHeal();
                if (entity.m_21223_() < entity.m_21233_() && handler.canHeal()) {
                    entity.m_5634_(2.0f);
                }
            });
            if (tool.getPersistentData().getBoolean(ABYSSAL_DATA)) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 220, 0, true, false));
            } else {
                entity.m_21195_(MobEffects.f_19611_);
            }
        }
    }

    public static void doZap(Player player) {
        BlockHitResult strikeResult;
        if (ProjectEConfig.server.difficulty.offensiveAbilities.get() && (strikeResult = PlayerHelper.getBlockLookingAt((Player)player, (double)120.0)).m_6662_() != HitResult.Type.MISS) {
            BlockPos strikePos = strikeResult.m_82425_();
            Level level = player.m_9236_();
            LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(level);
            if (lightning != null) {
                lightning.m_20219_(Vec3.m_82512_((Vec3i)strikePos));
                lightning.m_20879_((ServerPlayer)player);
                level.m_7967_((Entity)lightning);
            }
        }
    }

    public boolean shouldDisplay(boolean advanced) {
        return advanced;
    }
}

