/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.modifier;

import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.socket.SocketHelper;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.DoubleStream;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.ProtectionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ModifierApothSupplier
extends NoLevelsModifier
implements MeleeHitModifierHook,
MeleeDamageModifierHook,
ProtectionModifierHook,
BlockBreakModifierHook,
AttributesModifierHook,
ProjectileLaunchModifierHook,
ToolDamageModifierHook {
    private boolean preventStackOverflowFlg = false;

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.MELEE_DAMAGE, ModifierHooks.MELEE_HIT, ModifierHooks.PROTECTION, ModifierHooks.BLOCK_BREAK, ModifierHooks.ATTRIBUTES, ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.TOOL_DAMAGE});
    }

    public boolean shouldDisplay(boolean advanced) {
        return false;
    }

    public float getMeleeDamage(IToolStackView iToolStackView, ModifierEntry modifierEntry, ToolAttackContext toolAttackContext, float baseDamage, float damage) {
        float newDamage = damage;
        if (iToolStackView instanceof ToolStack) {
            ToolStack tool = (ToolStack)iToolStackView;
            Entity entity = toolAttackContext.getTarget();
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                ItemStack stack = tool.createStack();
                newDamage += SocketHelper.getGems((ItemStack)stack).getDamageBonus(mob.m_6336_());
            }
        }
        return newDamage;
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        LivingEntity user = context.getAttacker();
        Entity target = context.getTarget();
        for (ItemStack s : user.m_20158_()) {
            SocketHelper.getGems((ItemStack)s).doPostAttack(user, target);
            Map affixes = AffixHelper.getAffixes((ItemStack)s);
            for (AffixInstance inst : affixes.values()) {
                int old = target.f_19802_;
                target.f_19802_ = 0;
                inst.doPostAttack(user, target);
                target.f_19802_ = old;
            }
        }
    }

    public float getProtectionModifier(IToolStackView iToolStackView, ModifierEntry modifierEntry, EquipmentContext equipmentContext, EquipmentSlot equipmentSlot, DamageSource damageSource, float protection) {
        float newProtection = protection;
        if (iToolStackView instanceof ToolStack) {
            ToolStack tool = (ToolStack)iToolStackView;
            ItemStack toolStack = tool.createStack();
            newProtection += (float)SocketHelper.getGems((ItemStack)toolStack).getDamageProtection(damageSource);
            Map affixes = AffixHelper.getAffixes((ItemStack)toolStack);
            for (AffixInstance inst : affixes.values()) {
                newProtection += (float)inst.getDamageProtection(damageSource);
            }
        }
        return newProtection;
    }

    public void addAttributes(IToolStackView iToolStackView, ModifierEntry modifierEntry, EquipmentSlot equipmentSlot, BiConsumer<Attribute, AttributeModifier> biConsumer) {
        if (iToolStackView instanceof ToolStack) {
            ToolStack tool = (ToolStack)iToolStackView;
            if (!this.preventStackOverflowFlg) {
                this.preventStackOverflowFlg = true;
                ItemStack toolStack = tool.createStack();
                SocketHelper.getGems((ItemStack)toolStack).addModifiers(LootCategory.forItem((ItemStack)toolStack), equipmentSlot, biConsumer);
                Map affixes = AffixHelper.getAffixes((ItemStack)toolStack);
                for (AffixInstance inst : affixes.values()) {
                    inst.addModifiers(equipmentSlot, biConsumer);
                }
                this.preventStackOverflowFlg = false;
            }
        }
    }

    public void afterBlockBreak(IToolStackView iToolStackView, ModifierEntry modifierEntry, ToolHarvestContext toolHarvestContext) {
        if (iToolStackView instanceof ToolStack) {
            ToolStack tool = (ToolStack)iToolStackView;
            ItemStack toolStack = tool.createStack();
            SocketHelper.getGems((ItemStack)toolStack).onBlockBreak((Player)toolHarvestContext.getPlayer(), (LevelAccessor)toolHarvestContext.getWorld(), toolHarvestContext.getPos(), toolHarvestContext.getState());
            Map affixes = AffixHelper.getAffixes((ItemStack)toolStack);
            for (AffixInstance inst : affixes.values()) {
                inst.onBlockBreak((Player)toolHarvestContext.getPlayer(), (LevelAccessor)toolHarvestContext.getWorld(), toolHarvestContext.getPos(), toolHarvestContext.getState());
            }
        }
    }

    public void onProjectileLaunch(IToolStackView iToolStackView, ModifierEntry modifierEntry, LivingEntity livingEntity, Projectile projectile, @Nullable AbstractArrow abstractArrow, ModDataNBT modDataNBT, boolean b) {
        if (iToolStackView instanceof ToolStack) {
            ToolStack tool = (ToolStack)iToolStackView;
            if (projectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)projectile;
                ItemStack toolStack = tool.createStack();
                SocketHelper.getGems((ItemStack)toolStack).onArrowFired(livingEntity, arrow);
                Map affixes = AffixHelper.getAffixes((ItemStack)toolStack);
                for (AffixInstance inst : affixes.values()) {
                    inst.onArrowFired(livingEntity, arrow);
                }
            }
        }
    }

    public int onDamageTool(IToolStackView iToolStackView, ModifierEntry modifierEntry, int amount, @Nullable LivingEntity livingEntity) {
        if (iToolStackView instanceof ToolStack) {
            ToolStack tool = (ToolStack)iToolStackView;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer pUser = (ServerPlayer)livingEntity;
                int blocked = 0;
                ItemStack toolStack = tool.createStack();
                DoubleStream socketBonuses = SocketHelper.getGems((ItemStack)toolStack).getDurabilityBonusPercentage(pUser);
                DoubleStream afxBonuses = AffixHelper.streamAffixes((ItemStack)toolStack).mapToDouble(inst -> inst.getDurabilityBonusPercentage(pUser));
                DoubleStream bonuses = DoubleStream.concat(socketBonuses, afxBonuses);
                double chance = bonuses.reduce(0.0, (res, ele) -> res + (1.0 - res) * ele);
                int delta = 1;
                if (chance < 0.0) {
                    delta = -1;
                    chance = -chance;
                }
                if (chance > 0.0) {
                    for (int i = 0; i < amount; ++i) {
                        if (!((double)pUser.m_217043_().m_188501_() <= chance)) continue;
                        blocked += delta;
                    }
                }
                return amount - blocked;
            }
        }
        return amount;
    }
}

