/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.modifier;

import java.util.Iterator;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockHarvestModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.RemoveBlockModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.aoe.AreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.BlockSideHitListener;
import slimeknights.tconstruct.library.utils.Util;

public class ModifierBedrockBreaker
extends NoLevelsModifier {
    public ModifierBedrockBreaker() {
        MinecraftForge.EVENT_BUS.addListener(this::onLeftClickBlock);
    }

    private void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        BlockState state = event.getEntity().m_9236_().m_8055_(event.getPos());
        if (!event.getEntity().m_7500_()) {
            Direction sideHit;
            ToolHarvestContext context;
            ItemStack toolStack;
            ToolStack tool = ModifierBedrockBreaker.getHeldTool((LivingEntity)event.getEntity(), (InteractionHand)InteractionHand.MAIN_HAND);
            if (tool == null || tool.isBroken() || tool.getModifierLevel((Modifier)this) < 1 || state.m_60800_((BlockGetter)event.getEntity().m_9236_(), event.getPos()) > 0.0f) {
                return;
            }
            Player player = event.getEntity();
            Level world = player.m_9236_();
            BlockPos pos = event.getPos();
            state.m_60734_().m_5707_(world, pos, state, player);
            if (world instanceof ServerLevel && ModifierBedrockBreaker.breakBlock(tool, toolStack = player.m_6844_(EquipmentSlot.MAINHAND), context = new ToolHarvestContext((ServerLevel)world, (LivingEntity)player, state, pos, sideHit = BlockSideHitListener.getSideHit((Player)player), true, true))) {
                Iterable extraBlocks = ((AreaOfEffectIterator)tool.getDefinition().getData().getHook(ToolHooks.AOE_ITERATOR)).getBlocks((IToolStackView)tool, new UseOnContext(player, InteractionHand.MAIN_HAND, Util.createTraceResult((BlockPos)pos, (Direction)sideHit, (boolean)false)), state, AreaOfEffectIterator.AOEMatchType.BREAKING);
                for (BlockPos extraPos : extraBlocks) {
                    BlockState extraState = world.m_8055_(extraPos);
                    if (extraState.m_60795_()) continue;
                    ToolHarvestLogic.breakExtraBlock((ToolStack)tool, (ItemStack)toolStack, (ToolHarvestContext)context.forPosition(extraPos.m_7949_(), extraState));
                }
                for (ModifierEntry entry : tool.getModifierList()) {
                    ((BlockBreakModifierHook)entry.getModifier().getHook(ModifierHooks.BLOCK_BREAK)).afterBlockBreak((IToolStackView)tool, entry, context);
                }
                if (state.m_60734_().m_60589_() == BuiltInLootTables.f_78712_) {
                    Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)state.m_60734_()));
                }
            }
        }
    }

    private static boolean removeBlock(IToolStackView tool, ToolHarvestContext context) {
        Boolean removed = null;
        if (!tool.isBroken() && !context.isAOE()) {
            ModifierEntry entry;
            Iterator iterator = tool.getModifierList().iterator();
            while (iterator.hasNext() && (removed = ((RemoveBlockModifierHook)(entry = (ModifierEntry)iterator.next()).getModifier().getHook(ModifierHooks.REMOVE_BLOCK)).removeBlock(tool, entry, context)) == null) {
            }
        }
        BlockState state = context.getState();
        ServerLevel world = context.getWorld();
        BlockPos pos = context.getPos();
        if (removed == null) {
            removed = state.onDestroyedByPlayer((Level)world, pos, (Player)context.getPlayer(), context.canHarvest(), world.m_6425_(pos));
        }
        if (removed.booleanValue()) {
            state.m_60734_().m_6786_((LevelAccessor)world, pos, state);
        }
        return removed;
    }

    protected static boolean breakBlock(ToolStack tool, ItemStack stack, ToolHarvestContext context) {
        ServerPlayer player = Objects.requireNonNull(context.getPlayer());
        ServerLevel world = context.getWorld();
        BlockPos pos = context.getPos();
        GameType type = player.f_8941_.m_9290_();
        int exp = ForgeHooks.onBlockBreakEvent((Level)world, (GameType)type, (ServerPlayer)player, (BlockPos)pos);
        if (exp == -1) {
            return false;
        }
        if (player.m_7500_()) {
            ModifierBedrockBreaker.removeBlock((IToolStackView)tool, context);
            return true;
        }
        BlockState state = context.getState();
        int damage = ToolHarvestLogic.getDamage((ToolStack)tool, (Level)world, (BlockPos)pos, (BlockState)state);
        BlockEntity te = world.m_7702_(pos);
        boolean removed = ModifierBedrockBreaker.removeBlock((IToolStackView)tool, context);
        Block block = state.m_60734_();
        if (removed) {
            block.m_6240_((Level)world, (Player)player, pos, state, te, stack);
        }
        if (removed && exp > 0) {
            block.m_49805_(world, pos, exp);
        }
        if (!tool.isBroken()) {
            for (ModifierEntry entry : tool.getModifierList()) {
                ((BlockHarvestModifierHook)entry.getModifier().getHook(ModifierHooks.BLOCK_HARVEST)).finishHarvest((IToolStackView)tool, entry, context, damage);
            }
            ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)damage, (LivingEntity)player);
        }
        return true;
    }
}

