/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.modifier;

import java.util.List;
import java.util.Map;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.ProtectionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.EnchantmentModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ModifierEnchantmentSupplier
extends NoLevelsModifier
implements MeleeHitModifierHook,
EnchantmentModifierHook,
ToolDamageModifierHook,
MeleeDamageModifierHook,
ProtectionModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.MELEE_HIT, ModifierHooks.ENCHANTMENTS, ModifierHooks.TOOL_DAMAGE, ModifierHooks.MELEE_DAMAGE, ModifierHooks.PROTECTION});
    }

    public boolean shouldDisplay(boolean advanced) {
        return false;
    }

    public float beforeMeleeHit(IToolStackView iToolStackView, ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        return knockback + (float)EnchantmentHelper.m_44894_((LivingEntity)context.getAttacker()) * 0.5f;
    }

    public void afterMeleeHit(IToolStackView iToolStackView, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        int fireAspect = EnchantmentHelper.m_44914_((LivingEntity)context.getAttacker());
        context.getTarget().m_7311_(80 * fireAspect);
        EnchantmentHelper.m_44896_((LivingEntity)context.getAttacker(), (Entity)context.getTarget());
        Entity entity = context.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)entity;
            EnchantmentHelper.m_44823_((LivingEntity)livingTarget, (Entity)context.getAttacker());
        }
    }

    public int updateEnchantmentLevel(IToolStackView iToolStackView, ModifierEntry modifierEntry, Enchantment enchantment, int i) {
        int level = i;
        if (iToolStackView instanceof ToolStack) {
            ToolStack tool = (ToolStack)iToolStackView;
            ItemStack toolStack = tool.createStack();
            level += EnchantmentHelper.getTagEnchantmentLevel((Enchantment)enchantment, (ItemStack)toolStack);
        }
        return level;
    }

    public void updateEnchantments(IToolStackView iToolStackView, ModifierEntry modifierEntry, Map<Enchantment, Integer> map) {
        if (iToolStackView instanceof ToolStack) {
            ToolStack tool = (ToolStack)iToolStackView;
            ItemStack toolStack = tool.createStack();
            map.putAll(EnchantmentHelper.m_44831_((ItemStack)toolStack));
        }
    }

    public int onDamageTool(IToolStackView iToolStackView, ModifierEntry modifierEntry, int damage, @Nullable LivingEntity livingEntity) {
        if (iToolStackView instanceof ToolStack) {
            ToolStack tool = (ToolStack)iToolStackView;
            ItemStack toolStack = tool.createStack();
            int lvl = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44986_, (ItemStack)toolStack);
            int actual = 0;
            if (livingEntity != null) {
                RandomSource rand = livingEntity.m_217043_();
                for (int i = 0; i < damage; ++i) {
                    if (rand.m_188503_(lvl + 1) != 0) continue;
                    ++actual;
                }
            }
            return actual;
        }
        return damage;
    }

    public float getProtectionModifier(IToolStackView iToolStackView, ModifierEntry modifierEntry, EquipmentContext equipmentContext, EquipmentSlot equipmentSlot, DamageSource damageSource, float v) {
        if (iToolStackView instanceof ToolStack) {
            ToolStack tool = (ToolStack)iToolStackView;
            ItemStack toolStack = tool.createStack();
            return v + (float)EnchantmentHelper.m_44856_(List.of(toolStack), (DamageSource)damageSource);
        }
        return v;
    }

    public float getMeleeDamage(IToolStackView iToolStackView, ModifierEntry modifierEntry, ToolAttackContext toolAttackContext, float v, float v1) {
        if (iToolStackView instanceof ToolStack) {
            ToolStack tool = (ToolStack)iToolStackView;
            Entity entity = toolAttackContext.getTarget();
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                ItemStack toolStack = tool.createStack();
                return v1 + EnchantmentHelper.m_44833_((ItemStack)toolStack, (MobType)mob.m_6336_());
            }
        }
        return v1;
    }
}

