/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.modifier;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.inventory.InventoryDynamic;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.modules.ModuleHelper;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.AOEData;
import com.brandon3055.draconicevolution.api.modules.data.DamageData;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.client.keybinding.KeyBindings;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import moffy.ticex.lib.utils.TicEXDEUtils;
import moffy.ticex.lib.utils.TicEXUtils;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.ModList;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ValidateModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.RequirementsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.data.ModifierIds;

public class ModifierEvolved
extends Modifier
implements ToolDamageModifierHook,
TooltipModifierHook,
MeleeHitModifierHook,
BlockBreakModifierHook,
RequirementsModifierHook,
ValidateModifierHook {
    public static final ResourceLocation MODULE_HOST_LOCATION = new ResourceLocation("ticex", "module_host");
    public static final ResourceLocation OP_STORAGE_LOCATION = new ResourceLocation("ticex", "op_storage");

    public int getPriority() {
        return 0;
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.TOOL_DAMAGE, ModifierHooks.TOOLTIP, ModifierHooks.MELEE_HIT, ModifierHooks.BLOCK_BREAK, ModifierHooks.REQUIREMENTS, ModifierHooks.VALIDATE});
    }

    public int onDamageTool(IToolStackView arg0, ModifierEntry arg1, int arg2, LivingEntity arg3) {
        return 0;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry entry, Player player, List<Component> components, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        ItemStack toolStack;
        if (player != null && !(toolStack = TicEXUtils.getToolStack(tool, (LivingEntity)player, TicEXRegistry.EVOLVED_MODIFIER.get())).m_41619_()) {
            components.add((Component)Component.m_237115_((String)"[Modular Item]").m_130940_(ChatFormatting.BLUE));
            toolStack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).ifPresent(host -> {
                host.getModuleEntities().forEach(e -> e.addHostHoverText(toolStack, player.m_9236_(), components, tooltipFlag));
                host.getInstalledTypes().map(arg_0 -> ((ModuleHost)host).getModuleData(arg_0)).filter(Objects::nonNull).forEach(data -> data.addHostHoverText(toolStack, player.m_9236_(), components, tooltipFlag));
            });
            EnergyUtils.addEnergyInfo((ItemStack)toolStack, components);
            if (EnergyUtils.isEnergyItem((ItemStack)toolStack) && EnergyUtils.getMaxEnergyStored((ItemStack)toolStack) == 0L) {
                components.add((Component)Component.m_237115_((String)"modular_item.draconicevolution.requires_energy").m_130940_(ChatFormatting.RED));
                if (KeyBindings.toolModules != null && KeyBindings.toolModules.m_90863_() != null) {
                    components.add((Component)Component.m_237110_((String)"modular_item.draconicevolution.requires_energy_press", (Object[])new Object[]{KeyBindings.toolModules.m_90863_().getString()}).m_130940_(ChatFormatting.BLUE));
                }
            }
        }
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        Player player = context.getPlayerAttacker();
        if (player != null) {
            Entity target = context.getTarget();
            ItemStack stack = TicEXUtils.getToolStack(tool, (LivingEntity)player, TicEXRegistry.EVOLVED_MODIFIER.get());
            if (stack != null && !stack.m_41619_()) {
                ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
                IOPStorage opStorage = (IOPStorage)stack.getCapability(DECapabilities.OP_STORAGE).orElseThrow(IllegalStateException::new);
                int attackDamage = this.getDamageBonus(host, opStorage);
                int extracted = opStorage.extractEnergy(tool.getStats().getInt((IToolStat)ToolStats.ATTACK_DAMAGE) + attackDamage, false);
                this.hurt(player, target, stack, Math.min(extracted, attackDamage));
                double aoe = this.getAttackAoe(host);
                if (!context.isExtraAttack() && aoe > 0.0 && target instanceof LivingEntity) {
                    this.dealAOEDamage(tool, context, player, (LivingEntity)target, stack, (float)Math.min(extracted, attackDamage) * 0.8f, aoe);
                }
            }
        }
    }

    private int getDamageBonus(ModuleHost host, IOPStorage opStorage) {
        double damage = ((DamageData)host.getModuleData(ModuleTypes.DAMAGE, (ModuleData)new DamageData(0.0))).damagePoints();
        if ((double)opStorage.getEnergyStored() < (double)EquipCfg.energyAttack * damage) {
            damage = 0.0;
        }
        return (int)Math.round(damage + ((double)TicEXDEUtils.getTier(host.getHostTechLevel()).m_6631_() * EquipCfg.staffDamageMultiplier - 1.0));
    }

    private double getAttackAoe(ModuleHost host) {
        double aoe = (double)((AOEData)host.getModuleData(ModuleTypes.AOE, (ModuleData)new AOEData(0))).aoe() * 1.5;
        if (host instanceof PropertyProvider && ((PropertyProvider)host).hasDecimal("attack_aoe")) {
            aoe = ((PropertyProvider)host).getDecimal("attack_aoe").getValue();
        }
        return aoe;
    }

    private void dealAOEDamage(IToolStackView tool, ToolAttackContext context, Player player, LivingEntity target, ItemStack stack, float damage, double aoe) {
        IOPStorage opStorage = (IOPStorage)stack.getCapability(DECapabilities.OP_STORAGE).orElseThrow(IllegalStateException::new);
        List entities = player.m_9236_().m_6443_(LivingEntity.class, target.m_20191_().m_82377_(aoe, 0.25, aoe), LivingEntity::m_6084_);
        double aoeAngle = 100.0;
        double yaw = player.m_146908_() - 180.0f;
        int fireAspect = EnchantmentHelper.m_44914_((LivingEntity)player);
        for (LivingEntity entity : entities) {
            double angle;
            double relativeAngle;
            float distance = player.m_20270_((Entity)entity);
            if (entity == player || entity == target || player.m_7307_((Entity)entity) || distance < 1.0f || (double)entity.m_20270_((Entity)target) > aoe || !((relativeAngle = Math.abs(((angle = Math.atan2(player.m_20185_() - entity.m_20185_(), player.m_20189_() - entity.m_20189_()) * 57.29577951308232) + yaw) % 360.0)) <= aoeAngle / 2.0) && !(relativeAngle > 360.0 - aoeAngle / 2.0)) continue;
            boolean lit = false;
            float health = entity.m_21223_();
            if (fireAspect > 0 && !entity.m_6060_()) {
                lit = true;
                entity.m_20254_(1);
            }
            int extracted = opStorage.extractEnergy((int)((float)EquipCfg.energyAttack * damage), false);
            ToolAttackUtil.extraEntityAttack((IToolStackView)tool, (LivingEntity)player, (InteractionHand)context.getHand(), (Entity)entity);
            if (this.hurt(player, (Entity)entity, stack, Math.min(extracted, (int)damage))) {
                int k;
                float damageDealt = health - entity.m_21223_();
                entity.m_147240_((double)0.4f, MathHelper.sin((double)((double)player.m_146908_() * 0.017453292519943)), -MathHelper.cos((double)((double)player.m_146908_() * 0.017453292519943)));
                if (fireAspect > 0) {
                    entity.m_20254_(fireAspect * 4);
                }
                if (player.m_9236_() instanceof ServerLevel && damageDealt > 2.0f) {
                    k = (int)((double)damage * 0.5);
                    ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123798_, entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_(), k, 0.1, 0.0, 0.1, 0.2);
                }
                player.m_36222_(Stats.f_12928_, Math.round(damageDealt * 10.0f));
                if (!(player.m_9236_() instanceof ServerLevel) || !(damageDealt > 2.0f)) continue;
                k = (int)((double)damageDealt * 0.5);
                ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123798_, entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_(), k, 0.1, 0.0, 0.1, 0.2);
                continue;
            }
            if (!lit) continue;
            entity.m_20095_();
        }
    }

    private boolean hurt(Player player, Entity target, ItemStack stack, int damage) {
        IOPStorage opStorage = (IOPStorage)stack.getCapability(DECapabilities.OP_STORAGE).orElseThrow(IllegalStateException::new);
        int dealDamage = Math.min(EquipCfg.energyAttack * damage, opStorage.getEnergyStored()) / EquipCfg.energyAttack;
        boolean result = target.m_6469_(new DamageSource((Holder)target.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(TicEXDEUtils.getDamageTag((IToolStackView)ToolStack.from((ItemStack)stack)))), (float)dealDamage);
        if (!result) {
            int k;
            if (player.m_9236_() instanceof ServerLevel && (float)dealDamage > 2.0f) {
                k = (int)((double)damage * 0.5);
                ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123798_, target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), k, 0.1, 0.0, 0.1, 0.2);
            }
            player.m_36222_(Stats.f_12928_, Math.round((float)dealDamage * 10.0f));
            if (player.m_9236_() instanceof ServerLevel && (float)dealDamage > 2.0f) {
                k = (int)((double)dealDamage * 0.5);
                ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123798_, target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), k, 0.1, 0.0, 0.1, 0.2);
            }
            opStorage.receiveEnergy(EquipCfg.energyAttack * dealDamage, false);
        }
        return result;
    }

    public void afterBlockBreak(IToolStackView tool, ModifierEntry modifierEntry, ToolHarvestContext context) {
        ItemStack stack;
        ServerPlayer player = context.getPlayer();
        if (player != null && !context.isAOE() && !(stack = TicEXUtils.getToolStack(tool, (LivingEntity)player, TicEXRegistry.EVOLVED_MODIFIER.get())).m_41619_()) {
            ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
            IOPStorage storage = (IOPStorage)stack.getCapability(DECapabilities.OP_STORAGE).orElseThrow(IllegalStateException::new);
            int aoe = ((AOEData)host.getModuleData(ModuleTypes.AOE, (ModuleData)new AOEData(0))).aoe();
            boolean aoeSafe = true;
            if (host instanceof PropertyProvider) {
                PropertyProvider propertyProvider = (PropertyProvider)host;
                if (propertyProvider.hasInt("mining_aoe")) {
                    aoe = propertyProvider.getInt("mining_aoe").getValue();
                }
                if (propertyProvider.hasBool("aoe_safe")) {
                    aoeSafe = propertyProvider.getBool("aoe_safe").getValue();
                }
            }
            this.breakAOEBlocks(tool, host, storage, stack, context.getPos(), context.getSideHit(), aoe + tool.getModifierLevel(TinkerModifiers.expanded.get()), 0, (Player)player, aoeSafe, context);
        }
    }

    private boolean breakAOEBlocks(IToolStackView tool, ModuleHost host, IOPStorage storage, ItemStack stack, BlockPos pos, Direction sideHit, int breakRadius, int breakDepth, Player player, boolean aoeSafe, ToolHarvestContext context) {
        BlockState blockState = player.m_9236_().m_8055_(pos);
        InventoryDynamic inventoryDynamic = new InventoryDynamic();
        float refStrength = ModifierEvolved.blockStrength(blockState, player, player.m_9236_(), pos);
        Pair<BlockPos, BlockPos> aoe = this.getMiningArea(pos, sideHit, player, breakRadius, breakDepth);
        List<BlockPos> aoeBlocks = BlockPos.m_121990_((BlockPos)((BlockPos)aoe.getFirst()), (BlockPos)((BlockPos)aoe.getSecond())).map(BlockPos::new).toList();
        if (aoeSafe) {
            for (BlockPos block2 : aoeBlocks) {
                if (player.m_9236_().m_46859_(block2) || player.m_9236_().m_7702_(block2) == null) continue;
                if (player.m_9236_().f_46443_) {
                    player.m_213846_((Component)Component.m_237115_((String)"item_prop.draconicevolution.aoe_safe.blocked"));
                } else {
                    ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)((ServerPlayer)player).m_9236_(), block2));
                }
                return true;
            }
        }
        aoeBlocks.forEach(block -> this.breakAOEBlock(tool, stack, player.m_9236_(), (BlockPos)block, player, refStrength, inventoryDynamic, player.m_9236_().m_213780_().m_188503_(Math.max(5, breakRadius * breakDepth / 5)) == 0, context, storage));
        List items = player.m_9236_().m_45976_(ItemEntity.class, new AABB((BlockPos)aoe.getFirst(), ((BlockPos)aoe.getSecond()).m_7918_(1, 1, 1)));
        for (ItemEntity item : items) {
            if (player.m_9236_().f_46443_ || !item.m_6084_()) continue;
            InventoryUtils.insertItem((Container)inventoryDynamic, (ItemStack)item.m_32055_(), (boolean)false);
            item.m_146870_();
        }
        ModuleHelper.handleItemCollection((Player)player, (ModuleHost)host, (IOPStorage)storage, (InventoryDynamic)inventoryDynamic);
        return true;
    }

    public Component getDisplayName(int level) {
        return Component.m_237115_((String)(this.getTranslationKey() + "." + level));
    }

    private Pair<BlockPos, BlockPos> getMiningArea(BlockPos pos, Direction direction, Player player, int breakRadius, int breakDepth) {
        int sideHit = direction.m_122411_();
        int xMax = breakRadius;
        int xMin = breakRadius;
        int yMax = breakRadius;
        int yMin = breakRadius;
        int zMax = breakRadius;
        int zMin = breakRadius;
        int yOffset = 0;
        switch (sideHit) {
            case 0: {
                yMax = breakDepth;
                yMin = 0;
                zMax = breakRadius;
                break;
            }
            case 1: {
                yMin = breakDepth;
                yMax = 0;
                zMax = breakRadius;
                break;
            }
            case 2: {
                xMax = breakRadius;
                zMin = 0;
                zMax = breakDepth;
                yOffset = breakRadius - 1;
                break;
            }
            case 3: {
                xMax = breakRadius;
                zMax = 0;
                zMin = breakDepth;
                yOffset = breakRadius - 1;
                break;
            }
            case 4: {
                xMax = breakDepth;
                xMin = 0;
                zMax = breakRadius;
                yOffset = breakRadius - 1;
                break;
            }
            case 5: {
                xMin = breakDepth;
                xMax = 0;
                zMax = breakRadius;
                yOffset = breakRadius - 1;
            }
        }
        if (breakRadius == 0) {
            yOffset = 0;
        }
        return new Pair((Object)pos.m_7918_(-xMin, yOffset - yMin, -zMin), (Object)pos.m_7918_(xMax, yOffset + yMax, zMax));
    }

    static float blockStrength(BlockState state, Player player, Level world, BlockPos pos) {
        float hardness = state.m_60800_((BlockGetter)world, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player)) {
            return player.getDigSpeed(state, pos) / hardness / 100.0f;
        }
        return player.getDigSpeed(state, pos) / hardness / 30.0f;
    }

    private void breakAOEBlock(IToolStackView tool, ItemStack stack, Level world, BlockPos pos, Player player, float refStrength, InventoryDynamic inventory, boolean breakFX, ToolHarvestContext context, IOPStorage storage) {
        if (world.m_46859_(pos)) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        if (!this.isCorrectToolForDrops(tool, stack, state)) {
            return;
        }
        if (storage.getEnergyStored() < EquipCfg.energyHarvest) {
            return;
        }
        ToolHarvestContext newContext = context.forPosition(pos, state);
        if (ModList.get().isLoaded("avaritia") && tool.getModifierLevel(TicEXRegistry.BEDROCK_BREAKER_MODIFIER.get()) > 0) {
            state.m_60734_().m_6240_(player.m_9236_(), player, pos, state, player.m_9236_().m_7702_(pos), player.m_21205_());
        }
        ToolHarvestLogic.breakExtraBlock((ToolStack)ToolStack.from((ItemStack)stack), (ItemStack)stack, (ToolHarvestContext)newContext);
        storage.extractEnergy(EquipCfg.energyHarvest, false);
    }

    private boolean isCorrectToolForDrops(IToolStackView tool, ItemStack stack, BlockState state) {
        if (ModList.get().isLoaded("avaritia") && tool.getModifierLevel(TicEXRegistry.BEDROCK_BREAKER_MODIFIER.get()) > 0) {
            return true;
        }
        return stack.m_41735_(state);
    }

    public List<ModifierEntry> displayModifiers(ModifierEntry entry) {
        ArrayList<ModifierEntry> entries = new ArrayList<ModifierEntry>();
        if (entry.getLevel() == 1) {
            entries.add(new ModifierEntry(ModifierIds.reinforced, 5));
            entries.add(new ModifierEntry(ModifierIds.netherite, 1));
        }
        return entries;
    }

    public Component validate(IToolStackView tool, ModifierEntry entry) {
        if (entry.getLevel() == 1 && (tool.getModifierLevel(ModifierIds.reinforced) < 5 || tool.getModifierLevel(ModifierIds.netherite) < 1)) {
            return Component.m_237115_((String)"recipe.ticex.modifier.evolved_requirements_1");
        }
        return null;
    }
}

