/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.modifier;

import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.DistExecutor;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class ModifierHurricane
extends NoLevelsModifier
implements InventoryTickModifierHook,
TooltipModifierHook,
AttributesModifierHook {
    private static final UUID MOVEMENT_SPEED_MODIFIER_UUID = UUID.fromString("A4334312-DFF8-4582-9F4F-62AD0C070475");
    private static final UUID STEP_ASSIST_MODIFIER_UUID = UUID.fromString("4726C09D-FD86-46D0-92DD-49ED952A12D2");
    private static final AttributeModifier STEP_ASSIST = new AttributeModifier(STEP_ASSIST_MODIFIER_UUID, "Step Assist", 0.4, AttributeModifier.Operation.ADDITION);
    public static final ResourceLocation HURRICANE_DATA = new ResourceLocation("ticex", "hurricane");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.INVENTORY_TICK, ModifierHooks.TOOLTIP, ModifierHooks.ATTRIBUTES);
    }

    public static void toggleStepAssist(IToolStackView boots, Player player) {
        boolean value;
        ModDataNBT bootsTag = boots.getPersistentData();
        if (bootsTag.contains(HURRICANE_DATA, 1)) {
            value = !bootsTag.getBoolean(HURRICANE_DATA);
            bootsTag.putBoolean(HURRICANE_DATA, value);
        } else {
            bootsTag.putBoolean(HURRICANE_DATA, true);
            value = true;
        }
        if (value) {
            player.m_213846_((Component)PELang.STEP_ASSIST.translate(new Object[]{ChatFormatting.GREEN, PELang.GEM_ENABLED}));
        } else {
            player.m_213846_((Component)PELang.STEP_ASSIST.translate(new Object[]{ChatFormatting.RED, PELang.GEM_DISABLED}));
        }
    }

    private static boolean isJumpPressed() {
        return (Boolean)DistExecutor.unsafeRunForDist(() -> () -> Minecraft.m_91087_().f_91066_.f_92089_.m_90857_(), () -> () -> false);
    }

    public void onInventoryTick(IToolStackView tool, ModifierEntry entry, Level level, LivingEntity entity, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        ArmorItem armorItem;
        Item item = tool.getItem();
        if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_266204_() == ArmorItem.Type.BOOTS && entity instanceof Player) {
            Player player = (Player)entity;
            if (itemSlot == 0) {
                AttributeInstance attributeInstance;
                if (!level.f_46443_) {
                    ServerPlayer playerMP = (ServerPlayer)player;
                    playerMP.f_19789_ = 0.0f;
                } else {
                    if (!player.m_150110_().f_35935_ && ModifierHurricane.isJumpPressed()) {
                        player.m_20256_(player.m_20184_().m_82520_(0.0, 0.1, 0.0));
                    }
                    if (!player.m_20096_()) {
                        if (player.m_20184_().m_7098_() <= 0.0) {
                            player.m_20256_(player.m_20184_().m_82542_(1.0, 0.9, 1.0));
                        }
                        if (!player.m_150110_().f_35935_) {
                            if (player.f_20902_ < 0.0f) {
                                player.m_20256_(player.m_20184_().m_82542_(0.9, 1.0, 0.9));
                            } else if (player.f_20902_ > 0.0f && player.m_20184_().m_82556_() < 3.0) {
                                player.m_20256_(player.m_20184_().m_82542_(1.1, 1.0, 1.1));
                            }
                        }
                    }
                }
                ModDataNBT persistentData = tool.getPersistentData();
                boolean stepAssistEnabled = false;
                if (persistentData.contains(HURRICANE_DATA, 1)) {
                    stepAssistEnabled = persistentData.getBoolean(HURRICANE_DATA);
                }
                if ((attributeInstance = player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get())) != null) {
                    AttributeModifier existing = attributeInstance.m_22111_(STEP_ASSIST_MODIFIER_UUID);
                    if (stepAssistEnabled) {
                        if (existing == null) {
                            attributeInstance.m_22118_(STEP_ASSIST);
                        }
                    } else if (existing != null) {
                        attributeInstance.m_22130_(existing);
                    }
                }
            }
        }
    }

    public void addTooltip(IToolStackView tool, ModifierEntry entry, Player player, List<Component> tooltips, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        tooltips.add((Component)PELang.GEM_LORE_FEET.translate(new Object[0]));
    }

    public void addAttributes(IToolStackView tool, ModifierEntry entry, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> modifierGetter) {
        if (tool.getPersistentData().getBoolean(HURRICANE_DATA) && slot == EquipmentSlot.FEET) {
            modifierGetter.accept(Attributes.f_22279_, new AttributeModifier(MOVEMENT_SPEED_MODIFIER_UUID, "Armor modifier", 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    public boolean shouldDisplay(boolean advanced) {
        return advanced;
    }
}

