/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.modifier;

import committee.nova.mods.avaritia.init.registry.ModDamageTypes;
import committee.nova.mods.avaritia.util.ToolUtils;
import java.util.Map;
import java.util.function.BiFunction;
import moffy.ticex.lib.hook.ProvidePropertyModifierHook;
import moffy.ticex.modifier.propeties.OmnipotenceProperty;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;

public class ModifierOmnipotence
extends NoLevelsModifier
implements ProjectileHitModifierHook,
MeleeHitModifierHook,
BreakSpeedModifierHook,
ProvidePropertyModifierHook {
    public int getPriority() {
        return 999;
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.PROJECTILE_HIT, ModifierHooks.MELEE_HIT, ModifierHooks.BREAK_SPEED, TicEXRegistry.PROPERTY_PROVIDER_HOOK});
    }

    public float beforeMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        LivingEntity victim = context.getLivingTarget();
        if (victim != null) {
            if (victim instanceof EnderDragon) {
                victim.m_20331_(false);
            } else if (victim instanceof Player) {
                Player pvp = (Player)victim;
                if (ToolUtils.isInfinite((LivingEntity)pvp)) {
                    pvp.m_9236_().m_254849_((Entity)context.getPlayerAttacker(), (double)pvp.m_146903_(), (double)pvp.m_146904_(), (double)pvp.m_146907_(), 25.0f, Level.ExplosionInteraction.MOB);
                    return 0.0f;
                }
                victim.m_20331_(false);
            } else {
                victim.m_20331_(false);
            }
        }
        return super.beforeMeleeHit(tool, modifier, context, damage, baseKnockback, knockback);
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        LivingEntity attackerEntity = context.getAttacker();
        Entity victim = context.getTarget();
        if (context.getLevel() instanceof ServerLevel) {
            this.dealInfinityDamage(context.getLevel(), attackerEntity, victim);
        }
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, LivingEntity attacker, LivingEntity target) {
        boolean result = super.onProjectileHitEntity(modifiers, persistentData, modifier, projectile, hit, attacker, target);
        if (attacker.m_9236_() instanceof ServerLevel) {
            this.dealInfinityDamage(attacker.m_9236_(), attacker, (Entity)target);
        }
        return result;
    }

    public void onBreakSpeed(IToolStackView tool, ModifierEntry entry, PlayerEvent.BreakSpeed event, Direction direction, boolean isEffective, float miningSpeedModifier) {
        event.setNewSpeed(Float.MAX_VALUE);
    }

    private void dealInfinityDamage(Level level, LivingEntity attackerEntity, Entity targetEntity) {
        if (targetEntity != null && targetEntity.m_6084_()) {
            Entity parentEntity;
            LivingEntity victim = null;
            if (targetEntity instanceof LivingEntity) {
                victim = (LivingEntity)targetEntity;
            } else if (targetEntity instanceof PartEntity && (parentEntity = ((PartEntity)targetEntity).getParent()) instanceof LivingEntity) {
                victim = (LivingEntity)parentEntity;
            }
            if (level instanceof ServerLevel) {
                if (victim != null) {
                    serverLevel = (ServerLevel)level;
                    try {
                        ToolUtils.class.getDeclaredMethod("sweepAttack", Level.class, LivingEntity.class, Entity.class);
                        ToolUtils.sweepAttack((Level)level, (LivingEntity)attackerEntity, (Entity)victim);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    victim.m_21153_(0.0f);
                    victim.m_6667_(new DamageSource((Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(ModDamageTypes.INFINITY), (Entity)victim, (Entity)attackerEntity));
                    int reward = victim.m_213860_();
                    if (reward > 0) {
                        victim.m_9236_().m_7967_((Entity)new ExperienceOrb(victim.m_9236_(), victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), reward));
                    }
                    serverLevel.m_7605_((Entity)victim, (byte)3);
                } else {
                    serverLevel = (ServerLevel)level;
                    targetEntity.m_214076_(serverLevel, attackerEntity);
                    targetEntity.m_6074_();
                    serverLevel.m_7605_(targetEntity, (byte)3);
                }
            }
            if (victim != null) {
                victim.m_20124_(Pose.DYING);
            }
        }
    }

    @Override
    public BiFunction<Player, ItemStack, Map<String, Object>> getPropertyProvider() {
        return OmnipotenceProperty.getProperties();
    }
}

