/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.modifier;

import java.util.Map;
import java.util.function.BiFunction;
import moffy.ticex.lib.hook.ProvidePropertyModifierHook;
import moffy.ticex.lib.utils.TicEXPsiUtils;
import moffy.ticex.lib.utils.TicEXUtils;
import moffy.ticex.modifier.propeties.PsionizingRadiationProperty;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ValidateModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.utils.BlockSideHitListener;

public class ModifierPsionizingRadiation
extends NoLevelsModifier
implements MeleeHitModifierHook,
BlockBreakModifierHook,
ProvidePropertyModifierHook,
ValidateModifierHook {
    public static ResourceLocation AUTO_CASTING_LOC = new ResourceLocation("ticex", "autocasting");
    public static ResourceLocation SOCKETS_LOC = new ResourceLocation("ticex", "cad_sockets");
    public static final ResourceLocation TIMES_CAST_LOC = new ResourceLocation("ticex", "timescast");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.MELEE_HIT, ModifierHooks.BLOCK_BREAK, ModifierHooks.VALIDATE, TicEXRegistry.PROPERTY_PROVIDER_HOOK});
    }

    public Component validate(IToolStackView tool, ModifierEntry entry) {
        if (entry.getModifier() == this) {
            this.initPersistentData(tool);
        }
        return null;
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        this.initPersistentData(tool);
        if (!tool.isBroken() && context.getPlayerAttacker() != null && !tool.getPersistentData().getBoolean(AUTO_CASTING_LOC)) {
            return;
        }
        Player player = context.getPlayerAttacker();
        ItemStack toolStack = TicEXUtils.getToolStack(tool, (LivingEntity)player, (Modifier)this);
        TicEXPsiUtils.CastSpell(player, toolStack, spellContext -> {
            spellContext.attackedEntity = context.getLivingTarget();
        });
    }

    public void afterBlockBreak(IToolStackView tool, ModifierEntry entry, ToolHarvestContext context) {
        if (!tool.isBroken() && context.getPlayer() != null && !tool.getPersistentData().getBoolean(AUTO_CASTING_LOC)) {
            return;
        }
        ServerPlayer player = context.getPlayer();
        ItemStack toolStack = TicEXUtils.getToolStack(tool, (LivingEntity)player, (Modifier)this);
        Direction sideHit = BlockSideHitListener.getSideHit((Player)context.getPlayer());
        Vec3 hit = new Vec3((double)context.getPos().m_123341_() + 0.5 - (double)sideHit.m_122429_() * 0.5, (double)context.getPos().m_123342_() + 0.5 - (double)sideHit.m_122430_() * 0.5, (double)context.getPos().m_123343_() + 0.5 - (double)sideHit.m_122431_() * 0.5);
        TicEXPsiUtils.CastSpell((Player)player, toolStack, spellContext -> {
            spellContext.positionBroken = new BlockHitResult(hit, sideHit, context.getPos(), false);
        });
    }

    @Override
    public BiFunction<Player, ItemStack, Map<String, Object>> getPropertyProvider() {
        return PsionizingRadiationProperty.getProperties();
    }

    protected void initPersistentData(IToolStackView tool) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (!persistentData.contains(AUTO_CASTING_LOC, 1)) {
            persistentData.putBoolean(AUTO_CASTING_LOC, true);
        }
        if (!persistentData.contains(SOCKETS_LOC, 3)) {
            persistentData.putInt(SOCKETS_LOC, 1);
        }
        if (!persistentData.contains(TIMES_CAST_LOC, 3)) {
            persistentData.putInt(TIMES_CAST_LOC, 0);
        }
    }
}

