/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.modifier;

import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.MobSoul;
import moffy.ticex.modules.general.TicEXRegistry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.LootingModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.LootingContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class ModifierSoulRending
extends Modifier
implements LootingModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.WEAPON_LOOTING);
    }

    public int updateLooting(@NotNull IToolStackView tool, @NotNull ModifierEntry modifierEntry, LootingContext context, int looting) {
        if (!ModifierSoulRending.canEntityDropSoul(context.getLivingTarget())) {
            return looting;
        }
        if (context.getLivingTarget() instanceof Player) {
            return looting;
        }
        int dropChanceModifier = tool.getModifierLevel(TicEXRegistry.SOUL_RENDING_MODIFIER.get());
        if (dropChanceModifier == 0) {
            return looting;
        }
        int rand = RANDOM.nextInt(Math.max(DEConfig.soulDropChance / dropChanceModifier, 1));
        int rand2 = RANDOM.nextInt(Math.max(DEConfig.passiveSoulDropChance / dropChanceModifier, 1));
        Entity entity = context.getTarget();
        boolean isAnimal = entity instanceof Animal;
        if (rand == 0 && !isAnimal || rand2 == 0 && isAnimal) {
            ItemStack soul = ((MobSoul)DEContent.MOB_SOUL.get()).getSoulFromEntity(entity, false);
            context.getHolder().m_9236_().m_7967_((Entity)new ItemEntity(context.getHolder().m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), soul));
        }
        return looting;
    }

    private static boolean canEntityDropSoul(LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        if (!entity.m_6072_() && !DEConfig.allowBossSouls) {
            return false;
        }
        String regName = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString();
        if (DEConfig.spawnerList.contains(regName) && DEConfig.spawnerListWhiteList) {
            return true;
        }
        if (DEConfig.spawnerList.contains(regName) && !DEConfig.spawnerListWhiteList) {
            return false;
        }
        return !DEConfig.spawnerListWhiteList;
    }
}

