/*
 * Decompiled with CFR 0.152.
 */
package moffy.ticex.network.mekanism;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.MekanismAPI;
import mekanism.api.gear.ModuleData;
import mekanism.api.gear.config.ModuleBooleanData;
import mekanism.api.gear.config.ModuleColorData;
import mekanism.api.gear.config.ModuleConfigData;
import mekanism.api.gear.config.ModuleEnumData;
import mekanism.api.gear.config.ModuleIntegerData;
import mekanism.api.math.MathUtils;
import mekanism.common.Mekanism;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.ModuleConfigItem;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.network.to_server.PacketUpdateModuleSettings;
import moffy.ticex.network.TicEXPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ConfigSyncToClientPacket
extends TicEXPacket.ClientBoundPacket {
    private final ModuleData<?> moduleType;
    private final EquipmentSlot slot;
    private final int configIndex;
    private final ModuleDataType dataType;
    private final Object value;

    public static ConfigSyncToClientPacket create(ModuleData<?> moduleType, EquipmentSlot slot, int configIndex, ModuleConfigData<?> configData, Object newValue) {
        if (configData instanceof ModuleEnumData) {
            return new ConfigSyncToClientPacket(moduleType, slot, configIndex, ModuleDataType.ENUM, newValue);
        }
        for (ModuleDataType type : ModuleDataType.VALUES) {
            if (!type.typeMatches(configData)) continue;
            return new ConfigSyncToClientPacket(moduleType, slot, configIndex, type, newValue);
        }
        throw new IllegalArgumentException("Unknown config data type.");
    }

    protected ConfigSyncToClientPacket(ModuleData<?> moduleType, EquipmentSlot slot, int configIndex, ModuleDataType dataType, Object value) {
        this.moduleType = moduleType;
        this.slot = slot;
        this.configIndex = configIndex;
        this.dataType = dataType;
        this.value = value;
    }

    public ConfigSyncToClientPacket(FriendlyByteBuf buf) {
        this.slot = (EquipmentSlot)buf.m_130066_(EquipmentSlot.class);
        this.moduleType = (ModuleData)buf.readRegistryIdSafe(ModuleData.class);
        this.configIndex = buf.readInt();
        this.dataType = (ModuleDataType)buf.m_130066_(ModuleDataType.class);
        this.value = switch (this.dataType) {
            default -> throw new IncompatibleClassChangeError();
            case ModuleDataType.BOOLEAN -> buf.readBoolean();
            case ModuleDataType.COLOR -> Integer.valueOf(buf.readInt());
            case ModuleDataType.INTEGER, ModuleDataType.ENUM -> Integer.valueOf(buf.m_130242_());
        };
    }

    public EquipmentSlot getSlot() {
        return this.slot;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.slot);
        buf.writeRegistryId(MekanismAPI.moduleRegistry(), this.moduleType);
        buf.writeInt(this.configIndex);
        buf.m_130068_((Enum)this.dataType);
        switch (this.dataType) {
            case BOOLEAN: {
                buf.writeBoolean(((Boolean)this.value).booleanValue());
                break;
            }
            case COLOR: {
                buf.writeInt(((Integer)this.value).intValue());
                break;
            }
            case INTEGER: 
            case ENUM: {
                buf.m_130130_(((Integer)this.value).intValue());
            }
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            List configItems;
            Module module;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            ItemStack stack = player.m_6844_(this.slot);
            if (!stack.m_41619_() && stack.m_41720_() instanceof IModuleContainerItem && (module = ModuleHelper.get().load(stack, this.moduleType)) != null && this.configIndex < (configItems = module.getConfigItems()).size()) {
                ModuleConfigItem configItem = (ModuleConfigItem)configItems.get(this.configIndex);
                ConfigSyncToClientPacket.setValue(configItem, this.dataType, this.value);
                if (stack.m_41720_() instanceof ArmorItem) {
                    Mekanism.packetHandler().sendToServer((Object)PacketUpdateModuleSettings.create((int)(36 + (3 - this.slot.m_20749_())), (ModuleData)module.getData(), (int)this.configIndex, (ModuleConfigData)configItem.getData()));
                } else {
                    Optional<ItemStack> optionalStack = player.m_150109_().f_35974_.stream().filter(item -> ItemStack.m_41656_((ItemStack)stack, (ItemStack)item)).findFirst();
                    if (optionalStack.isPresent()) {
                        Mekanism.packetHandler().sendToServer((Object)PacketUpdateModuleSettings.create((int)player.m_150109_().m_36030_(optionalStack.get()), (ModuleData)module.getData(), (int)this.configIndex, (ModuleConfigData)configItem.getData()));
                    }
                }
            }
        });
        context.setPacketHandled(true);
    }

    private static <T> void setValue(ModuleConfigItem<T> moduleConfigItem, ModuleDataType dataType, Object value) {
        ModuleConfigData configData = moduleConfigItem.getData();
        if (configData instanceof ModuleEnumData && dataType == ModuleDataType.ENUM) {
            moduleConfigItem.set(MathUtils.getByIndexMod((List)((ModuleEnumData)configData).getEnums(), (int)((Integer)value)));
        } else if (dataType.typeMatches(configData)) {
            moduleConfigItem.set(value);
        }
    }

    public static enum ModuleDataType {
        BOOLEAN(data -> data instanceof ModuleBooleanData),
        COLOR(data -> data instanceof ModuleColorData),
        INTEGER(data -> data instanceof ModuleIntegerData),
        ENUM(data -> data instanceof ModuleEnumData);

        private static final ModuleDataType[] VALUES;
        private final Predicate<ModuleConfigData<?>> configDataPredicate;

        private ModuleDataType(Predicate<ModuleConfigData<?>> configDataPredicate) {
            this.configDataPredicate = configDataPredicate;
        }

        public boolean typeMatches(ModuleConfigData<?> data) {
            return this.configDataPredicate.test(data);
        }

        static {
            VALUES = ModuleDataType.values();
        }
    }
}

