/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.mechanical_botany.compat.jei;

import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.dakotapride.mechanical_botany.CreateMechanicalBotany;
import net.dakotapride.mechanical_botany.ModBlocks;
import net.dakotapride.mechanical_botany.ModItems;
import net.dakotapride.mechanical_botany.ModRecipeTypes;
import net.dakotapride.mechanical_botany.compat.jei.AnimatedMechanicalComposter;
import net.dakotapride.mechanical_botany.compat.jei.CreateMechanicalBotanyJEI;
import net.dakotapride.mechanical_botany.kinetics.composter.CompostingRecipe;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
public class CompostingCategory
extends CreateRecipeCategory<CompostingRecipe> {
    private final AnimatedMechanicalComposter mechanicalComposter = new AnimatedMechanicalComposter();
    public static final RecipeType<RecipeHolder<CompostingRecipe>> TYPE = RecipeType.createRecipeHolderType((ResourceLocation)CreateMechanicalBotany.asResource("composting"));

    public CompostingCategory(CreateRecipeCategory.Info<CompostingRecipe> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CompostingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 5, 9).setBackground(CompostingCategory.getRenderedSlot(), -1, -1).addIngredients((Ingredient)recipe.getIngredients().get(0));
        List results = recipe.getRollableResults();
        boolean single = results.size() == 1;
        int i = 0;
        for (ProcessingOutput output : results) {
            int xOffset = i % 2 == 0 ? 0 : 19;
            int yOffset = i / 2 * -19;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, single ? 139 : 133 + xOffset, 37 + yOffset).setBackground(CompostingCategory.getRenderedSlot((ProcessingOutput)output), -1, -1).addItemStack(output.getStack())).addRichTooltipCallback(CompostingCategory.addStochasticTooltip((ProcessingOutput)output));
            ++i;
        }
    }

    public static CompostingCategory create(IGuiHelper guiHelper) {
        MutableComponent title = Component.translatable((String)"recipe.mechanical_botany.composting");
        EmptyBackground background = new EmptyBackground(178, 72);
        DoubleItemIcon icon = new DoubleItemIcon(() -> new ItemStack((ItemLike)ModBlocks.MECHANICAL_COMPOSTER.get()), () -> ModItems.COMPOST.asStack());
        Supplier<ItemStack> catalystStackSupplier = () -> ModBlocks.MECHANICAL_COMPOSTER.asStack();
        CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(TYPE, (Component)title, (IDrawable)background, (IDrawable)icon, CompostingCategory::getAllRecipes, List.of(catalystStackSupplier));
        return new CompostingCategory((CreateRecipeCategory.Info<CompostingRecipe>)info);
    }

    private static List<RecipeHolder<CompostingRecipe>> getAllRecipes() {
        return CreateMechanicalBotanyJEI.getRecipeManager().getAllRecipesFor(ModRecipeTypes.COMPOSTING.getType());
    }

    public void draw(CompostingRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_ARROW.render(graphics, 85, 41);
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 45, 20);
        this.mechanicalComposter.draw(graphics, 38, 27);
    }
}

