/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.mechanical_botany.compat.jei;

import com.google.common.base.Preconditions;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.dakotapride.mechanical_botany.compat.jei.CompostingCategory;
import net.dakotapride.mechanical_botany.compat.jei.InsolatingCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;

@ParametersAreNonnullByDefault
@JeiPlugin
public class CreateMechanicalBotanyJEI
implements IModPlugin {
    public static final ResourceLocation MOD_ID = ResourceLocation.fromNamespaceAndPath((String)"mechanical_botany", (String)"jei_plugin");
    private final List<IRecipeCategory<?>> categories = new ArrayList();

    @Nonnull
    public ResourceLocation getPluginUid() {
        return MOD_ID;
    }

    private void loadCategories(IRecipeCategoryRegistration registration) {
        this.categories.clear();
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        ArrayList<CreateRecipeCategory> localCategories = new ArrayList<CreateRecipeCategory>();
        localCategories.add(InsolatingCategory.create(guiHelper));
        localCategories.add(CompostingCategory.create(guiHelper));
        registration.addRecipeCategories(localCategories.toArray(new IRecipeCategory[0]));
        this.categories.clear();
        this.categories.addAll(localCategories);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        for (IRecipeCategory<?> category : this.categories) {
            if (!(category instanceof CreateRecipeCategory)) continue;
            ((CreateRecipeCategory)category).registerRecipes(registration);
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.loadCategories(registration);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        for (IRecipeCategory<?> category : this.categories) {
            if (!(category instanceof CreateRecipeCategory)) continue;
            ((CreateRecipeCategory)category).registerCatalysts(registration);
        }
    }

    public static RecipeManager getRecipeManager() {
        if (FMLLoader.getDist() != Dist.CLIENT) {
            throw new IllegalStateException();
        }
        Minecraft minecraft = Minecraft.getInstance();
        Preconditions.checkNotNull((Object)minecraft);
        ClientLevel level = minecraft.level;
        Preconditions.checkNotNull((Object)level);
        return level.getRecipeManager();
    }
}

