/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.mechanical_botany.compat.jei;

import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.createmod.catnip.lang.LangBuilder;
import net.dakotapride.mechanical_botany.CreateMechanicalBotany;
import net.dakotapride.mechanical_botany.ModBlocks;
import net.dakotapride.mechanical_botany.ModRecipeTypes;
import net.dakotapride.mechanical_botany.compat.jei.AnimatedMechanicalInsolator;
import net.dakotapride.mechanical_botany.compat.jei.CreateMechanicalBotanyJEI;
import net.dakotapride.mechanical_botany.compat.jei.util.CreateMechanicalBotanyRecipeCategory;
import net.dakotapride.mechanical_botany.kinetics.insolator.InsolatingRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
public class InsolatingCategory
extends CreateMechanicalBotanyRecipeCategory<InsolatingRecipe> {
    private final AnimatedMechanicalInsolator mechanicalInsolator = new AnimatedMechanicalInsolator();
    public static final RecipeType<RecipeHolder<InsolatingRecipe>> TYPE = RecipeType.createRecipeHolderType((ResourceLocation)CreateMechanicalBotany.asResource("insolating"));

    public InsolatingCategory(CreateRecipeCategory.Info<InsolatingRecipe> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, InsolatingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 5, 9).setBackground(InsolatingCategory.getRenderedSlot(), -1, -1).addIngredients((Ingredient)recipe.getIngredients().get(0));
        InsolatingCategory.addFluidSlot(builder, 25, 9, recipe.getRequiredFluid());
        List results = recipe.getRollableResults();
        boolean single = results.size() == 1;
        int i = 0;
        for (ProcessingOutput output : results) {
            int xOffset = i % 2 == 0 ? 0 : 19;
            int yOffset = i / 2 * -19;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, single ? 139 : 133 + xOffset, 37 + yOffset).setBackground(InsolatingCategory.getRenderedSlot((ProcessingOutput)output), -1, -1).addItemStack(output.getStack())).addRichTooltipCallback(InsolatingCategory.addStochasticTooltip((ProcessingOutput)output));
            ++i;
        }
    }

    public static InsolatingCategory create(IGuiHelper guiHelper) {
        MutableComponent title = Component.translatable((String)"recipe.mechanical_botany.insolating");
        EmptyBackground background = new EmptyBackground(178, 72);
        ItemIcon icon = new ItemIcon(() -> new ItemStack((ItemLike)ModBlocks.MECHANICAL_INSOLATOR.get()));
        Supplier<ItemStack> catalystStackSupplier = () -> ModBlocks.MECHANICAL_INSOLATOR.asStack();
        CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(TYPE, (Component)title, (IDrawable)background, (IDrawable)icon, InsolatingCategory::getAllRecipes, List.of(catalystStackSupplier));
        return new InsolatingCategory((CreateRecipeCategory.Info<InsolatingRecipe>)info);
    }

    private static List<RecipeHolder<InsolatingRecipe>> getAllRecipes() {
        return CreateMechanicalBotanyJEI.getRecipeManager().getAllRecipesFor(ModRecipeTypes.INSOLATING.getType());
    }

    public void draw(InsolatingRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_ARROW.render(graphics, 85, 41);
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 45, 20);
        this.mechanicalInsolator.draw(graphics, 38, 27);
        graphics.drawString(Minecraft.getInstance().font, (Component)InsolatingCategory.translateDirect("text.processing_ticks", recipe.getProcessingDuration() / 20), 2, 60, 0xFFFFFF);
    }

    public static MutableComponent translateDirect(String key, Object ... args) {
        Object[] args1 = LangBuilder.resolveBuilders((Object[])args);
        return Component.translatable((String)("mechanical_botany." + key), (Object[])args1);
    }
}

