/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.mechanical_botany.kinetics.insolator;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.sound.SoundScapes;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.lang.LangBuilder;
import net.dakotapride.mechanical_botany.CreateMechanicalBotany;
import net.dakotapride.mechanical_botany.ModBlockEntityTypes;
import net.dakotapride.mechanical_botany.ModConfigs;
import net.dakotapride.mechanical_botany.ModRecipeTypes;
import net.dakotapride.mechanical_botany.kinetics.insolator.InsolatingRecipe;
import net.dakotapride.mechanical_botany.kinetics.insolator.MechanicalInsolatorBlock;
import net.dakotapride.mechanical_botany.kinetics.insolator.MechanicalInsolatorInventory;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;

public class MechanicalInsolatorBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    public MechanicalInsolatorInventory inputInv = new MechanicalInsolatorInventory(1, this);
    public MechanicalInsolatorInventory outputInv = new MechanicalInsolatorInventory(9, this);
    public IItemHandlerModifiable itemCapability = new MechanicalInsolatorInvWrapper(this.inputInv, this.outputInv);
    public int timer;
    private InsolatingRecipe lastRecipe;
    public SmartFluidTankBehaviour tank;
    protected IFluidHandler fluidCapability;

    public MechanicalInsolatorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        CreateLang.translate((String)"gui.goggles.fluid_container", (Object[])new Object[0]).forGoggles(tooltip);
        if (!this.getCurrentFluidInTank().isEmpty()) {
            CreateLang.fluidName((FluidStack)this.getCurrentFluidInTank()).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            CreateLang.builder().add(CreateLang.number((double)this.getCurrentFluidInTank().getAmount()).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)this.tank.getCapability().getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        } else {
            CreateLang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(CreateLang.number((double)this.tank.getCapability().getTankCapacity(0)).add(mb).style(ChatFormatting.GOLD)).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        }
        CreateLang.translate((String)"gui.goggles.item_container", (Object[])new Object[0]).forGoggles(tooltip);
        for (int i = 0; i < this.itemCapability.getSlots(); ++i) {
            ItemStack stackInSlot = this.itemCapability.getStackInSlot(i);
            if (stackInSlot.isEmpty()) continue;
            CreateLang.text((String)"").add(Component.translatable((String)stackInSlot.getDescriptionId()).withStyle(ChatFormatting.GRAY)).add(CreateLang.text((String)(" x" + stackInSlot.getCount())).style(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
        }
        if (this.inputInv.getStackInSlot(0).isEmpty()) {
            CreateMechanicalBotany.translate("text.cannot_process.empty", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            if (!((Boolean)ModConfigs.server().insolator.canProcessSaplings.get()).booleanValue()) {
                CreateMechanicalBotany.translate("text.config.disabled_saplings", new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip, 1);
            }
        }
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.INSOLATOR.get(), (be, context) -> {
            if (context == null || MechanicalInsolatorBlock.hasPipeTowards(context)) {
                return be.fluidCapability;
            }
            return null;
        });
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.INSOLATOR.get(), (be, context) -> be.itemCapability);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
        this.tank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 1, ((Integer)ModConfigs.server().insolator.tankSize.get()).intValue(), true).allowExtraction().allowInsertion();
        behaviours.add((BlockEntityBehaviour)this.tank);
        this.fluidCapability = new CombinedTankWrapper(new IFluidHandler[]{this.tank.getCapability()});
    }

    public FluidStack getCurrentFluidInTank() {
        return this.tank.getPrimaryHandler().getFluid();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.inputInv.getStackInSlot(0).isEmpty() || this.tank.isEmpty()) {
            return;
        }
        float pitch = Mth.clamp((float)(Math.abs(this.getSpeed()) / 256.0f + 0.45f), (float)0.85f, (float)1.0f);
        SoundScapes.play((SoundScapes.AmbienceGroup)SoundScapes.AmbienceGroup.COG, (BlockPos)this.worldPosition, (float)pitch);
    }

    public void tick() {
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        for (int i = 0; i < this.outputInv.getSlots(); ++i) {
            if (this.outputInv.getStackInSlot(i).getCount() != this.outputInv.getSlotLimit(i)) continue;
            return;
        }
        if (this.timer > 0) {
            this.timer -= this.getProcessingSpeed();
            if (this.timer <= 0) {
                this.process();
            }
            return;
        }
        if (this.inputInv.getStackInSlot(0).isEmpty() || this.tank.isEmpty()) {
            return;
        }
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandler)this.inputInv);
        if (this.lastRecipe == null || !this.lastRecipe.matches((RecipeInput)inventoryIn, this.level)) {
            Optional<RecipeHolder<InsolatingRecipe>> recipe = ModRecipeTypes.find(inventoryIn, this.level, ModRecipeTypes.INSOLATING);
            if (!recipe.isPresent()) {
                this.timer = 100;
                this.sendData();
            } else {
                this.lastRecipe = (InsolatingRecipe)recipe.get().value();
                this.timer = this.lastRecipe.getProcessingDuration();
                this.sendData();
            }
            return;
        }
        this.timer = this.lastRecipe.getProcessingDuration();
        this.sendData();
    }

    public void invalidate() {
        super.invalidate();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.inputInv);
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.outputInv);
    }

    private void process() {
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandler)this.inputInv);
        if (this.lastRecipe == null || !this.lastRecipe.matches((RecipeInput)inventoryIn, this.level) || !this.lastRecipe.getRequiredFluid().test(this.getCurrentFluidInTank())) {
            Optional<RecipeHolder<InsolatingRecipe>> recipe = ModRecipeTypes.find(inventoryIn, this.level, ModRecipeTypes.INSOLATING);
            if (!recipe.isPresent()) {
                return;
            }
            this.lastRecipe = (InsolatingRecipe)recipe.get().value();
        }
        ItemStack stackInSlot = this.inputInv.getStackInSlot(0);
        FluidStack fluidInSlot = this.getCurrentFluidInTank();
        if (((Ingredient)this.lastRecipe.getIngredients().get(0)).test(stackInSlot) && ((SizedFluidIngredient)this.lastRecipe.getFluidIngredients().get(0)).test(fluidInSlot) && this.lastRecipe.getRequiredFluid().amount() <= this.getCurrentFluidInTank().getAmount()) {
            stackInSlot.shrink(1);
            fluidInSlot.shrink(this.lastRecipe.getRequiredFluid().amount());
            this.inputInv.setStackInSlot(0, stackInSlot);
            this.lastRecipe.rollResults(this.level.random).forEach(stack -> ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInv, (ItemStack)stack, (boolean)false));
            this.sendData();
            this.setChanged();
        }
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putInt("Timer", this.timer);
        compound.put("InputInventory", (Tag)this.inputInv.serializeNBT(registries));
        compound.put("OutputInventory", (Tag)this.outputInv.serializeNBT(registries));
        super.write(compound, registries, clientPacket);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.timer = compound.getInt("Timer");
        this.inputInv.deserializeNBT(registries, compound.getCompound("InputInventory"));
        this.outputInv.deserializeNBT(registries, compound.getCompound("OutputInventory"));
        super.read(compound, registries, clientPacket);
    }

    public int getProcessingSpeed() {
        return Mth.clamp((int)((int)Math.abs(this.getSpeed() / 16.0f)), (int)1, (int)512);
    }

    private boolean canProcess(ItemStack stack) {
        ItemStackHandler tester = new ItemStackHandler(1);
        tester.setStackInSlot(0, stack);
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandler)tester);
        if (this.lastRecipe != null && this.lastRecipe.matches((RecipeInput)inventoryIn, this.level) && this.lastRecipe.getRequiredFluid().test(this.getCurrentFluidInTank()) && this.lastRecipe.getRequiredFluid().amount() <= this.getCurrentFluidInTank().getAmount()) {
            return true;
        }
        return ModRecipeTypes.find(inventoryIn, this.level, ModRecipeTypes.INSOLATING).isPresent();
    }

    private class MechanicalInsolatorInvWrapper
    extends CombinedInvWrapper {
        public MechanicalInsolatorInvWrapper(SmartInventory input, SmartInventory output) {
            super(new IItemHandlerModifiable[]{input, output});
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (MechanicalInsolatorBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return false;
            }
            if (stack.is(ItemTags.SAPLINGS)) {
                return (Boolean)ModConfigs.server().insolator.canProcessSaplings.get();
            }
            return MechanicalInsolatorBlockEntity.this.canProcess(stack) && super.isItemValid(slot, stack);
        }

        @NotNull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (MechanicalInsolatorBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (MechanicalInsolatorBlockEntity.this.inputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return ItemStack.EMPTY;
            }
            return super.extractItem(slot, amount, simulate);
        }
    }
}

