/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.justinnether.procedures;

import java.util.List;
import net.mcreator.justinnether.JustInNetherMod;
import net.mcreator.justinnether.entity.BullkindarEntity;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BullkindarOnEntityTickUpdateProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        BullkindarOnEntityTickUpdateProcedure.handleAttackTrigger(world, x, y, z, entity);
    }

    private static void handleAttackTrigger(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (!world.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)new Vec3(x, y, z), (double)8.0, (double)8.0, (double)8.0)).isEmpty()) {
            for (Entity nearby : world.getEntitiesOfClass(Entity.class, new AABB(new Vec3(x, y, z), new Vec3(x, y, z)).inflate(4.0))) {
                if (nearby == entity) continue;
                entity.getPersistentData().putDouble("attackmount", entity.getPersistentData().getDouble("attackmount") + 1.0);
            }
        } else {
            entity.getPersistentData().putDouble("attackmount", 0.0);
            entity.getPersistentData().putString("canattack", "TRUE");
        }
        if (entity.getPersistentData().getDouble("attackmount") >= 20.0 && !entity.getPersistentData().getString("canattack").equals("FALSE")) {
            entity.getPersistentData().putString("canattack", "FALSE");
            if (entity.getPersistentData().getDouble("attacktype") == 0.0) {
                entity.getPersistentData().putDouble("attacktype", (double)Mth.nextInt((RandomSource)RandomSource.create(), (int)1, (int)5));
            }
            switch ((int)entity.getPersistentData().getDouble("attacktype")) {
                case 1: {
                    BullkindarOnEntityTickUpdateProcedure.attackSpin(world, x, y, z, entity);
                    break;
                }
                case 2: {
                    BullkindarOnEntityTickUpdateProcedure.attackSlam(world, x, y, z, entity);
                    break;
                }
                case 3: {
                    BullkindarOnEntityTickUpdateProcedure.attackStomp(world, x, y, z, entity);
                    break;
                }
                case 4: {
                    BullkindarOnEntityTickUpdateProcedure.attackSprint(world, x, y, z, entity);
                    break;
                }
                case 5: {
                    BullkindarOnEntityTickUpdateProcedure.attackBackKick(world, x, y, z, entity);
                }
            }
        }
    }

    private static void resetAttackState(Entity entity, int delayTicks) {
        JustInNetherMod.queueServerWork(delayTicks, () -> {
            entity.getPersistentData().putString("canattack", "AGAIN");
            entity.getPersistentData().putDouble("attacktype", 0.0);
            entity.getPersistentData().putDouble("attackmount", 0.0);
        });
    }

    private static void applyAreaDamage(LevelAccessor world, Entity source, double x, double y, double z, double radius, float damage) {
        Vec3 center = new Vec3(x, y, z);
        List<Entity> targets = world.getEntitiesOfClass(Entity.class, new AABB(center, center).inflate(radius / 2.0)).stream().filter(e -> e != source && !(e instanceof ItemEntity)).toList();
        for (Entity target : targets) {
            target.hurt(new DamageSource((Holder)world.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.MOB_ATTACK), target, source), damage);
        }
    }

    private static void attackSpin(LevelAccessor world, double x, double y, double z, Entity entity) {
        BullkindarOnEntityTickUpdateProcedure.setAnimation(entity, "spin");
        JustInNetherMod.queueServerWork(15, () -> BullkindarOnEntityTickUpdateProcedure.runRepeatedDamage(world, entity, x, y, z, 7.0, 16.0f, 3, 15));
        BullkindarOnEntityTickUpdateProcedure.resetAttackState(entity, 40);
    }

    private static void attackSlam(LevelAccessor world, double x, double y, double z, Entity entity) {
        BullkindarOnEntityTickUpdateProcedure.setAnimation(entity, "attack2");
        JustInNetherMod.queueServerWork(8, () -> BullkindarOnEntityTickUpdateProcedure.runRepeatedDamage(world, entity, x, y, z, 6.0, 8.0f, 3, 6));
        BullkindarOnEntityTickUpdateProcedure.resetAttackState(entity, 40);
    }

    private static void attackStomp(LevelAccessor world, double x, double y, double z, Entity entity) {
        BullkindarOnEntityTickUpdateProcedure.setAnimation(entity, "attack1");
        JustInNetherMod.queueServerWork(20, () -> {
            if (entity.isAlive()) {
                BullkindarOnEntityTickUpdateProcedure.applyAreaDamage(world, entity, x, y, z, 7.0, 14.0f);
            }
        });
        BullkindarOnEntityTickUpdateProcedure.resetAttackState(entity, 40);
    }

    private static void attackSprint(LevelAccessor world, double x, double y, double z, Entity entity) {
        BullkindarOnEntityTickUpdateProcedure.setAnimation(entity, "attacksprint");
        if (entity.isAlive()) {
            entity.setDeltaMovement(entity.getDeltaMovement().multiply(5.0, 1.0, 5.0));
            Vec3 center = new Vec3(x, y, z);
            List<Entity> targets = world.getEntitiesOfClass(Entity.class, new AABB(center, center).inflate(4.0)).stream().filter(e -> e != entity && !(e instanceof ItemEntity)).toList();
            for (Entity target : targets) {
                target.hurt(new DamageSource((Holder)world.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.MOB_ATTACK), target, entity), 10.0f);
                Vec3 knockback = entity.getDeltaMovement().normalize().scale(1.5).add(0.0, 0.5, 0.0);
                target.setDeltaMovement(knockback);
                target.hurtMarked = true;
                Entity finalTarget = target;
                JustInNetherMod.queueServerWork(30, () -> {
                    if (finalTarget.isAlive()) {
                        Vec3 upward = finalTarget.getDeltaMovement().add(0.0, 1.2, 0.0);
                        finalTarget.setDeltaMovement(upward);
                        finalTarget.hurtMarked = true;
                    }
                });
            }
        }
        BullkindarOnEntityTickUpdateProcedure.resetAttackState(entity, 60);
    }

    private static void attackBackKick(LevelAccessor world, double x, double y, double z, Entity entity) {
        BullkindarOnEntityTickUpdateProcedure.setAnimation(entity, "attackbackkick");
        if (entity.isAlive()) {
            BullkindarOnEntityTickUpdateProcedure.applyAreaDamage(world, entity, x, y, z, 8.0, 8.0f);
            JustInNetherMod.queueServerWork(30, () -> {
                if (entity.isAlive()) {
                    BullkindarOnEntityTickUpdateProcedure.applyAreaDamage(world, entity, x, y, z, 7.0, 14.0f);
                }
            });
        }
        BullkindarOnEntityTickUpdateProcedure.resetAttackState(entity, 60);
    }

    private static void setAnimation(Entity entity, String animation) {
        if (entity instanceof BullkindarEntity) {
            BullkindarEntity bullkindar = (BullkindarEntity)entity;
            bullkindar.setAnimation("empty");
            bullkindar.setAnimation(animation);
        }
    }

    private static void runRepeatedDamage(final LevelAccessor world, final Entity entity, final double x, final double y, final double z, final double radius, final float damage, final int times, final int interval) {
        new Object(){

            void loop(int i) {
                if (entity.isAlive()) {
                    BullkindarOnEntityTickUpdateProcedure.applyAreaDamage(world, entity, x, y, z, radius, damage);
                }
                if (i + 1 < times) {
                    JustInNetherMod.queueServerWork(interval, () -> this.loop(i + 1));
                }
            }
        }.loop(0);
    }
}

