/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.justinnether.procedures;

import java.util.List;
import net.mcreator.justinnether.JustInNetherMod;
import net.mcreator.justinnether.entity.PigmarEntity;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PigmarOnEntityTickUpdateProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null || !(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        LivingEntity target = mob.getTarget();
        if (target == null || !target.isAlive() || entity.getPersistentData().getBoolean("isAttacking")) {
            return;
        }
        double distance = entity.distanceTo((Entity)target);
        if (distance > 8.0) {
            return;
        }
        entity.getPersistentData().putBoolean("isAttacking", true);
        int attackType = Mth.nextInt((RandomSource)RandomSource.create(), (int)1, (int)6);
        if (entity instanceof PigmarEntity) {
            PigmarEntity pigmar = (PigmarEntity)entity;
            pigmar.setAnimation("empty");
        }
        switch (attackType) {
            case 1: {
                PigmarOnEntityTickUpdateProcedure.performJumpAttack(world, x, y, z, entity, (Entity)target);
                break;
            }
            case 2: {
                PigmarOnEntityTickUpdateProcedure.performSwingAttack(world, x, y, z, entity, (Entity)target);
                break;
            }
            case 3: {
                PigmarOnEntityTickUpdateProcedure.performSwingLeftAttack(world, x, y, z, entity, (Entity)target);
                break;
            }
            case 4: {
                PigmarOnEntityTickUpdateProcedure.performSwingRightAttack(world, x, y, z, entity, (Entity)target);
                break;
            }
            case 5: {
                PigmarOnEntityTickUpdateProcedure.performFrontAttack(world, x, y, z, entity, (Entity)target);
                break;
            }
            case 6: {
                PigmarOnEntityTickUpdateProcedure.performSpinAttack(world, x, y, z, entity, (Entity)target);
            }
        }
    }

    private static void performJumpAttack(LevelAccessor world, double x, double y, double z, Entity entity, Entity target) {
        if (entity instanceof PigmarEntity) {
            PigmarEntity pigmar = (PigmarEntity)entity;
            pigmar.setAnimation("attackjump");
        }
        entity.setDeltaMovement(new Vec3(0.0, 1.2, 0.0));
        JustInNetherMod.queueServerWork(30, () -> {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                level.sendParticles((ParticleOptions)ParticleTypes.SPIT, x, y, z, 50, 3.0, 0.3, 3.0, 0.5);
            }
            PigmarOnEntityTickUpdateProcedure.attackNearby(world, x, y, z, entity, 5.0, 12.0f, 0.8);
        });
        PigmarOnEntityTickUpdateProcedure.resetAttackState(entity, 70);
    }

    private static void performSwingAttack(LevelAccessor world, double x, double y, double z, Entity entity, Entity target) {
        if (entity instanceof PigmarEntity) {
            PigmarEntity pigmar = (PigmarEntity)entity;
            pigmar.setAnimation("swing");
        }
        JustInNetherMod.queueServerWork(30, () -> PigmarOnEntityTickUpdateProcedure.attackNearby(world, x, y, z, entity, 6.0, 15.0f, 0.5));
        PigmarOnEntityTickUpdateProcedure.resetAttackState(entity, 60);
    }

    private static void performSwingLeftAttack(LevelAccessor world, double x, double y, double z, Entity entity, Entity target) {
        if (entity instanceof PigmarEntity) {
            PigmarEntity pigmar = (PigmarEntity)entity;
            pigmar.setAnimation("attackswingleft");
        }
        JustInNetherMod.queueServerWork(20, () -> PigmarOnEntityTickUpdateProcedure.attackNearby(world, x, y, z, entity, 4.0, 12.0f, 0.0));
        PigmarOnEntityTickUpdateProcedure.resetAttackState(entity, 40);
    }

    private static void performSwingRightAttack(LevelAccessor world, double x, double y, double z, Entity entity, Entity target) {
        if (entity instanceof PigmarEntity) {
            PigmarEntity pigmar = (PigmarEntity)entity;
            pigmar.setAnimation("attackswingright");
        }
        JustInNetherMod.queueServerWork(10, () -> PigmarOnEntityTickUpdateProcedure.attackNearby(world, x, y, z, entity, 4.0, 12.0f, 0.0));
        PigmarOnEntityTickUpdateProcedure.resetAttackState(entity, 40);
    }

    private static void performFrontAttack(final LevelAccessor world, final double x, final double y, final double z, final Entity entity, Entity target) {
        if (entity instanceof PigmarEntity) {
            PigmarEntity pigmar = (PigmarEntity)entity;
            pigmar.setAnimation("attackfront");
        }
        JustInNetherMod.queueServerWork(25, () -> new Object(){

            void timedLoop(int current, int total, int ticks) {
                Vec3 forward = entity.getLookAngle();
                Vec3 pos = new Vec3(x + forward.x * (double)current, y, z + forward.z * (double)current);
                PigmarOnEntityTickUpdateProcedure.attackNearby(world, pos.x, pos.y, pos.z, entity, 1.5, 12.0f, 0.0);
                if (current + 1 < total) {
                    JustInNetherMod.queueServerWork(ticks, () -> this.timedLoop(current + 1, total, ticks));
                }
            }
        }.timedLoop(0, 6, 1));
        PigmarOnEntityTickUpdateProcedure.resetAttackState(entity, 70);
    }

    private static void performSpinAttack(LevelAccessor world, double x, double y, double z, Entity entity, Entity target) {
        if (entity instanceof PigmarEntity) {
            PigmarEntity pigmar = (PigmarEntity)entity;
            pigmar.setAnimation("attackspin");
        }
        JustInNetherMod.queueServerWork(10, () -> PigmarOnEntityTickUpdateProcedure.attackNearby(world, x, y, z, entity, 3.5, 15.0f, 0.0));
        PigmarOnEntityTickUpdateProcedure.resetAttackState(entity, 40);
    }

    private static void attackNearby(LevelAccessor world, double x, double y, double z, Entity entity, double radius, float damage, double yBoost) {
        Vec3 center = new Vec3(x, y, z);
        List targets = world.getEntitiesOfClass(Entity.class, new AABB(center, center).inflate(radius), e -> e instanceof LivingEntity && e != entity && !(e instanceof ItemEntity));
        for (Entity target : targets) {
            target.hurt(new DamageSource((Holder)world.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.MOB_ATTACK), entity), damage);
            if (!(yBoost > 0.0)) continue;
            target.setDeltaMovement(new Vec3(0.0, yBoost, 0.0));
        }
    }

    private static void resetAttackState(Entity entity, int delayTicks) {
        JustInNetherMod.queueServerWork(delayTicks, () -> entity.getPersistentData().putBoolean("isAttacking", false));
    }
}

