/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.justinnether.procedures;

import java.util.List;
import net.mcreator.justinnether.JustInNetherMod;
import net.mcreator.justinnether.entity.BullkindarEntity;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BullkindarOnEntityTickUpdateProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        BullkindarOnEntityTickUpdateProcedure.handleAttackTrigger(world, x, y, z, entity);
    }

    private static void handleAttackTrigger(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (!world.m_45976_(LivingEntity.class, AABB.m_165882_((Vec3)new Vec3(x, y, z), (double)8.0, (double)8.0, (double)8.0)).isEmpty()) {
            for (Entity nearby : world.m_45976_(Entity.class, new AABB(new Vec3(x, y, z), new Vec3(x, y, z)).m_82400_(4.0))) {
                if (nearby == entity) continue;
                entity.getPersistentData().m_128347_("attackmount", entity.getPersistentData().m_128459_("attackmount") + 1.0);
            }
        } else {
            entity.getPersistentData().m_128347_("attackmount", 0.0);
            entity.getPersistentData().m_128359_("canattack", "TRUE");
        }
        if (entity.getPersistentData().m_128459_("attackmount") >= 20.0 && !entity.getPersistentData().m_128461_("canattack").equals("FALSE")) {
            entity.getPersistentData().m_128359_("canattack", "FALSE");
            if (entity.getPersistentData().m_128459_("attacktype") == 0.0) {
                entity.getPersistentData().m_128347_("attacktype", (double)Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)1, (int)5));
            }
            switch ((int)entity.getPersistentData().m_128459_("attacktype")) {
                case 1: {
                    BullkindarOnEntityTickUpdateProcedure.attackSpin(world, x, y, z, entity);
                    break;
                }
                case 2: {
                    BullkindarOnEntityTickUpdateProcedure.attackSlam(world, x, y, z, entity);
                    break;
                }
                case 3: {
                    BullkindarOnEntityTickUpdateProcedure.attackStomp(world, x, y, z, entity);
                    break;
                }
                case 4: {
                    BullkindarOnEntityTickUpdateProcedure.attackSprint(world, x, y, z, entity);
                    break;
                }
                case 5: {
                    BullkindarOnEntityTickUpdateProcedure.attackBackKick(world, x, y, z, entity);
                }
            }
        }
    }

    private static void resetAttackState(Entity entity, int delayTicks) {
        JustInNetherMod.queueServerWork(delayTicks, () -> {
            entity.getPersistentData().m_128359_("canattack", "AGAIN");
            entity.getPersistentData().m_128347_("attacktype", 0.0);
            entity.getPersistentData().m_128347_("attackmount", 0.0);
        });
    }

    private static void applyAreaDamage(LevelAccessor world, Entity source, double x, double y, double z, double radius, float damage) {
        Vec3 center = new Vec3(x, y, z);
        List<Entity> targets = world.m_45976_(Entity.class, new AABB(center, center).m_82400_(radius / 2.0)).stream().filter(e -> e != source && !(e instanceof ItemEntity)).toList();
        for (Entity target : targets) {
            target.m_6469_(new DamageSource((Holder)world.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), target, source), damage);
        }
    }

    private static void attackSpin(LevelAccessor world, double x, double y, double z, Entity entity) {
        BullkindarOnEntityTickUpdateProcedure.setAnimation(entity, "spin");
        JustInNetherMod.queueServerWork(15, () -> BullkindarOnEntityTickUpdateProcedure.runRepeatedDamage(world, entity, x, y, z, 7.0, 16.0f, 3, 15));
        BullkindarOnEntityTickUpdateProcedure.resetAttackState(entity, 40);
    }

    private static void attackSlam(LevelAccessor world, double x, double y, double z, Entity entity) {
        BullkindarOnEntityTickUpdateProcedure.setAnimation(entity, "attack2");
        JustInNetherMod.queueServerWork(8, () -> BullkindarOnEntityTickUpdateProcedure.runRepeatedDamage(world, entity, x, y, z, 6.0, 8.0f, 3, 6));
        BullkindarOnEntityTickUpdateProcedure.resetAttackState(entity, 40);
    }

    private static void attackStomp(LevelAccessor world, double x, double y, double z, Entity entity) {
        BullkindarOnEntityTickUpdateProcedure.setAnimation(entity, "attack1");
        JustInNetherMod.queueServerWork(20, () -> {
            if (entity.m_6084_()) {
                BullkindarOnEntityTickUpdateProcedure.applyAreaDamage(world, entity, x, y, z, 7.0, 14.0f);
            }
        });
        BullkindarOnEntityTickUpdateProcedure.resetAttackState(entity, 40);
    }

    private static void attackSprint(LevelAccessor world, double x, double y, double z, Entity entity) {
        BullkindarOnEntityTickUpdateProcedure.setAnimation(entity, "attacksprint");
        if (entity.m_6084_()) {
            entity.m_20256_(entity.m_20184_().m_82542_(5.0, 1.0, 5.0));
            Vec3 center = new Vec3(x, y, z);
            List<Entity> targets = world.m_45976_(Entity.class, new AABB(center, center).m_82400_(4.0)).stream().filter(e -> e != entity && !(e instanceof ItemEntity)).toList();
            for (Entity target : targets) {
                target.m_6469_(new DamageSource((Holder)world.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), target, entity), 10.0f);
                Vec3 knockback = entity.m_20184_().m_82541_().m_82490_(1.5).m_82520_(0.0, 0.5, 0.0);
                target.m_20256_(knockback);
                target.f_19864_ = true;
                Entity finalTarget = target;
                JustInNetherMod.queueServerWork(30, () -> {
                    if (finalTarget.m_6084_()) {
                        Vec3 upward = finalTarget.m_20184_().m_82520_(0.0, 1.2, 0.0);
                        finalTarget.m_20256_(upward);
                        finalTarget.f_19864_ = true;
                    }
                });
            }
        }
        BullkindarOnEntityTickUpdateProcedure.resetAttackState(entity, 60);
    }

    private static void attackBackKick(LevelAccessor world, double x, double y, double z, Entity entity) {
        BullkindarOnEntityTickUpdateProcedure.setAnimation(entity, "attackbackkick");
        if (entity.m_6084_()) {
            BullkindarOnEntityTickUpdateProcedure.applyAreaDamage(world, entity, x, y, z, 8.0, 8.0f);
            JustInNetherMod.queueServerWork(30, () -> {
                if (entity.m_6084_()) {
                    BullkindarOnEntityTickUpdateProcedure.applyAreaDamage(world, entity, x, y, z, 7.0, 14.0f);
                }
            });
        }
        BullkindarOnEntityTickUpdateProcedure.resetAttackState(entity, 60);
    }

    private static void setAnimation(Entity entity, String animation) {
        if (entity instanceof BullkindarEntity) {
            BullkindarEntity bullkindar = (BullkindarEntity)entity;
            bullkindar.setAnimation("empty");
            bullkindar.setAnimation(animation);
        }
    }

    private static void runRepeatedDamage(final LevelAccessor world, final Entity entity, final double x, final double y, final double z, final double radius, final float damage, final int times, final int interval) {
        new Object(){

            void loop(int i) {
                if (entity.m_6084_()) {
                    BullkindarOnEntityTickUpdateProcedure.applyAreaDamage(world, entity, x, y, z, radius, damage);
                }
                if (i + 1 < times) {
                    JustInNetherMod.queueServerWork(interval, () -> this.loop(i + 1));
                }
            }
        }.loop(0);
    }
}

