/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.justinnether.procedures;

import java.util.List;
import net.mcreator.justinnether.JustInNetherMod;
import net.mcreator.justinnether.entity.PigmarEntity;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PigmarOnEntityTickUpdateProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null || !(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        LivingEntity target = mob.m_5448_();
        if (target == null || !target.m_6084_() || entity.getPersistentData().m_128471_("isAttacking")) {
            return;
        }
        double distance = entity.m_20270_((Entity)target);
        if (distance > 8.0) {
            return;
        }
        entity.getPersistentData().m_128379_("isAttacking", true);
        int attackType = Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)1, (int)6);
        if (entity instanceof PigmarEntity) {
            PigmarEntity pigmar = (PigmarEntity)entity;
            pigmar.setAnimation("empty");
        }
        switch (attackType) {
            case 1: {
                PigmarOnEntityTickUpdateProcedure.performJumpAttack(world, x, y, z, entity, (Entity)target);
                break;
            }
            case 2: {
                PigmarOnEntityTickUpdateProcedure.performSwingAttack(world, x, y, z, entity, (Entity)target);
                break;
            }
            case 3: {
                PigmarOnEntityTickUpdateProcedure.performSwingLeftAttack(world, x, y, z, entity, (Entity)target);
                break;
            }
            case 4: {
                PigmarOnEntityTickUpdateProcedure.performSwingRightAttack(world, x, y, z, entity, (Entity)target);
                break;
            }
            case 5: {
                PigmarOnEntityTickUpdateProcedure.performFrontAttack(world, x, y, z, entity, (Entity)target);
                break;
            }
            case 6: {
                PigmarOnEntityTickUpdateProcedure.performSpinAttack(world, x, y, z, entity, (Entity)target);
            }
        }
    }

    private static void performJumpAttack(LevelAccessor world, double x, double y, double z, Entity entity, Entity target) {
        if (entity instanceof PigmarEntity) {
            PigmarEntity pigmar = (PigmarEntity)entity;
            pigmar.setAnimation("attackjump");
        }
        entity.m_20256_(new Vec3(0.0, 1.2, 0.0));
        JustInNetherMod.queueServerWork(30, () -> {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123764_, x, y, z, 50, 3.0, 0.3, 3.0, 0.5);
            }
            PigmarOnEntityTickUpdateProcedure.attackNearby(world, x, y, z, entity, 5.0, 12.0f, 0.8);
        });
        PigmarOnEntityTickUpdateProcedure.resetAttackState(entity, 70);
    }

    private static void performSwingAttack(LevelAccessor world, double x, double y, double z, Entity entity, Entity target) {
        if (entity instanceof PigmarEntity) {
            PigmarEntity pigmar = (PigmarEntity)entity;
            pigmar.setAnimation("swing");
        }
        JustInNetherMod.queueServerWork(30, () -> PigmarOnEntityTickUpdateProcedure.attackNearby(world, x, y, z, entity, 6.0, 15.0f, 0.5));
        PigmarOnEntityTickUpdateProcedure.resetAttackState(entity, 60);
    }

    private static void performSwingLeftAttack(LevelAccessor world, double x, double y, double z, Entity entity, Entity target) {
        if (entity instanceof PigmarEntity) {
            PigmarEntity pigmar = (PigmarEntity)entity;
            pigmar.setAnimation("attackswingleft");
        }
        JustInNetherMod.queueServerWork(20, () -> PigmarOnEntityTickUpdateProcedure.attackNearby(world, x, y, z, entity, 4.0, 12.0f, 0.0));
        PigmarOnEntityTickUpdateProcedure.resetAttackState(entity, 40);
    }

    private static void performSwingRightAttack(LevelAccessor world, double x, double y, double z, Entity entity, Entity target) {
        if (entity instanceof PigmarEntity) {
            PigmarEntity pigmar = (PigmarEntity)entity;
            pigmar.setAnimation("attackswingright");
        }
        JustInNetherMod.queueServerWork(10, () -> PigmarOnEntityTickUpdateProcedure.attackNearby(world, x, y, z, entity, 4.0, 12.0f, 0.0));
        PigmarOnEntityTickUpdateProcedure.resetAttackState(entity, 40);
    }

    private static void performFrontAttack(final LevelAccessor world, final double x, final double y, final double z, final Entity entity, Entity target) {
        if (entity instanceof PigmarEntity) {
            PigmarEntity pigmar = (PigmarEntity)entity;
            pigmar.setAnimation("attackfront");
        }
        JustInNetherMod.queueServerWork(25, () -> new Object(){

            void timedLoop(int current, int total, int ticks) {
                Vec3 forward = entity.m_20154_();
                Vec3 pos = new Vec3(x + forward.f_82479_ * (double)current, y, z + forward.f_82481_ * (double)current);
                PigmarOnEntityTickUpdateProcedure.attackNearby(world, pos.f_82479_, pos.f_82480_, pos.f_82481_, entity, 1.5, 12.0f, 0.0);
                if (current + 1 < total) {
                    JustInNetherMod.queueServerWork(ticks, () -> this.timedLoop(current + 1, total, ticks));
                }
            }
        }.timedLoop(0, 6, 1));
        PigmarOnEntityTickUpdateProcedure.resetAttackState(entity, 70);
    }

    private static void performSpinAttack(LevelAccessor world, double x, double y, double z, Entity entity, Entity target) {
        if (entity instanceof PigmarEntity) {
            PigmarEntity pigmar = (PigmarEntity)entity;
            pigmar.setAnimation("attackspin");
        }
        JustInNetherMod.queueServerWork(10, () -> PigmarOnEntityTickUpdateProcedure.attackNearby(world, x, y, z, entity, 3.5, 15.0f, 0.0));
        PigmarOnEntityTickUpdateProcedure.resetAttackState(entity, 40);
    }

    private static void attackNearby(LevelAccessor world, double x, double y, double z, Entity entity, double radius, float damage, double yBoost) {
        Vec3 center = new Vec3(x, y, z);
        List targets = world.m_6443_(Entity.class, new AABB(center, center).m_82400_(radius), e -> e instanceof LivingEntity && e != entity && !(e instanceof ItemEntity));
        for (Entity target : targets) {
            target.m_6469_(new DamageSource((Holder)world.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), entity), damage);
            if (!(yBoost > 0.0)) continue;
            target.m_20256_(new Vec3(0.0, yBoost, 0.0));
        }
    }

    private static void resetAttackState(Entity entity, int delayTicks) {
        JustInNetherMod.queueServerWork(delayTicks, () -> entity.getPersistentData().m_128379_("isAttacking", false));
    }
}

