/*
 * Decompiled with CFR 0.152.
 */
package org.Netroaki.Main.handlers;

import com.mojang.datafixers.util.Pair;
import dev.architectury.event.events.common.LifecycleEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_4174;
import org.Netroaki.Main.HOReborn;
import org.Netroaki.Main.config.HungerOverhaulConfig;
import org.Netroaki.Main.util.FoodCategorizer;
import org.Netroaki.Main.util.FoodUtil;

public class FoodEventHandler {
    private static final Map<class_1792, class_4174> ORIGINAL_FOOD_PROPERTIES = new HashMap<class_1792, class_4174>();
    private static final Map<class_1792, Integer> ORIGINAL_MAX_STACK_SIZES = new HashMap<class_1792, Integer>();

    public static void register() {
        LifecycleEvent.SERVER_LEVEL_LOAD.register(FoodEventHandler::onServerStarting);
    }

    private static void onServerStarting(class_1937 level) {
        if (HungerOverhaulConfig.getInstance().food.modifyFoodStats) {
            FoodEventHandler.modifyFoodProperties();
        }
    }

    public static void onFoodConsumed(class_1657 player, class_1799 stack) {
        int foodValue;
        int duration;
        class_4174 food;
        if (HungerOverhaulConfig.getInstance().food.enableWellFedEffect && stack.method_19267() && (food = stack.method_7909().method_19264()) != null && (duration = FoodEventHandler.getWellFedDuration(foodValue = food.method_19230())) > 0) {
            class_1293 existingEffect = player.method_6112((class_1291)HOReborn.WELL_FED_EFFECT.get());
            int newDuration = existingEffect != null ? existingEffect.method_5584() + duration : duration;
            int newAmplifier = Math.min(existingEffect != null ? existingEffect.method_5578() + 1 : 0, 3);
            player.method_6092(new class_1293((class_1291)HOReborn.WELL_FED_EFFECT.get(), newDuration, newAmplifier));
        }
    }

    public static void onItemUse(class_1657 player, class_1799 stack) {
        class_4174 food;
        if (HungerOverhaulConfig.getInstance().food.modifyEatingSpeed && stack.method_19267() && (food = stack.method_7909().method_19264()) != null) {
            int foodValue = food.method_19230();
            int n = FoodEventHandler.getEatingDuration(foodValue);
        }
    }

    private static void modifyFoodProperties() {
        for (class_1792 item : FoodUtil.getAllFoodItems()) {
            if (item.method_19264() == null) continue;
            ORIGINAL_FOOD_PROPERTIES.put(item, item.method_19264());
            ORIGINAL_MAX_STACK_SIZES.put(item, item.method_7882());
        }
        if (HungerOverhaulConfig.getInstance().food.modifyFoodValues) {
            for (class_1792 item : FoodUtil.getAllFoodItems()) {
                class_4174 original = ORIGINAL_FOOD_PROPERTIES.get(item);
                if (original == null) continue;
                class_4174 modified = FoodEventHandler.createModifiedFoodProperties(item, original);
                FoodUtil.setFoodProperties(item, modified);
            }
        }
        if (HungerOverhaulConfig.getInstance().food.modifyStackSizes) {
            for (class_1792 item : FoodUtil.getAllFoodItems()) {
                class_4174 food = item.method_19264();
                if (food == null) continue;
                int newStackSize = FoodEventHandler.getStackSizeForFoodValue(food.method_19230());
                FoodUtil.setMaxStackSize(item, newStackSize);
            }
        }
    }

    private static class_4174 createModifiedFoodProperties(class_1792 item, class_4174 original) {
        int wfDuration;
        float saturation = original.method_19231();
        int nutrition = FoodCategorizer.categorizeFood(item, original);
        if (FoodCategorizer.isModFood(item)) {
            nutrition = (int)Math.max(1.0, Math.floor((double)nutrition / HungerOverhaulConfig.getInstance().food.modFoodValueDivider));
            saturation /= (float)HungerOverhaulConfig.getInstance().food.modFoodValueDivider;
        }
        class_4174.class_4175 builder = new class_4174.class_4175().method_19238(nutrition).method_19237(saturation);
        if (original.method_19232()) {
            builder.method_19236();
        }
        if (original.method_19233()) {
            builder.method_19240();
        }
        if (original.method_19234()) {
            builder.method_19241();
        }
        for (Pair pair : original.method_19235()) {
            class_1293 inst = (class_1293)pair.getFirst();
            float chance = ((Float)pair.getSecond()).floatValue();
            if (inst == null || !(chance > 0.0f)) continue;
            class_1293 copy = new class_1293(inst);
            builder.method_19239(copy, chance);
        }
        if (HungerOverhaulConfig.getInstance().food.enableWellFedEffect && (wfDuration = FoodEventHandler.getWellFedDuration(nutrition)) > 0) {
            builder.method_19239(new class_1293((class_1291)HOReborn.WELL_FED_EFFECT.get(), wfDuration, 0), 1.0f);
        }
        return builder.method_19242();
    }

    private static int getWellFedDuration(int foodValue) {
        if (foodValue >= 14) {
            return 480;
        }
        if (foodValue >= 10) {
            return 240;
        }
        if (foodValue >= 7) {
            return 120;
        }
        if (foodValue >= 4) {
            return 40;
        }
        return 0;
    }

    public static int getEatingDuration(int foodValue) {
        if (foodValue >= 14) {
            return 64;
        }
        if (foodValue >= 10) {
            return 48;
        }
        if (foodValue >= 7) {
            return 32;
        }
        if (foodValue >= 4) {
            return 24;
        }
        return 16;
    }

    private static int getStackSizeForFoodValue(int foodValue) {
        if (foodValue >= 14) {
            return 1;
        }
        if (foodValue >= 10) {
            return 4;
        }
        if (foodValue >= 7) {
            return 8;
        }
        if (foodValue >= 4) {
            return 16;
        }
        return 32;
    }

    public static String getFoodDescription(int foodValue, float saturation) {
        return FoodCategorizer.getFoodCategoryDescription(foodValue);
    }
}

