/*
 * Decompiled with CFR 0.152.
 */
package org.Netroaki.Main.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import net.minecraft.class_1792;
import net.minecraft.class_7923;

public class HORConfig {
    private static final String CONFIG_FILE = "hunger_overhaul_reborn.properties";
    private static final String CONFIG_DIR = "config";
    private static final int DEFAULT_BOWL_STACK_SIZE = 16;
    private static final int DEFAULT_BOTTLE_STACK_SIZE = 8;
    private static final int DEFAULT_BUCKET_STACK_SIZE = 4;
    private static final int DEFAULT_CONTAINER_STACK_SIZE = 8;
    private int bowlStackSize = 16;
    private int bottleStackSize = 8;
    private int bucketStackSize = 4;
    private int defaultContainerStackSize = 8;
    private static HORConfig INSTANCE;

    private HORConfig() {
    }

    public static HORConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HORConfig();
        }
        return INSTANCE;
    }

    public void load(String gameDirectory) {
        Path configPath = Paths.get(gameDirectory, CONFIG_DIR, CONFIG_FILE);
        Properties props = new Properties();
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            if (Files.exists(configPath, new LinkOption[0])) {
                try (InputStream input = Files.newInputStream(configPath, new OpenOption[0]);){
                    props.load(input);
                    this.bowlStackSize = Integer.parseInt(props.getProperty("containerFood.bowl.stackSize", String.valueOf(16)));
                    this.bottleStackSize = Integer.parseInt(props.getProperty("containerFood.bottle.stackSize", String.valueOf(8)));
                    this.bucketStackSize = Integer.parseInt(props.getProperty("containerFood.bucket.stackSize", String.valueOf(4)));
                    this.defaultContainerStackSize = Integer.parseInt(props.getProperty("containerFood.default.stackSize", String.valueOf(8)));
                }
            }
            props.setProperty("containerFood.bowl.stackSize", String.valueOf(16));
            props.setProperty("containerFood.bottle.stackSize", String.valueOf(8));
            props.setProperty("containerFood.bucket.stackSize", String.valueOf(4));
            props.setProperty("containerFood.default.stackSize", String.valueOf(8));
            try (OutputStream output = Files.newOutputStream(configPath, new OpenOption[0]);){
                props.store(output, "Hunger Overhaul Reborn Configuration\nContainer Food Stack Sizes:\n  containerFood.bowl.stackSize: Stack size for foods with bowl containers (mushroom stew, rabbit stew, etc.) Default: 16\n  containerFood.bottle.stackSize: Stack size for foods with bottle containers (honey bottles, potions, etc.) Default: 8\n  containerFood.bucket.stackSize: Stack size for foods with bucket containers (milk buckets, etc.) Default: 4\n  containerFood.default.stackSize: Stack size for other container foods Default: 8\nValid range: 1-64");
            }
            this.bowlStackSize = 16;
            this.bottleStackSize = 8;
            this.bucketStackSize = 4;
            this.defaultContainerStackSize = 8;
            this.bowlStackSize = Math.max(1, Math.min(64, this.bowlStackSize));
            this.bottleStackSize = Math.max(1, Math.min(64, this.bottleStackSize));
            this.bucketStackSize = Math.max(1, Math.min(64, this.bucketStackSize));
            this.defaultContainerStackSize = Math.max(1, Math.min(64, this.defaultContainerStackSize));
        }
        catch (IOException e) {
            this.bowlStackSize = 16;
            this.bottleStackSize = 8;
            this.bucketStackSize = 4;
            this.defaultContainerStackSize = 8;
        }
        catch (NumberFormatException e) {
            this.bowlStackSize = 16;
            this.bottleStackSize = 8;
            this.bucketStackSize = 4;
            this.defaultContainerStackSize = 8;
        }
    }

    public int getBowlStackSize() {
        return this.bowlStackSize;
    }

    public int getBottleStackSize() {
        return this.bottleStackSize;
    }

    public int getBucketStackSize() {
        return this.bucketStackSize;
    }

    public int getDefaultContainerStackSize() {
        return this.defaultContainerStackSize;
    }

    public int getStackSizeForContainer(class_1792 containerItem) {
        if (containerItem == null) {
            return this.defaultContainerStackSize;
        }
        String itemId = class_7923.field_41178.method_10221((Object)containerItem).toString();
        if (itemId.contains("bowl")) {
            return this.bowlStackSize;
        }
        if (itemId.contains("bottle") || itemId.contains("potion")) {
            return this.bottleStackSize;
        }
        if (itemId.contains("bucket")) {
            return this.bucketStackSize;
        }
        return this.defaultContainerStackSize;
    }
}

