/*
 * Decompiled with CFR 0.152.
 */
package org.Netroaki.Main.handlers;

import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.platform.Platform;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1267;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import org.Netroaki.Main.HOReborn;
import org.Netroaki.Main.config.HungerOverhaulConfig;

public class PlayerEventHandler {
    private static final int BASE_HUNGER_TICK_RATE = 24000;
    private static int hungerTickCounter = 0;
    private static final Map<UUID, Integer> wellFedRegenTicksRemaining = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> lastWellFedAmplifier = new HashMap<UUID, Integer>();

    public static void register() {
        TickEvent.PLAYER_PRE.register(PlayerEventHandler::onPlayerTick);
        PlayerEvent.PLAYER_RESPAWN.register(PlayerEventHandler::onPlayerRespawn);
        PlayerEvent.PLAYER_JOIN.register(PlayerEventHandler::onPlayerJoin);
    }

    private static void onPlayerTick(class_1657 player) {
        int baseHealInterval;
        int healInterval;
        long gameTime;
        int threshold;
        int interval;
        if (player.method_37908().method_8608()) {
            return;
        }
        HungerOverhaulConfig config = HungerOverhaulConfig.getInstance();
        class_1937 level = player.method_37908();
        double hungerSpeed = 1.0;
        double healSpeed = 1.0;
        switch (level.method_8407()) {
            case field_5801: 
            case field_5805: {
                hungerSpeed = 0.75;
                healSpeed = 0.75;
                break;
            }
            case field_5802: {
                hungerSpeed = 1.0;
                healSpeed = 1.0;
                break;
            }
            case field_5807: {
                hungerSpeed = 1.5;
                healSpeed = 1.5;
            }
        }
        if (config.hunger.harvestCraftHungerLossIncrease && Platform.isModLoaded((String)"harvestcraft")) {
            hungerSpeed *= config.hunger.harvestCraftHungerLossMultiplier;
        }
        if (config.hunger.constantHungerLoss && ++hungerTickCounter >= (interval = (int)Math.max(1L, Math.round(24000.0 / hungerSpeed)))) {
            hungerTickCounter = 0;
            class_1702 foodData = player.method_7344();
            if (foodData.method_7586() > 0) {
                foodData.method_7580(foodData.method_7586() - 1);
            }
        }
        class_1702 foodData = player.method_7344();
        int foodLevel = foodData.method_7586();
        if (config.hunger.lowHungerEffects) {
            int desiredAmplifier = -1;
            if (foodLevel <= 2) {
                desiredAmplifier = 2;
            } else if (foodLevel <= 4) {
                desiredAmplifier = 1;
            } else if (foodLevel <= 6) {
                desiredAmplifier = 0;
            }
            if (desiredAmplifier >= 0) {
                class_1293 current = player.method_6112((class_1291)HOReborn.HUNGRY_EFFECT.get());
                if (current == null || current.method_5578() != desiredAmplifier) {
                    player.method_6016((class_1291)HOReborn.HUNGRY_EFFECT.get());
                    player.method_6092(new class_1293((class_1291)HOReborn.HUNGRY_EFFECT.get(), Integer.MAX_VALUE, desiredAmplifier, false, true, true));
                }
            } else {
                player.method_6016((class_1291)HOReborn.HUNGRY_EFFECT.get());
            }
        }
        if (config.health.healthHealsAboveThreeShanks && player.method_6032() < player.method_6063() && foodLevel >= (threshold = Math.max(0, config.health.healthHealingThreshold)) && (gameTime = level.method_8510()) % (long)(healInterval = (int)Math.max(1L, Math.round((double)(baseHealInterval = 120) / healSpeed))) == 0L) {
            player.method_6025(1.0f);
        }
        class_1291 wellFed = (class_1291)HOReborn.WELL_FED_EFFECT.get();
        class_1293 wf = player.method_6112(wellFed);
        UUID id = player.method_5667();
        if (wf != null) {
            Integer ticks;
            int amp = wf.method_5578();
            Integer lastAmp = lastWellFedAmplifier.get(id);
            if (lastAmp == null || lastAmp != amp) {
                wellFedRegenTicksRemaining.put(id, 20);
                lastWellFedAmplifier.put(id, amp);
            }
            if ((ticks = wellFedRegenTicksRemaining.get(id)) != null && ticks > 0) {
                if (ticks % 10 == 0 && player.method_6032() < player.method_6063()) {
                    player.method_6025(1.0f);
                }
                wellFedRegenTicksRemaining.put(id, ticks - 1);
            }
        } else {
            lastWellFedAmplifier.remove(id);
            wellFedRegenTicksRemaining.remove(id);
        }
        if (foodLevel <= 0 && config.hunger.instantDeathOnZeroHunger) {
            player.method_5643(player.method_48923().method_48825(), Float.MAX_VALUE);
        }
    }

    private static void onPlayerRespawn(class_3222 player, boolean conqueredEnd) {
        HungerOverhaulConfig config = HungerOverhaulConfig.getInstance();
        if (config.hunger.modifyRespawnHunger) {
            int respawnHunger = PlayerEventHandler.getRespawnHungerValue(player.method_37908().method_8407());
            player.method_7344().method_7580(respawnHunger);
        }
    }

    private static void onPlayerJoin(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            PlayerEventHandler.onPlayerRespawn(serverPlayer, false);
        }
    }

    private static int getRespawnHungerValue(class_1267 difficulty) {
        HungerOverhaulConfig config = HungerOverhaulConfig.getInstance();
        int baseHunger = config.hunger.respawnHungerValue;
        int modifier = config.hunger.respawnHungerDifficultyModifier;
        switch (difficulty) {
            case field_5801: 
            case field_5805: {
                return baseHunger;
            }
            case field_5802: {
                return baseHunger - modifier;
            }
            case field_5807: {
                return baseHunger - modifier * 2;
            }
        }
        return baseHunger;
    }
}

