/*
 * Decompiled with CFR 0.152.
 */
package org.Netroaki.Main.modules;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.LifecycleEvent;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import org.Netroaki.Main.HOReborn;
import org.Netroaki.Main.config.HungerOverhaulConfig;
import org.Netroaki.Main.util.SereneSeasonsAPI;

public class SereneSeasonsModule {
    private static boolean compatibilityEnabled = true;

    public void init() {
        HOReborn.LOGGER.info("Initializing Serene Seasons compatibility module");
        LifecycleEvent.SERVER_LEVEL_LOAD.register(this::onServerStarting);
    }

    private void onServerStarting(class_1937 level) {
        if (SereneSeasonsAPI.isAvailable() && compatibilityEnabled) {
            HOReborn.LOGGER.info("Serene Seasons compatibility: Active");
            HOReborn.LOGGER.info("Current season: " + SereneSeasonsAPI.getSeasonName(level));
        }
    }

    public EventResult onCropRandomTick(class_1937 level, class_2338 pos, class_2680 state) {
        if (level.method_8608() || !SereneSeasonsAPI.isAvailable() || !compatibilityEnabled) {
            return EventResult.pass();
        }
        class_2248 block = state.method_26204();
        if (!(block instanceof class_2302)) {
            return EventResult.pass();
        }
        SereneSeasonsAPI.SeasonInfo seasonInfo = SereneSeasonsAPI.getCurrentSeason(level);
        if (seasonInfo == null) {
            return this.applyHungerOverhaulLogic(level, pos, state);
        }
        boolean shouldGrow = this.shouldCropGrowInSeason(seasonInfo, level, pos, state);
        if (!shouldGrow) {
            return EventResult.interrupt((Boolean)false);
        }
        return this.applyHungerOverhaulLogic(level, pos, state);
    }

    private boolean shouldCropGrowInSeason(SereneSeasonsAPI.SeasonInfo seasonInfo, class_1937 level, class_2338 pos, class_2680 state) {
        HungerOverhaulConfig config = HungerOverhaulConfig.getInstance();
        if (!config.crops.respectSeasonalGrowth) {
            return true;
        }
        return SereneSeasonsAPI.shouldCropsGrow(level, pos, state);
    }

    private EventResult applyHungerOverhaulLogic(class_1937 level, class_2338 pos, class_2680 state) {
        HungerOverhaulConfig config = HungerOverhaulConfig.getInstance();
        if (config.crops.cropsOnlyGrowInDaylight) {
            int sky = level.method_8314(class_1944.field_9284, pos);
            if (!level.method_8530() || sky < 9) {
                return EventResult.interrupt((Boolean)false);
            }
        }
        if (config.crops.cropsTakeLongerToGrow) {
            class_5819 random = level.method_8409();
            double multiplier = config.crops.cropGrowthMultiplier;
            multiplier = SereneSeasonsAPI.calculateGrowthMultiplier(level, multiplier);
            if (random.method_43058() > multiplier) {
                return EventResult.interrupt((Boolean)false);
            }
        }
        return EventResult.pass();
    }

    public static boolean isSereneSeasonsLoaded() {
        return SereneSeasonsAPI.isAvailable();
    }

    public static void setCompatibilityEnabled(boolean enabled) {
        compatibilityEnabled = enabled;
        if (SereneSeasonsAPI.isAvailable()) {
            HOReborn.LOGGER.info("Serene Seasons compatibility " + (enabled ? "enabled" : "disabled"));
        }
    }

    public static boolean isCompatibilityEnabled() {
        return compatibilityEnabled;
    }
}

