/*
 * Decompiled with CFR 0.152.
 */
package org.Netroaki.Main.util;

import java.util.Arrays;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import org.Netroaki.Main.HOReborn;

public class CompatibilityUtil {
    private static final List<String> GROWTH_MOD_IDS = Arrays.asList("sereneseasons", "croptopia", "agricraft", "mysticalagriculture", "botania", "immersiveengineering", "thermal_cultivation", "create", "farmersdelight", "harvestcraft");
    private static boolean growthModsDetected = false;
    private static String detectedMods = "";

    public static void detectGrowthMods() {
        if (!growthModsDetected) {
            StringBuilder detected = new StringBuilder();
            if (FabricLoader.getInstance().isModLoaded("fabric")) {
                for (String modId : GROWTH_MOD_IDS) {
                    if (!FabricLoader.getInstance().isModLoaded(modId)) continue;
                    detected.append(modId).append(" ");
                    HOReborn.LOGGER.info("Detected growth mod: " + modId);
                }
            }
            try {
                Class<?> modListClass = Class.forName("net.minecraftforge.fml.ModList");
                Object modList = modListClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
                if (modList != null) {
                    for (String modId : GROWTH_MOD_IDS) {
                        boolean isLoaded = (Boolean)modListClass.getMethod("isLoaded", String.class).invoke(modList, modId);
                        if (!isLoaded) continue;
                        detected.append(modId).append(" ");
                        HOReborn.LOGGER.info("Detected growth mod: " + modId);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            detectedMods = detected.toString().trim();
            growthModsDetected = true;
            if (!detectedMods.isEmpty()) {
                HOReborn.LOGGER.warn("Detected crop growth mods: " + detectedMods);
                HOReborn.LOGGER.warn("Consider disabling crop growth modifications in Hunger Overhaul Reborn config to avoid conflicts");
            }
        }
    }

    public static boolean hasGrowthMods() {
        return !detectedMods.isEmpty();
    }

    public static String getDetectedMods() {
        return detectedMods;
    }

    public static boolean shouldDisableCropGrowthModifications(boolean autoDetect, boolean manualDisable) {
        if (manualDisable) {
            return true;
        }
        if (autoDetect) {
            CompatibilityUtil.detectGrowthMods();
            return CompatibilityUtil.hasGrowthMods();
        }
        return false;
    }
}

