/*
 * Decompiled with CFR 0.152.
 */
package org.Netroaki.Main.util;

import java.util.concurrent.atomic.AtomicLong;
import org.Netroaki.Main.HOReborn;

public final class DebugMetrics {
    private static final long LOG_INTERVAL_MS = 10000L;
    private static final AtomicLong windowAttempts = new AtomicLong();
    private static final AtomicLong windowAllowed = new AtomicLong();
    private static final AtomicLong windowDaylightBlocked = new AtomicLong();
    private static final AtomicLong windowStrengthBlocked = new AtomicLong();
    private static final AtomicLong windowRandomRejected = new AtomicLong();
    private static final AtomicLong totalAttempts = new AtomicLong();
    private static final AtomicLong totalAllowed = new AtomicLong();
    private static final AtomicLong totalDaylightBlocked = new AtomicLong();
    private static final AtomicLong totalStrengthBlocked = new AtomicLong();
    private static final AtomicLong totalRandomRejected = new AtomicLong();
    private static volatile long lastLogMs = System.currentTimeMillis();
    private static volatile String lastSeason = "UNKNOWN";
    private static volatile float lastSeasonStrength = -1.0f;
    private static volatile double lastBaseMultiplier = -1.0;
    private static volatile double lastAdjustedMultiplier = -1.0;

    private DebugMetrics() {
    }

    public static void updateContext(String seasonName, float seasonStrength, double baseMultiplier, double adjustedMultiplier) {
        lastSeason = seasonName;
        lastSeasonStrength = seasonStrength;
        lastBaseMultiplier = baseMultiplier;
        lastAdjustedMultiplier = adjustedMultiplier;
    }

    public static void recordAttempt() {
        windowAttempts.incrementAndGet();
        totalAttempts.incrementAndGet();
        DebugMetrics.maybeLog();
    }

    public static void recordAllowed() {
        windowAllowed.incrementAndGet();
        totalAllowed.incrementAndGet();
        DebugMetrics.maybeLog();
    }

    public static void recordDaylightBlocked() {
        windowDaylightBlocked.incrementAndGet();
        totalDaylightBlocked.incrementAndGet();
        DebugMetrics.maybeLog();
    }

    public static void recordStrengthBlocked() {
        windowStrengthBlocked.incrementAndGet();
        totalStrengthBlocked.incrementAndGet();
        DebugMetrics.maybeLog();
    }

    public static void recordRandomRejected() {
        windowRandomRejected.incrementAndGet();
        totalRandomRejected.incrementAndGet();
        DebugMetrics.maybeLog();
    }

    public static synchronized void maybeLog() {
        long now = System.currentTimeMillis();
        if (now - lastLogMs < 10000L) {
            return;
        }
        long wa = windowAttempts.getAndSet(0L);
        long wl = windowAllowed.getAndSet(0L);
        long wd = windowDaylightBlocked.getAndSet(0L);
        long ws = windowStrengthBlocked.getAndSet(0L);
        long wr = windowRandomRejected.getAndSet(0L);
        double acceptRate = wa > 0L ? (double)wl / (double)wa : 0.0;
        HOReborn.LOGGER.info(String.format("[HOR Debug] 10s window: attempts=%d allowed=%d daylight_block=%d winter_strength_block=%d prob_reject=%d accept_rate=%.3f season=%s strength=%.2f base=%.3f adjusted=%.3f total_attempts=%d total_allowed=%d", wa, wl, wd, ws, wr, acceptRate, lastSeason, Float.valueOf(lastSeasonStrength), lastBaseMultiplier, lastAdjustedMultiplier, totalAttempts.get(), totalAllowed.get()));
        lastLogMs = now;
    }

    public static String getGrowthStats() {
        return String.format("Season: %s (strength %.2f), Base: %.3f, Adjusted: %.3f, Total Attempts: %d, Total Allowed: %d, Total Daylight Blocked: %d, Total Winter Strength Blocked: %d, Total Probability Rejected: %d", lastSeason, Float.valueOf(lastSeasonStrength), lastBaseMultiplier, lastAdjustedMultiplier, totalAttempts.get(), totalAllowed.get(), totalDaylightBlocked.get(), totalStrengthBlocked.get(), totalRandomRejected.get());
    }

    public static String currentContextSummary() {
        return String.format("[HOR Debug] season=%s strength=%.2f base=%.3f adjusted=%.3f attempts=%d allowed=%d daylight_block=%d winter_strength_block=%d prob_reject=%d", lastSeason, Float.valueOf(lastSeasonStrength), lastBaseMultiplier, lastAdjustedMultiplier, totalAttempts.get(), totalAllowed.get(), totalDaylightBlocked.get(), totalStrengthBlocked.get(), totalRandomRejected.get());
    }

    public static void reset() {
        windowAttempts.set(0L);
        windowAllowed.set(0L);
        windowDaylightBlocked.set(0L);
        windowStrengthBlocked.set(0L);
        windowRandomRejected.set(0L);
        totalAttempts.set(0L);
        totalAllowed.set(0L);
        totalDaylightBlocked.set(0L);
        totalStrengthBlocked.set(0L);
        totalRandomRejected.set(0L);
        lastLogMs = System.currentTimeMillis();
        lastSeason = "UNKNOWN";
        lastSeasonStrength = -1.0f;
        lastBaseMultiplier = -1.0;
        lastAdjustedMultiplier = -1.0;
    }
}

