/*
 * Decompiled with CFR 0.152.
 */
package org.Netroaki.Main.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_4174;
import org.Netroaki.Main.util.FoodUtil;

public class FoodCategorizer {
    private static final Map<class_1792, FoodCategory> SPECIFIC_CATEGORIES = new HashMap<class_1792, FoodCategory>();

    public static int categorizeFood(class_1792 item, class_4174 originalProperties) {
        FoodCategory specificCategory = SPECIFIC_CATEGORIES.get(item);
        if (specificCategory != null) {
            return specificCategory.getNutritionValue();
        }
        int originalNutrition = originalProperties.method_19230();
        if (originalNutrition <= 2) {
            return FoodCategory.RAW_FOOD.getNutritionValue();
        }
        if (originalNutrition <= 4) {
            return FoodCategory.COOKED_FOOD.getNutritionValue();
        }
        if (originalNutrition <= 6) {
            return FoodCategory.LIGHT_MEAL.getNutritionValue();
        }
        if (originalNutrition <= 8) {
            return FoodCategory.AVERAGE_MEAL.getNutritionValue();
        }
        if (originalNutrition <= 12) {
            return FoodCategory.LARGE_MEAL.getNutritionValue();
        }
        return FoodCategory.FEAST.getNutritionValue();
    }

    public static String getFoodCategoryDescription(int nutritionValue) {
        if (nutritionValue >= 10) {
            return "Feast";
        }
        if (nutritionValue >= 8) {
            return "Large Meal";
        }
        if (nutritionValue >= 6) {
            return "Nourishing Meal";
        }
        if (nutritionValue >= 4) {
            return "Light Meal";
        }
        if (nutritionValue >= 2) {
            return "Cooked Food";
        }
        return "Raw Food";
    }

    public static boolean isModFood(class_1792 item) {
        return FoodUtil.isModFood(item);
    }

    static {
        SPECIFIC_CATEGORIES.put(class_1802.field_8861, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8179, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8567, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8186, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8279, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_16998, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_28659, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8233, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8497, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_17518, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8046, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8389, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8726, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8748, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8504, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8429, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8209, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8846, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8511, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8680, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8635, FoodCategory.RAW_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8176, FoodCategory.COOKED_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8261, FoodCategory.COOKED_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8544, FoodCategory.COOKED_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8347, FoodCategory.COOKED_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8752, FoodCategory.COOKED_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8373, FoodCategory.COOKED_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8509, FoodCategory.COOKED_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8512, FoodCategory.COOKED_FOOD);
        SPECIFIC_CATEGORIES.put(class_1802.field_8229, FoodCategory.LIGHT_MEAL);
        SPECIFIC_CATEGORIES.put(class_1802.field_8423, FoodCategory.LIGHT_MEAL);
        SPECIFIC_CATEGORIES.put(class_1802.field_17534, FoodCategory.LIGHT_MEAL);
        SPECIFIC_CATEGORIES.put(class_1802.field_8741, FoodCategory.LIGHT_MEAL);
        SPECIFIC_CATEGORIES.put(class_1802.field_8463, FoodCategory.LIGHT_MEAL);
        SPECIFIC_CATEGORIES.put(class_1802.field_8367, FoodCategory.LIGHT_MEAL);
        SPECIFIC_CATEGORIES.put(class_1802.field_8551, FoodCategory.LIGHT_MEAL);
        SPECIFIC_CATEGORIES.put(class_1802.field_20417, FoodCategory.LIGHT_MEAL);
        SPECIFIC_CATEGORIES.put(class_1802.field_8208, FoodCategory.LIGHT_MEAL);
        SPECIFIC_CATEGORIES.put(class_1802.field_8515, FoodCategory.LIGHT_MEAL);
        SPECIFIC_CATEGORIES.put(class_1802.field_8308, FoodCategory.AVERAGE_MEAL);
        SPECIFIC_CATEGORIES.put(class_1802.field_8766, FoodCategory.AVERAGE_MEAL);
    }

    public static enum FoodCategory {
        RAW_FOOD(1),
        COOKED_FOOD(2),
        LIGHT_MEAL(4),
        AVERAGE_MEAL(6),
        LARGE_MEAL(8),
        FEAST(10);

        private final int nutritionValue;

        private FoodCategory(int nutritionValue) {
            this.nutritionValue = nutritionValue;
        }

        public int getNutritionValue() {
            return this.nutritionValue;
        }
    }
}

