/*
 * Decompiled with CFR 0.152.
 */
package org.Netroaki.Main.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_4174;
import net.minecraft.class_7923;

public class FoodUtil {
    public static List<class_1792> getAllFoodItems() {
        ArrayList<class_1792> foodItems = new ArrayList<class_1792>();
        for (class_1792 item : class_7923.field_41178) {
            if (item.method_19264() == null) continue;
            foodItems.add(item);
        }
        return foodItems;
    }

    public static boolean isModFood(class_4174 food) {
        return false;
    }

    public static boolean isModFood(class_1792 item) {
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        if (id == null) {
            return false;
        }
        String namespace = id.method_12836();
        return !namespace.equals("minecraft");
    }

    public static void setFoodProperties(class_1792 item, class_4174 properties) {
        try {
            String[] possibleFieldNames;
            Field foodPropertiesField = null;
            for (String fieldName : possibleFieldNames = new String[]{"foodProperties", "food", "foodData"}) {
                try {
                    foodPropertiesField = class_1792.class.getDeclaredField(fieldName);
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
            }
            if (foodPropertiesField != null) {
                foodPropertiesField.setAccessible(true);
                foodPropertiesField.set(item, properties);
            } else {
                System.err.println("Could not find food properties field for " + String.valueOf(item));
            }
        }
        catch (Exception e) {
            System.err.println("Failed to set food properties for " + String.valueOf(item) + ": " + e.getMessage());
        }
    }

    public static void setMaxStackSize(class_1792 item, int maxStackSize) {
        try {
            String[] possibleFieldNames;
            Field maxStackSizeField = null;
            for (String fieldName : possibleFieldNames = new String[]{"maxStackSize", "maxCount", "maxStack"}) {
                try {
                    maxStackSizeField = class_1792.class.getDeclaredField(fieldName);
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
            }
            if (maxStackSizeField != null) {
                maxStackSizeField.setAccessible(true);
                maxStackSizeField.set(item, maxStackSize);
            } else {
                System.err.println("Could not find max stack size field for " + String.valueOf(item));
            }
        }
        catch (Exception e) {
            System.err.println("Failed to set max stack size for " + String.valueOf(item) + ": " + e.getMessage());
        }
    }

    public static String getFoodDescription(class_1799 stack) {
        class_4174 food = stack.method_7909().method_19264();
        if (food == null) {
            return "";
        }
        int nutrition = food.method_19230();
        float saturation = food.method_19231();
        return FoodUtil.getFoodDescription(nutrition, saturation);
    }

    public static String getFoodDescription(int nutrition, float saturation) {
        if (nutrition >= 14) {
            return "Feast";
        }
        if (nutrition >= 10) {
            return "Large Meal";
        }
        if (nutrition >= 7) {
            return "Nourishing Meal";
        }
        if (nutrition >= 4) {
            return "Light Meal";
        }
        if (nutrition >= 2) {
            return "Snack";
        }
        return "Morsel";
    }

    public static int getWellFedDuration(int foodValue) {
        if (foodValue >= 14) {
            return 480;
        }
        if (foodValue >= 10) {
            return 240;
        }
        if (foodValue >= 7) {
            return 120;
        }
        if (foodValue >= 4) {
            return 40;
        }
        return 0;
    }

    public static int getEatingDuration(int foodValue) {
        if (foodValue >= 14) {
            return 64;
        }
        if (foodValue >= 10) {
            return 48;
        }
        if (foodValue >= 7) {
            return 32;
        }
        if (foodValue >= 4) {
            return 24;
        }
        return 16;
    }

    public static int getStackSizeForFoodValue(int foodValue) {
        if (foodValue >= 14) {
            return 1;
        }
        if (foodValue >= 10) {
            return 4;
        }
        if (foodValue >= 7) {
            return 8;
        }
        if (foodValue >= 4) {
            return 16;
        }
        return 32;
    }

    public static boolean isHarvestCraftFood(class_1792 item) {
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        return id != null && id.method_12836().equals("harvestcraft");
    }
}

